/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsxe.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;

public class Log {
    public static final int MAXLINES = 500;
    public static final int DEBUG = 1;
    public static final int MESSAGE = 3;
    public static final int NOTICE = 5;
    public static final int WARNING = 7;
    public static final int ERROR = 9;
    private static Object LOCK = new Object();
    private static Document logDocument;
    private static int level;
    private static boolean debug;
    private static Writer stream;
    private static String lineSep;
    private static PrintStream realOut;
    private static PrintStream realErr;
    static /* synthetic */ Class class$net$sourceforge$jsxe$util$Log;

    private Log() {
    }

    public static void init(boolean stdio, int level, boolean debug) {
        if (stdio && System.out == realOut && System.err == realErr) {
            System.setOut(Log.createPrintStream(5, null));
            System.setErr(Log.createPrintStream(9, null));
        }
        Log.level = level;
        Log.debug = debug;
        Log.log(3, class$net$sourceforge$jsxe$util$Log == null ? (class$net$sourceforge$jsxe$util$Log = Log.class$("net.sourceforge.jsxe.util.Log")) : class$net$sourceforge$jsxe$util$Log, "When reporting bugs, please include the following information:");
        String[] props = new String[]{"java.version", "java.vm.version", "java.runtime.version", "java.vendor", "java.compiler", "os.name", "os.version", "os.arch", "user.home", "java.home", "java.class.path"};
        for (int i = 0; i < props.length; ++i) {
            Log.log(3, class$net$sourceforge$jsxe$util$Log == null ? Log.class$("net.sourceforge.jsxe.util.Log") : class$net$sourceforge$jsxe$util$Log, props[i] + "=" + System.getProperty(props[i]));
        }
    }

    public static void setLogWriter(Writer stream) {
        if (Log.stream == null && stream != null) {
            try {
                stream.write(logDocument.getText(0, logDocument.getLength()));
                stream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.stream = stream;
    }

    public static Document getLogDocument() {
        return logDocument;
    }

    public static void flushStream() {
        if (stream != null) {
            try {
                stream.flush();
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    public static void closeStream() {
        if (stream != null) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException io) {
                io.printStackTrace(realErr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int urgency, Object source, Object message) {
        int index;
        String _source;
        if (source == null) {
            _source = Thread.currentThread().getName();
            if (_source == null) {
                _source = Thread.currentThread().getClass().getName();
            }
        } else {
            _source = source instanceof Class ? ((Class)source).getName() : source.getClass().getName();
        }
        if ((index = _source.lastIndexOf(46)) != -1) {
            _source = _source.substring(index + 1);
        }
        if (message instanceof Throwable) {
            Log._logException(urgency, source, (Throwable)message);
        } else {
            String _message = String.valueOf(message);
            Object object = LOCK;
            synchronized (object) {
                StringTokenizer st = new StringTokenizer(_message, "\r\n");
                while (st.hasMoreTokens()) {
                    Log._log(urgency, _source, st.nextToken());
                }
            }
        }
    }

    public static void setDebug(boolean debug) {
        Log.debug = debug;
    }

    private static PrintStream createPrintStream(final int urgency, final Object source) {
        return new PrintStream(new OutputStream(){

            public void write(int b) {
                byte[] barray = new byte[]{(byte)b};
                this.write(barray, 0, 1);
            }

            public void write(byte[] b, int off, int len) {
                String str = new String(b, off, len);
                Log.log(urgency, source, str);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _logException(int urgency, Object source, Throwable message) {
        PrintStream out = Log.createPrintStream(urgency, source);
        Object object = LOCK;
        synchronized (object) {
            message.printStackTrace(out);
        }
    }

    private static void _log(int urgency, String source, String message) {
        String urgencyString = "[" + Log.urgencyToString(urgency) + "] ";
        String fullMessage = urgencyString + source + ": " + message;
        try {
            logDocument.insertString(logDocument.getLength(), fullMessage, null);
            logDocument.insertString(logDocument.getLength(), "\n", null);
            Element map = logDocument.getDefaultRootElement();
            int lines = map.getElementCount();
            if (lines > 500) {
                Element first = map.getElement(0);
                Element last = map.getElement(lines - 500);
                logDocument.remove(first.getStartOffset(), last.getEndOffset());
            }
            if (stream != null && (urgency != 1 || urgency == 1 && debug)) {
                stream.write(fullMessage);
                stream.write(lineSep);
            }
        }
        catch (Exception e) {
            e.printStackTrace(realErr);
        }
        message = urgencyString + message + '\n';
        if (urgency == 1 && debug) {
            realOut.print(message);
        } else if (urgency >= level) {
            if (urgency == 9) {
                realErr.print(message);
            } else {
                realOut.print(message);
            }
        }
    }

    private static String urgencyToString(int urgency) {
        switch (urgency) {
            case 1: {
                return "debug";
            }
            case 3: {
                return "message";
            }
            case 5: {
                return "notice";
            }
            case 7: {
                return "warning";
            }
            case 9: {
                return "error";
            }
        }
        throw new IllegalArgumentException("Invalid urgency: " + urgency);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        level = 7;
        debug = true;
        level = 7;
        realOut = System.out;
        realErr = System.err;
        logDocument = new PlainDocument();
        lineSep = System.getProperty("line.separator");
    }
}

