/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Component;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.gui.Messages;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import treeview.EditTagDialog;

public class DefaultViewTableModel
implements TableModel {
    private Component m_view;
    private boolean m_addingAttribute = false;
    private AdapterNode m_currentNode;
    private ArrayList m_tableListenerList = new ArrayList();
    private ArrayList[] m_data = new ArrayList[]{new ArrayList(), new ArrayList()};

    protected DefaultViewTableModel(Component parent, AdapterNode adapterNode) {
        this.m_currentNode = adapterNode;
        this.m_view = parent;
        this.updateTable(this.m_currentNode);
    }

    public void addTableModelListener(TableModelListener l) {
        if (l != null && !this.m_tableListenerList.contains(l)) {
            this.m_tableListenerList.add(l);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return new String().getClass();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return Messages.getMessage((String)"xml.attribute");
        }
        return Messages.getMessage((String)"xml.attribute.value.short");
    }

    public int getRowCount() {
        return this.m_data[0].size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            ElementDecl.AttributeDecl attrDecl;
            String name = this.m_data[0].get(rowIndex).toString();
            ElementDecl eleDecl = this.m_currentNode.getElementDecl();
            ElementDecl.AttributeDecl attributeDecl = attrDecl = eleDecl != null ? eleDecl.getAttribute(name) : null;
            if (attrDecl != null && attrDecl.values != null) {
                return new EditTagDialog.Attribute.Value(this.m_data[columnIndex].get(rowIndex).toString(), attrDecl.values);
            }
        }
        return this.m_data[columnIndex].get(rowIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1 && ((String)this.getValueAt(rowIndex, 0)).equals("")) {
            return this.m_addingAttribute;
        }
        return true;
    }

    public void removeTableModelListener(TableModelListener listener) {
        if (listener != null) {
            this.m_tableListenerList.remove(listener);
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        while (rowIndex + 1 > this.getRowCount()) {
            this.m_data[columnIndex].add("");
        }
        try {
            if (rowIndex + 1 == this.getRowCount()) {
                if (columnIndex == 0 && !aValue.equals("")) {
                    this.m_addingAttribute = true;
                    this.m_data[0].set(rowIndex, aValue.toString());
                } else if (this.m_addingAttribute) {
                    this.m_addingAttribute = false;
                    this.m_currentNode.setAttribute(this.m_data[0].get(rowIndex).toString(), aValue.toString());
                    this.updateTable(this.m_currentNode);
                    this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
                }
            } else if (!(columnIndex != 1 && aValue.equals("") || aValue.equals(this.getValueAt(rowIndex, columnIndex)))) {
                if (columnIndex == 0) {
                    String oldAttribute = (String)this.getValueAt(rowIndex, 0);
                    Object rawOldValue = this.getValueAt(rowIndex, 1);
                    String oldValue = rawOldValue instanceof EditTagDialog.Attribute.Value ? ((EditTagDialog.Attribute.Value)rawOldValue).value : rawOldValue.toString();
                    this.m_currentNode.removeAttribute(oldAttribute);
                    try {
                        this.m_currentNode.setAttribute(aValue.toString(), oldValue);
                    }
                    catch (DOMException e) {
                        this.m_currentNode.setAttribute(oldAttribute, oldValue);
                        throw e;
                    }
                } else {
                    this.m_currentNode.setAttribute((String)this.getValueAt(rowIndex, 0), aValue.toString());
                }
                this.updateTable(this.m_currentNode);
                this.fireTableChanged(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
            }
        }
        catch (DOMException dome) {
            this.updateTable(this.m_currentNode);
            JOptionPane.showMessageDialog(this.m_view, dome, "XML Error", 2);
        }
    }

    public void removeRow(int row) {
        try {
            this.m_currentNode.removeAttributeAt(row);
            this.updateTable(this.m_currentNode);
            this.fireTableChanged(new TableModelEvent(this, row));
        }
        catch (DOMException e) {
            JOptionPane.showMessageDialog(this.m_view, e, "XML Error", 2);
        }
    }

    public void setAdapterNode(AdapterNode adapterNode) {
        this.m_currentNode = adapterNode;
        this.updateTable(this.m_currentNode);
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void updateTable() {
        this.updateTable(this.m_currentNode);
    }

    private void fireTableChanged(TableModelEvent e) {
        ListIterator listeners = this.m_tableListenerList.listIterator();
        while (listeners.hasNext()) {
            TableModelListener listener = (TableModelListener)listeners.next();
            listener.tableChanged(e);
        }
    }

    private void updateTable(AdapterNode selectedNode) {
        this.m_currentNode = selectedNode;
        this.m_data[0].removeAll(this.m_data[0]);
        this.m_data[1].removeAll(this.m_data[1]);
        if (selectedNode != null) {
            NamedNodeMap attrs = selectedNode.getAttributes();
            if (selectedNode.getNodeType() == 1 && attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this.m_data[0].add(attrs.item(i).getNodeName());
                    this.m_data[1].add(attrs.item(i).getNodeValue());
                }
                this.m_data[0].add("");
                this.m_data[1].add("");
            }
        }
    }
}

