/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import net.sourceforge.jsxe.dom.AdapterNode;
import org.w3c.dom.DOMException;
import treeview.TransferableNode;
import treeview.TreeViewTree;

public class NodeTransferHandler
extends TransferHandler {
    DataFlavor m_nodeFlavor = TransferableNode.nodeFlavor;
    DataFlavor m_stringFlavor = TransferableNode.stringFlavor;

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (int i = 0; i < transferFlavors.length; ++i) {
            if (!transferFlavors[i].equals(this.m_nodeFlavor) && !transferFlavors[i].equals(this.m_stringFlavor)) continue;
            return true;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent c) {
        TransferableNode result = null;
        TreeViewTree dvt = (TreeViewTree)c;
        TreePath path = dvt.getSelectionPath();
        if (path != null) {
            AdapterNode node = (AdapterNode)path.getLastPathComponent();
            result = new TransferableNode(node);
        }
        return result;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        TreeViewTree dvt = (TreeViewTree)source;
        if (action == 2) {
            // empty if block
        }
    }

    public boolean importData(JComponent comp, Transferable t) {
        if (!this.canImport(comp, t.getTransferDataFlavors())) {
            return false;
        }
        Object data = null;
        try {
            data = t.getTransferData(this.m_nodeFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        TreeViewTree dvt = (TreeViewTree)comp;
        TreePath path = dvt.getSelectionPath();
        if (path == null) {
            return false;
        }
        AdapterNode anode = (AdapterNode)data;
        AdapterNode selected = (AdapterNode)path.getLastPathComponent();
        try {
            if (selected == null) {
                throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
            }
            AdapterNode parent = selected.getParentNode();
            if (parent == null) {
                throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
            }
            parent.addAdapterNodeAt(anode, parent.index(selected));
            dvt.makeVisible(path);
            TreePath droppedPath = path.getParentPath();
            dvt.addSelectionPath(droppedPath.pathByAddingChild(selected));
        }
        catch (DOMException dome) {
            JOptionPane.showMessageDialog(dvt, dome, "XML Error", 2);
            return false;
        }
        return true;
    }
}

