/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.jsxe.ActionManager;
import net.sourceforge.jsxe.LocalizedAction;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.XMLDocument;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.dom.completion.EntityDecl;
import net.sourceforge.jsxe.gui.Messages;
import net.sourceforge.jsxe.gui.menu.WrappingMenu;
import net.sourceforge.jsxe.jsXe;
import net.sourceforge.jsxe.util.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import treeview.TransferableNode;
import treeview.action.AddNodeAction;

public class TreeViewTree
extends JTree
implements Autoscroll,
ClipboardOwner {
    private final String NODE_EXPANDED = "tree.expandedstate";
    private static final ImageIcon m_elementIcon = new ImageIcon((class$treeview$DefaultView == null ? (class$treeview$DefaultView = TreeViewTree.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResource("/net/sourceforge/jsxe/icons/Element.png"), "Element");
    private static final ImageIcon m_textIcon = new ImageIcon((class$treeview$DefaultView == null ? (class$treeview$DefaultView = TreeViewTree.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResource("/net/sourceforge/jsxe/icons/Text.png"), "Text");
    private static final ImageIcon m_CDATAIcon = new ImageIcon((class$treeview$DefaultView == null ? (class$treeview$DefaultView = TreeViewTree.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResource("/net/sourceforge/jsxe/icons/CDATA.png"), "CDATA");
    private static final ImageIcon m_commentIcon = new ImageIcon((class$treeview$DefaultView == null ? (class$treeview$DefaultView = TreeViewTree.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResource("/net/sourceforge/jsxe/icons/Comment.png"), "Comment");
    private static final ImageIcon m_internalEntityIcon = new ImageIcon((class$treeview$DefaultView == null ? (class$treeview$DefaultView = TreeViewTree.class$("treeview.DefaultView")) : class$treeview$DefaultView).getResource("/net/sourceforge/jsxe/icons/InternalEntity.png"), "Internal Entity");
    private static final int m_AUTOSCROLL_MARGIN = 12;
    private DragSource m_dragSource = DragSource.getDefaultDragSource();
    private DragGestureListener m_treeDGListener = new TreeDragGestureListener();
    private DragSourceListener m_treeDSListener = new DefaultViewDragSourceListener();
    private DropTarget m_dropTarget;
    private DropTargetListener m_treeDTListener = new DefaultViewDropTargetListener();
    private int m_acceptableActions = 2;
    private Rectangle m_cueLine = new Rectangle();
    private Object m_dragOverTarget = null;
    private Color m_dragSelectionColor = Color.lightGray;
    static /* synthetic */ Class class$treeview$DefaultView;

    public TreeViewTree() {
        this.m_dragSource.createDefaultDragGestureRecognizer(this, 2, this.m_treeDGListener);
        this.m_dropTarget = new DropTarget(this, this.m_acceptableActions, this.m_treeDTListener, true);
        this.addMouseListener(new TreePopupListener());
        this.setEditable(false);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                try {
                    AdapterNode node = (AdapterNode)event.getPath().getLastPathComponent();
                    node.setProperty("tree.expandedstate", "true");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                try {
                    AdapterNode node = (AdapterNode)event.getPath().getLastPathComponent();
                    node.setProperty("tree.expandedstate", "false");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
        this.getSelectionModel().setSelectionMode(1);
        DefaultViewTreeCellRenderer renderer = new DefaultViewTreeCellRenderer();
        this.setCellRenderer(renderer);
        renderer = new DefaultViewTreeCellRenderer();
        this.setCellEditor(new DefaultTreeCellEditor(this, renderer, new ElementCellEditor(this, renderer)));
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public boolean isEditable(AdapterNode node) {
        if (node != null) {
            short nodeType = node.getNodeType();
            return nodeType == 1 || nodeType == 7;
        }
        return false;
    }

    public boolean isExpanded(AdapterNode node) {
        return Boolean.valueOf(node.getProperty("tree.expandedstate"));
    }

    public void startEditingAtPath(TreePath path) {
        if (path != null && this.isEditable((AdapterNode)path.getLastPathComponent())) {
            this.getCellEditor().addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent e) {
                    TreeViewTree.this.setEditable(false);
                    TreeViewTree.this.getCellEditor().removeCellEditorListener(this);
                }

                public void editingStopped(ChangeEvent e) {
                    TreeViewTree.this.setEditable(false);
                    TreeViewTree.this.getCellEditor().removeCellEditorListener(this);
                }
            });
            this.setEditable(true);
            super.startEditingAtPath(path);
        }
    }

    public AdapterNode getSelectedNode() {
        TreePath selPath = this.getLeadSelectionPath();
        AdapterNode selectedNode = null;
        if (selPath != null) {
            selectedNode = (AdapterNode)selPath.getLastPathComponent();
        }
        return selectedNode;
    }

    public boolean cut() throws DOMException {
        AdapterNode selectedNode = this.getSelectedNode();
        Clipboard clipBoard = this.getToolkit().getSystemClipboard();
        if (selectedNode != null) {
            try {
                clipBoard.setContents(new TransferableNode(selectedNode), this);
                selectedNode.getParentNode().remove(selectedNode);
                this.updateUI();
                return true;
            }
            catch (IllegalStateException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (HeadlessException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (DOMException e) {
                clipBoard.setContents(null, this);
                throw e;
            }
        }
        return false;
    }

    public boolean copy() {
        AdapterNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            try {
                Clipboard clipBoard = this.getToolkit().getSystemClipboard();
                AdapterNode newNode = selectedNode.copy(true);
                clipBoard.setContents(new TransferableNode(newNode), this);
                return true;
            }
            catch (IllegalStateException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (HeadlessException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
        }
        return false;
    }

    public boolean paste() throws DOMException {
        AdapterNode selectedNode = this.getSelectedNode();
        if (selectedNode != null) {
            try {
                Clipboard clipBoard = this.getToolkit().getSystemClipboard();
                Transferable contents = clipBoard.getContents(this);
                if (contents != null && contents.isDataFlavorSupported(TransferableNode.nodeFlavor)) {
                    AdapterNode node = (AdapterNode)contents.getTransferData(TransferableNode.nodeFlavor);
                    TreePath pastePath = this.getLeadSelectionPath();
                    selectedNode.addAdapterNode(node);
                    StringSelection sel = new StringSelection("");
                    clipBoard.setContents(sel, sel);
                    this.refreshExpandedStates(pastePath);
                    this.addSelectionPath(pastePath.pathByAddingChild(node));
                    this.updateUI();
                    return true;
                }
            }
            catch (IllegalStateException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (HeadlessException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (UnsupportedFlavorException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
            catch (IOException e) {
                Log.log((int)9, (Object)this, (Object)e);
            }
        }
        return false;
    }

    public void autoscroll(Point cursorLocn) {
        int row = this.getClosestRowForLocation(cursorLocn.x, cursorLocn.y);
        if (row < 0) {
            return;
        }
        Rectangle bounds = this.getBounds();
        if (cursorLocn.y + bounds.y <= 12) {
            row = row <= 0 ? 0 : --row;
        } else if (row < this.getRowCount() - 1) {
            ++row;
        }
        this.scrollRowToVisible(row);
    }

    public Insets getAutoscrollInsets() {
        Rectangle outerBounds = this.getBounds();
        Rectangle innerBounds = this.getParent().getBounds();
        int top = innerBounds.y - outerBounds.y + 12;
        int left = innerBounds.x - outerBounds.x + 12;
        int bottom = outerBounds.height - innerBounds.height - innerBounds.y + outerBounds.y + 12;
        int right = outerBounds.width - innerBounds.width - innerBounds.x + outerBounds.y + 12;
        return new Insets(top, left, bottom, right);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void refreshExpandedStates(TreePath path) {
        AdapterNode node = (AdapterNode)path.getLastPathComponent();
        boolean expandedState = this.isExpanded(node);
        if (node.childCount() > 0) {
            this.expandPath(path);
            int children = node.childCount();
            for (int i = 0; i < children; ++i) {
                TreePath newPath = path.pathByAddingChild(node.child(i));
                this.refreshExpandedStates(newPath);
            }
            if (expandedState) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
    }

    private static String toString(AdapterNode node) {
        StringBuffer s = new StringBuffer();
        if (node.getNodeType() == 9) {
            return "Document Root";
        }
        String nodeName = node.getNodeName();
        if (!nodeName.startsWith("#")) {
            s.append(nodeName);
            if (node.getNodeType() == 1) {
                NamedNodeMap attributes = node.getAttributes();
                ElementDecl decl = node.getElementDecl();
                XMLDocument document = node.getOwnerDocument();
                int showAttrs = jsXe.getIntegerProperty((String)"treeview.show.attributes", (int)0);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    ElementDecl.AttributeDecl attrDecl;
                    Node attr = attributes.item(i);
                    ElementDecl.AttributeDecl attributeDecl = attrDecl = decl != null ? decl.getAttribute(attr.getNodeName()) : null;
                    if (showAttrs != 2 && (showAttrs != 1 || !attr.getNodeName().equalsIgnoreCase("id") && (attrDecl == null || !attrDecl.type.equals("ID")))) continue;
                    s.append(' ' + attr.getNodeName() + "=\"" + attr.getNodeValue() + '\"');
                }
            }
        }
        if (s.length() == 0 && node.getNodeValue() != null) {
            String t = node.getNodeValue().trim();
            int x = t.indexOf("\n");
            if (x >= 0) {
                t = t.substring(0, x);
            }
            if (t.length() > 50) {
                t = t.substring(0, 50) + "...";
            }
            s.append(t);
        }
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DefaultViewDropTargetListener
    implements DropTargetListener {
        private static final int m_HOVER_TIME_BEFORE_EXPAND = 1500;
        private Timer m_m_timerHover = new Timer(1500, new ActionListener(this){
            private final /* synthetic */ DefaultViewDropTargetListener this$1;
            {
                this.this$1 = this$1;
            }

            public void actionPerformed(ActionEvent e) {
                if (DefaultViewDropTargetListener.access$1200(this.this$1).isRootVisible() && DefaultViewDropTargetListener.access$1200(this.this$1).getRowForPath(DefaultViewDropTargetListener.access$1300(this.this$1)) == 0) {
                    return;
                }
                if (DefaultViewDropTargetListener.access$1200(this.this$1).isExpanded(DefaultViewDropTargetListener.access$1300(this.this$1))) {
                    DefaultViewDropTargetListener.access$1200(this.this$1).collapsePath(DefaultViewDropTargetListener.access$1300(this.this$1));
                } else {
                    DefaultViewDropTargetListener.access$1200(this.this$1).expandPath(DefaultViewDropTargetListener.access$1300(this.this$1));
                }
            }
        });
        private TreePath m_m_lastPath;

        public DefaultViewDropTargetListener() {
            this.m_m_timerHover.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (!this.isDragOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void drop(DropTargetDropEvent dtde) {
            this.m_m_timerHover.stop();
            if (!dtde.isDataFlavorSupported(TransferableNode.nodeFlavor)) {
                dtde.rejectDrop();
                return;
            }
            if ((dtde.getSourceActions() & TreeViewTree.this.m_acceptableActions) == 0) {
                dtde.rejectDrop();
                return;
            }
            DataFlavor chosen = TransferableNode.nodeFlavor;
            Object data = null;
            try {
                data = dtde.getTransferable().getTransferData(chosen);
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (data == null) {
                throw new NullPointerException();
            }
            AdapterNode node = (AdapterNode)data;
            Point loc = dtde.getLocation();
            TreePath path = TreeViewTree.this.getClosestPathForLocation(loc.x, loc.y);
            if (path == null) {
                dtde.rejectDrop();
                return;
            }
            AdapterNode parentNode = (AdapterNode)path.getLastPathComponent();
            try {
                void var8_14;
                TreePath droppedPath;
                Rectangle bounds = TreeViewTree.this.getPathBounds(path);
                if (loc.y < bounds.y + (int)((double)bounds.height * 0.25)) {
                    if (parentNode == null) throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
                    AdapterNode trueParent = parentNode.getParentNode();
                    if (trueParent == null) throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
                    trueParent.addAdapterNodeAt(node, trueParent.index(parentNode));
                    TreeViewTree.this.makeVisible(path);
                    droppedPath = path.getParentPath();
                } else if (loc.y < bounds.y + (int)((double)bounds.height * 0.75)) {
                    parentNode.addAdapterNode(node);
                    droppedPath = path;
                    if (TreeViewTree.this.isCollapsed(path)) {
                        TreeViewTree.this.expandPath(path);
                    }
                } else {
                    if (parentNode == null) throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
                    AdapterNode trueParent = parentNode.getParentNode();
                    if (trueParent == null) throw new DOMException(3, "HIERARCHY_REQUEST_ERR: An attempt was made to insert a node where it is not permitted");
                    trueParent.addAdapterNodeAt(node, trueParent.index(parentNode) + 1);
                    droppedPath = path.getParentPath();
                    TreeViewTree.this.makeVisible(path);
                }
                TreeViewTree.this.refreshExpandedStates((TreePath)var8_14);
                TreeViewTree.this.addSelectionPath(var8_14.pathByAddingChild(node));
                dtde.acceptDrop(TreeViewTree.this.m_acceptableActions);
            }
            catch (DOMException dome) {
                dtde.rejectDrop();
                JOptionPane.showMessageDialog(TreeViewTree.this, dome, "XML Error", 2);
            }
            TreeViewTree.this.m_dragOverTarget = null;
            TreeViewTree.this.paintImmediately(TreeViewTree.this.m_cueLine);
            dtde.dropComplete(true);
            TreeViewTree.this.updateUI();
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (!this.isDragOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
            Point loc = dtde.getLocation();
            TreePath path = TreeViewTree.this.getClosestPathForLocation(loc.x, loc.y);
            if (path != this.m_m_lastPath) {
                this.m_m_lastPath = path;
                this.m_m_timerHover.restart();
            }
            TreeViewTree.this.m_dragOverTarget = null;
            TreeViewTree.this.paintImmediately(TreeViewTree.this.m_cueLine);
            if (path != null) {
                Rectangle bounds = TreeViewTree.this.getPathBounds(path);
                Graphics g = TreeViewTree.this.getGraphics();
                int x = bounds.x;
                int y = bounds.y;
                int width = bounds.width;
                int height = 2;
                g.setColor(TreeViewTree.this.m_dragSelectionColor);
                if (loc.y < bounds.y + (int)((double)bounds.height * 0.25)) {
                    g.fillRect(x, y, width, height);
                } else if (loc.y < bounds.y + (int)((double)bounds.height * 0.75)) {
                    height = bounds.height;
                    TreeViewTree.this.m_dragOverTarget = path.getLastPathComponent();
                    TreeViewTree.this.paintImmediately(x, y, width, height);
                } else {
                    g.fillRect(x, y += bounds.height, width, height);
                }
                TreeViewTree.this.m_cueLine.setRect(x, y, width, height);
            }
            dtde.acceptDrag(2);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            if (!this.isDragOk(dtde)) {
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        public void dragExit(DropTargetEvent dte) {
            TreeViewTree.this.m_dragOverTarget = null;
        }

        private boolean isDragOk(DropTargetDragEvent dtde) {
            if (!dtde.isDataFlavorSupported(TransferableNode.nodeFlavor)) {
                return false;
            }
            return (dtde.getDropAction() & TreeViewTree.this.m_acceptableActions) != 0;
        }

        static /* synthetic */ TreeViewTree access$1200(DefaultViewDropTargetListener x0) {
            return x0.TreeViewTree.this;
        }

        static /* synthetic */ TreePath access$1300(DefaultViewDropTargetListener x0) {
            return x0.m_m_lastPath;
        }
    }

    private class DefaultViewDragSourceListener
    implements DragSourceListener {
        private DefaultViewDragSourceListener() {
        }

        public void dragEnter(DragSourceDragEvent dsde) {
            DragSourceContext context = dsde.getDragSourceContext();
            int myaction = dsde.getDropAction();
            if ((myaction & 2) != 0) {
                context.setCursor(DragSource.DefaultMoveDrop);
            } else {
                context.setCursor(DragSource.DefaultMoveNoDrop);
            }
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            TreeViewTree.this.paintImmediately(TreeViewTree.this.m_cueLine);
            TreeViewTree.this.m_dragOverTarget = null;
            if (!dsde.getDropSuccess()) {
                return;
            }
            int dropAction = dsde.getDropAction();
            if (dropAction == 2) {
                // empty if block
            }
        }

        public void dragExit(DragSourceEvent dse) {
            TreeViewTree.this.paintImmediately(TreeViewTree.this.m_cueLine);
            DragSourceContext context = dse.getDragSourceContext();
            context.setCursor(DragSource.DefaultMoveNoDrop);
            TreeViewTree.this.m_dragOverTarget = null;
        }

        public void dragOver(DragSourceDragEvent dsde) {
        }

        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private class TreeDragGestureListener
    implements DragGestureListener {
        private TreeDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            try {
                Point origin = dge.getDragOrigin();
                TreePath path = TreeViewTree.this.getPathForLocation(origin.x, origin.y);
                if (!(path == null || TreeViewTree.this.isRootVisible() && TreeViewTree.this.getRowForPath(path) == 0)) {
                    AdapterNode node = (AdapterNode)path.getLastPathComponent();
                    TransferableNode transferable = new TransferableNode(node);
                    TreeViewTree.this.m_dragSource.startDrag(dge, DragSource.DefaultCopyNoDrop, transferable, TreeViewTree.this.m_treeDSListener);
                }
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                // empty catch block
            }
        }
    }

    public class ElementCellEditor
    extends DefaultTreeCellEditor {
        public ElementCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
            super(tree, renderer);
        }

        protected void prepareForEditing() {
            TreePath path = TreeViewTree.this.getLeadSelectionPath();
            TreeViewTree tree = TreeViewTree.this;
            Object value = TreeViewTree.this.getLastSelectedPathComponent();
            boolean isSelected = TreeViewTree.this.isPathSelected(path);
            boolean expanded = TreeViewTree.this.isExpanded(path);
            boolean leaf = TreeViewTree.this.getModel().isLeaf(value);
            int row = TreeViewTree.this.getLeadSelectionRow();
            this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            super.prepareForEditing();
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Container container = (Container)super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            JTextField field = (JTextField)container.getComponent(0);
            field.setText(((AdapterNode)value).getNodeName());
            return field;
        }
    }

    private class ElementTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon m_defaultLeafIcon = this.getLeafIcon();

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            AdapterNode node = (AdapterNode)value;
            if (node.getNodeType() == 7) {
                this.setIcon(this.m_defaultLeafIcon);
                this.setLeafIcon(this.m_defaultLeafIcon);
                this.setOpenIcon(this.m_defaultLeafIcon);
                this.setClosedIcon(this.m_defaultLeafIcon);
                this.setToolTipText(Messages.getMessage((String)"xml.processing.instruction"));
            } else {
                this.setIcon(m_elementIcon);
                this.setLeafIcon(m_elementIcon);
                this.setOpenIcon(m_elementIcon);
                this.setClosedIcon(m_elementIcon);
                this.setToolTipText(Messages.getMessage((String)"xml.element"));
            }
            this.setText(((AdapterNode)value).getNodeName());
            return this;
        }
    }

    private class DefaultViewTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon m_defaultLeafIcon = this.getLeafIcon();
        private Icon m_defaultOpenIcon = this.getOpenIcon();
        private Icon m_defaultClosedIcon = this.getClosedIcon();
        private Color m_defaultBackgroundSelectionColor = this.backgroundSelectionColor;

        DefaultViewTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            int type = -1;
            try {
                AdapterNode node = (AdapterNode)value;
                type = node.getNodeType();
                this.setText(TreeViewTree.toString(node));
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            this.selected = selected;
            if (value != null && TreeViewTree.this.m_dragOverTarget == value) {
                this.selected = true;
                this.backgroundSelectionColor = TreeViewTree.this.m_dragSelectionColor;
            } else {
                this.backgroundSelectionColor = this.m_defaultBackgroundSelectionColor;
            }
            switch (type) {
                case 1: {
                    this.setIcon(m_elementIcon);
                    this.setLeafIcon(m_elementIcon);
                    this.setOpenIcon(m_elementIcon);
                    this.setClosedIcon(m_elementIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.element"));
                    break;
                }
                case 3: {
                    this.setIcon(m_textIcon);
                    this.setLeafIcon(m_textIcon);
                    this.setOpenIcon(m_textIcon);
                    this.setClosedIcon(m_textIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.text"));
                    break;
                }
                case 4: {
                    this.setIcon(m_CDATAIcon);
                    this.setLeafIcon(m_CDATAIcon);
                    this.setOpenIcon(m_CDATAIcon);
                    this.setClosedIcon(m_CDATAIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.cdata"));
                    break;
                }
                case 8: {
                    this.setIcon(m_commentIcon);
                    this.setLeafIcon(m_commentIcon);
                    this.setOpenIcon(m_commentIcon);
                    this.setClosedIcon(m_commentIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.comment"));
                    break;
                }
                case 5: {
                    this.setIcon(m_internalEntityIcon);
                    this.setLeafIcon(m_internalEntityIcon);
                    this.setOpenIcon(m_internalEntityIcon);
                    this.setClosedIcon(m_internalEntityIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.entity.reference"));
                    break;
                }
                case 9: {
                    this.setIcon(this.m_defaultClosedIcon);
                    this.setLeafIcon(this.m_defaultLeafIcon);
                    this.setOpenIcon(this.m_defaultOpenIcon);
                    this.setClosedIcon(this.m_defaultClosedIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.document"));
                    break;
                }
                case 7: {
                    this.setIcon(this.m_defaultLeafIcon);
                    this.setLeafIcon(this.m_defaultLeafIcon);
                    this.setOpenIcon(this.m_defaultLeafIcon);
                    this.setClosedIcon(this.m_defaultLeafIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.processing.instruction"));
                    break;
                }
                case 10: {
                    this.setIcon(this.m_defaultLeafIcon);
                    this.setLeafIcon(this.m_defaultLeafIcon);
                    this.setOpenIcon(this.m_defaultLeafIcon);
                    this.setClosedIcon(this.m_defaultLeafIcon);
                    this.setToolTipText(Messages.getMessage((String)"xml.doctypedef"));
                    break;
                }
                default: {
                    if (leaf) {
                        this.setIcon(this.m_defaultLeafIcon);
                    } else if (expanded) {
                        this.setIcon(this.m_defaultOpenIcon);
                    } else {
                        this.setIcon(this.m_defaultClosedIcon);
                    }
                    this.setLeafIcon(this.m_defaultLeafIcon);
                    this.setOpenIcon(this.m_defaultOpenIcon);
                    this.setClosedIcon(this.m_defaultClosedIcon);
                    this.setToolTipText("Unknown node");
                }
            }
            return this;
        }
    }

    private class TreePopupListener
    extends MouseAdapter {
        private TreePopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            TreePath selPath = TreeViewTree.this.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger() && selPath != null) {
                JMenuItem popupMenuItem;
                TreeViewTree.this.setSelectionPath(selPath);
                AdapterNode selectedNode = (AdapterNode)selPath.getLastPathComponent();
                XMLDocument ownerDocument = selectedNode.getOwnerDocument();
                JMenu addNodeItem = new JMenu(Messages.getMessage((String)"common.add"));
                JPopupMenu popup = new JPopupMenu();
                boolean showpopup = false;
                boolean addNodeShown = false;
                if (selectedNode.getNodeType() == 1) {
                    WrappingMenu addElement = new WrappingMenu(Messages.getMessage((String)"xml.element"), 20);
                    addNodeItem.add((JMenuItem)addElement);
                    addElement.add(ActionManager.getAction((String)"treeview.add.element.node"));
                    Iterator allowedElements = selectedNode.getAllowedElements().iterator();
                    while (allowedElements.hasNext()) {
                        ElementDecl decl = (ElementDecl)allowedElements.next();
                        addElement.add((Action)new ActionManager.Wrapper((LocalizedAction)new AddNodeAction(decl)));
                    }
                    WrappingMenu addEntity = new WrappingMenu(Messages.getMessage((String)"xml.entity.reference"), 20);
                    addNodeItem.add((JMenuItem)addEntity);
                    Iterator allowedEntities = ownerDocument.getAllowedEntities().iterator();
                    while (allowedEntities.hasNext()) {
                        EntityDecl decl = (EntityDecl)allowedEntities.next();
                        popupMenuItem = new JMenuItem((Action)new ActionManager.Wrapper((LocalizedAction)new AddNodeAction(decl)));
                        addEntity.add(popupMenuItem);
                    }
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.add.text.node"));
                    popupMenuItem.setText(Messages.getMessage((String)"xml.text"));
                    addNodeItem.add(popupMenuItem);
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.add.cdata.node"));
                    popupMenuItem.setText(Messages.getMessage((String)"xml.cdata"));
                    addNodeItem.add(popupMenuItem);
                    addNodeShown = true;
                    showpopup = true;
                }
                if (selectedNode.getNodeType() == 9 && ownerDocument.getDocType() == null) {
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.add.doctype.node"));
                    popupMenuItem.setText(Messages.getMessage((String)"xml.doctypedef"));
                    addNodeItem.add(popupMenuItem);
                    showpopup = true;
                }
                if (selectedNode.getNodeType() == 9 || selectedNode.getNodeType() == 1) {
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.add.pi.node"));
                    popupMenuItem.setText(Messages.getMessage((String)"xml.processing.instruction"));
                    addNodeItem.add(popupMenuItem);
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.add.comment.node"));
                    popupMenuItem.setText(Messages.getMessage((String)"xml.comment"));
                    addNodeItem.add(popupMenuItem);
                    addNodeShown = true;
                    showpopup = true;
                }
                if (addNodeShown) {
                    popup.add(addNodeItem);
                }
                if (selectedNode.getNodeType() == 1 && ownerDocument.getElementDecl(selectedNode.getNodeName()) != null) {
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.edit.node"));
                    popup.add(popupMenuItem);
                    showpopup = true;
                }
                if (selectedNode.getNodeType() == 1 || selectedNode.getNodeType() == 7) {
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.rename.node"));
                    popup.add(popupMenuItem);
                    showpopup = true;
                }
                if (selectedNode.getNodeType() != 9 && selectedNode.getNodeType() != 10 && (selectedNode.getNodeType() != 1 || selectedNode.getParentNode().getNodeType() != 9)) {
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"treeview.remove.node"));
                    popup.add(popupMenuItem);
                    showpopup = true;
                }
                if (selectedNode.getNodeType() != 9 && selectedNode.getNodeType() != 10) {
                    popup.addSeparator();
                    if (selectedNode.getNodeType() != 1 || selectedNode.getParentNode().getNodeType() != 9) {
                        popupMenuItem = new JMenuItem(ActionManager.getAction((String)"cut"));
                        popup.add(popupMenuItem);
                    }
                    popupMenuItem = new JMenuItem(ActionManager.getAction((String)"copy"));
                    popup.add(popupMenuItem);
                    if (selectedNode.getNodeType() == 1) {
                        popupMenuItem = new JMenuItem(ActionManager.getAction((String)"paste"));
                        popup.add(popupMenuItem);
                    }
                    showpopup = true;
                }
                if (showpopup) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }
}

