/*
 * Decompiled with CFR 0.152.
 */
package treeview.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import net.sourceforge.jsxe.LocalizedAction;
import net.sourceforge.jsxe.dom.AdapterNode;
import net.sourceforge.jsxe.dom.completion.ElementDecl;
import net.sourceforge.jsxe.dom.completion.EntityDecl;
import net.sourceforge.jsxe.gui.DocumentView;
import net.sourceforge.jsxe.gui.TabbedView;
import net.sourceforge.jsxe.jsXe;
import org.w3c.dom.DOMException;
import treeview.DefaultView;
import treeview.EditTagDialog;
import treeview.TreeViewTree;

public class AddNodeAction
extends LocalizedAction {
    private short m_nodeType;
    private String m_name;
    private String m_value;
    private ElementDecl m_element;
    private EntityDecl m_entity;

    public AddNodeAction(ElementDecl element) {
        super(element.name);
        this.init(element.name, null, (short)1);
        this.m_element = element;
    }

    public AddNodeAction(EntityDecl entity) {
        super(entity.name);
        this.init(entity.name, entity.value, (short)5);
        this.m_entity = entity;
    }

    public AddNodeAction(String name, String nodeName, String nodeValue, short nodeType) {
        super(name);
        this.init(nodeName, nodeValue, nodeType);
    }

    public void invoke(TabbedView view, ActionEvent evt) {
        DocumentView docView = view.getDocumentView();
        if (docView instanceof DefaultView) {
            DefaultView defView = (DefaultView)docView;
            TreeViewTree tree = defView.getTree();
            AdapterNode selectedNode = tree.getSelectedNode();
            AdapterNode addedNode = null;
            if (selectedNode != null) {
                try {
                    if (this.m_element != null) {
                        if (this.m_element.getAttributes().size() > 0) {
                            EditTagDialog dialog = new EditTagDialog((Frame)jsXe.getActiveView(), this.m_element, new HashMap(), this.m_element.empty, this.m_element.completionInfo.getEntityHash(), new ArrayList(), selectedNode.getOwnerDocument());
                            dialog.show();
                            addedNode = selectedNode.addAdapterNode(dialog.getNewNode());
                        } else {
                            addedNode = selectedNode.addAdapterNode(this.m_element.name, null, (short)1, selectedNode.childCount());
                        }
                    } else {
                        addedNode = selectedNode.addAdapterNode(this.m_name, this.m_value, this.m_nodeType, selectedNode.childCount());
                    }
                    tree.expandPath(tree.getLeadSelectionPath());
                    tree.updateUI();
                }
                catch (DOMException dome) {
                    JOptionPane.showMessageDialog(tree, dome, "XML Error", 2);
                }
            }
        }
    }

    public String getLabel() {
        if (this.m_element != null) {
            return this.m_element.name;
        }
        if (this.m_entity != null) {
            return this.m_entity.name;
        }
        return super.getLabel();
    }

    public void init(String name, String value, short type) {
        this.m_name = name;
        this.m_value = value;
        this.m_nodeType = type;
    }
}

