/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* m_bootup.c --- initialize system (called first) */

/* $Id: m_bootup.c,v 1.7 2004/03/22 04:14:31 ri Exp $ */

#include <julius.h>

/* special error / normal handling function for julius/julian */
/* should be registered with j_{error,exit}_register_exitfunc(), and */
/* called via j_error() and j_exit() */
static void
m_errexit()			/* for fatal error */
{
  if (module_mode) {
    /* disconnect control module */
    if (module_is_connected()) {
      module_send("<SYSINFO PROCESS=\"ERREXIT\"/>\n.\n");
      module_disconnect();
    }
  } else {
    j_printerr("Terminated\n");
  }
  exit(1);			/* program exit with status 1 */
}
static void
m_exit()			/* for normal program end */
{
  if (module_mode) {
    /* disconnect control module */
    if (module_is_connected()) {
      module_send("<SYSINFO PROCESS=\"EXIT\"/>\n.\n");
      module_disconnect();
    }
  }
  exit(0);			/* program exit with status 0 */
}

/* system bootup */
void
system_bootup()
{
  /* set mybmalloc (block memory allocation) parameters first (optional) */
  mybmalloc_set_param();

  /* set error exit function */
  j_error_register_exitfunc(m_errexit);
  j_exit_register_exitfunc(m_exit);

  /* set default param according to the compile flag */
  if (strmatch(SETUP, "fast")) {
    nbest = 1;
    enveloped_bestfirst_width = 30;
  } else {
    nbest = 10;
    enveloped_bestfirst_width = 100;
  }
}
