/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* htk_param.h --- defs for reading in HTK format parameter file */

/* $Id: htk_param.h,v 1.4 2004/03/22 04:14:31 ri Exp $ */

#ifndef __SENT_HTK_PARAM_H__
#define __SENT_HTK_PARAM_H__

#include <sent/stddefs.h>
#include <sent/htk_defs.h>

/* header */
typedef struct {
  unsigned int samplenum;	/* num of samples */
  unsigned int wshift;		/* window shift (unit=100ns) */
  unsigned short sampsize;	/* bytes per sample */
  short samptype;		/* sample type */
} HTK_Param_Header;

typedef struct {
  HTK_Param_Header header;	/* parameter header */
  unsigned int samplenum;	/* num of sample (same in header) */
  short veclen;			/* parameter vector length */
  VECT **parvec;		/* pattern(parameter) vector */
} HTK_Param;


boolean rdparam(char *, HTK_Param *);
boolean read_param(FILE *, HTK_Param *);
HTK_Param *new_param();
void free_param(HTK_Param *);
short param_qualstr2code(char *);
short param_str2code(char *);
char *param_qualcode2str(char *, short, boolean);
char *param_code2str(char *, short, boolean);
HTK_Param *new_select_param_kind(HTK_Param *src, short select_qualifier);
boolean select_param_vmark(HTK_Param *src, short dst_type);
int exec_exclude_one_vector(VECT *vec, int len);
int guess_basenum(HTK_Param *p, short qualtype);
boolean param_strip_zero(HTK_Param *param);


/* hmminfo/put_htkdata_info.c */
void put_param_head(HTK_Param_Header *h);
void put_vec(VECT **p, int num, short veclen);
void put_param(HTK_Param *pinfo);
void put_param_info(HTK_Param *pinfo);

#endif /* __SENT_HTK_PARAM_H__ */
