/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* ptree.h --- patricia tree header */

/* $Id: ptree.h,v 1.5 2004/03/22 04:14:31 ri Exp $ */

#ifndef __PATRICIA_TREE_H__
#define __PATRICIA_TREE_H__

typedef struct __patnode__ {
  union {
    int         data;		/* leaf data */
    int		thres_bit;	/* threshold bit */
  } value;
  struct __patnode__ *left0;	/* pointer to left patnode (0)*/
  struct __patnode__ *right1;	/* pointer to right patnode (1)*/
	/* NOTE: both NULL -> this is leaf(thres_bit == WORDID)*/
} PATNODE;
typedef struct __apatnode__ {
  union {
    void        *data;		/* pointer to leaf data */
    int		thres_bit;	/* threshold bit */
  } value;
  struct __apatnode__ *left0;	/* pointer to left patnode (0)*/
  struct __apatnode__ *right1;	/* pointer to right patnode (1)*/
	/* NOTE: both NULL -> this is leaf(thres_bit == WORDID)*/
} APATNODE;


int testbit(char *str, int bitplace);
int where_the_bit_differ(char *str1, char *str2);
PATNODE *make_ptree(char **words, int *data, int wordsnum, int bitplace);
void disp_ptree(PATNODE *node, int level);
int ptree_search_data(char *str, PATNODE *rootnode);
PATNODE *ptree_make_root_node(int data);
void ptree_add_entry(char *str, int data, char *matchstr, PATNODE **rootnode);
void free_ptree(PATNODE *rootnode);

void *aptree_search_data(char *str, APATNODE *rootnode);
APATNODE *aptree_make_root_node(void *data);
void aptree_add_entry(char *str, void *data, char *matchstr, APATNODE **rootnode);
void aptree_traverse_and_do(APATNODE *node, void (*callback)(void *));
void free_aptree(APATNODE *rootnode);



#endif /* __PATRICIA_TREE_H__ */
