/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* adin-poraudio.c --- mic sub-routine for PortAudio */
/* use simplified blocking I/O layer */

/* $Id: $ */

#include <sent/stddefs.h>

#include "pa/pablio.h"

/* Stream Info */
PABLIO_Stream *aStream;

/* initialize portaudio device */
boolean
adin_mic_standby(int sfreq, void *dummy)
{
  PaError err;

  /* for safety... */
  if (sizeof(SP16) != paInt16) {
    j_error("SP16 != paInt16\n");
  }

  /* initialize device and open stream */
  err = OpenAudioStream(&aStream, sfreq, paInt16,
			(PABLIO_READ | PABLIO_MONO) );
  if (err != paNoError) {
    j_printerr("Error: %s\n", Pa_GetErrorText(err));
    return(FALSE);
  }
  return(TRUE);
}

/* start recording */
boolean
adin_mic_start()
{
  return(TRUE);
}

/* stop recording */
boolean
adin_mic_stop()
{
  return TRUE;
}

/* read samples from audio device */
/* try to read `sampnum' samples and returns actual sample num recorded */
int
adin_mic_read(SP16 *buf, int sampnum)
{
  long avail;

  while ((avail = GetAudioStreamReadable(aStream)) <= 0) {
    Pa_Sleep(50);		/* wait for 100ms, till some input comes */
  }
  if (avail > sampnum) avail = sampnum;
  if (avail != ReadAudioStream(aStream, buf, avail)) {
    j_printerr("Error: failed to read %d samples\n", sampnum);
    return(-2);
  }
  return avail;
}

