/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* hmm.h --- Hidden Marcov Model structure for recognition */
/* ref: wchmm.h */

/* $Id: hmm.h,v 1.4 2002/09/11 22:01:50 ri Exp $ */

#ifndef __SENT_HMM_NEW2_H__
#define __SENT_HMM_NEW2_H__

#include <sent/stddefs.h>
#include <sent/htk_hmm.h>
#include <sent/htk_param.h>

#define LOGTEN 2.30258509

/* transition arc data */
typedef struct __a_cell__ {
  LOGPROB		a;	/* transition logprob */
  int			arc;	/* transition destination */
  struct __a_cell__	*next;
} A_CELL;

typedef struct __hmm_state__ {
  A_CELL		*ac;	/* transition arc info (list) */
  union {
    HTK_HMM_State *state;	/* pointer to the mapped physical HMM */
    CD_State_Set  *cdset;		/* pointer to the pseudo HMM */
  } out;
  boolean is_pseudo_state;
} HMM_STATE;

typedef struct __hmm__ {
  int			len;	/* total state length */
  HMM_STATE		*state;	/* state array */
} HMM;


/* mkwhmm.c */
HMM *new_make_word_hmm(HTK_HMM_INFO *, HMM_Logical  **, int, boolean *);
HMM *new_make_word_hmm_with_lm(HTK_HMM_INFO *, HMM_Logical  **, int, boolean *, LOGPROB *);
void free_hmm(HMM *);
/* vsegment.c */
LOGPROB viterbi_segment(HMM *hmm, HTK_Param *param, int *endstates, int ulen, int **id_ret, int **seg_ret, LOGPROB **uscore_ret, int *retlen);

/* addlog.c */
void make_log_tbl();
LOGPROB addlog(LOGPROB x, LOGPROB y);
LOGPROB addlog10(LOGPROB x, LOGPROB y);
LOGPROB addlog_array(LOGPROB *x, int n);

/* outprob_init.c */
boolean
outprob_init(HTK_HMM_INFO *hmminfo,
	     HTK_HMM_INFO *gshmm, int gms_num,
	     int gprune_method, int gprune_mixnum
	     );
boolean outprob_prepare(int framenum);
/* outprob.c */
boolean outprob_cache_init();
boolean outprob_cache_prepare();
LOGPROB outprob_state(int t, HTK_HMM_State *stateinfo, HTK_Param *param);
LOGPROB outprob_cd(int t, CD_State_Set *lset, HTK_Param *param);
LOGPROB outprob(int t, HMM_STATE *hmmstate, HTK_Param *param);
/* gms.c */
boolean gms_init(int nbest);
boolean gms_prepare(int framelen);
LOGPROB gms_state();
/* gms_gprune.c */
void gms_gprune_init(HTK_HMM_INFO *hmminfo, int gsset_num);
void gms_gprune_prepare();
void compute_gs_scores(GS_SET *gsset, int gsset_num, LOGPROB *scores_ret);

/* calc_mix.c */
LOGPROB calc_mix();
/* calc_tied_mix.c */
boolean calc_tied_mix_init();
boolean calc_tied_mix_prepare(int framenum);
LOGPROB calc_tied_mix();

/* hmminfo/put_htkdata_info */
void put_hmm_arc(HMM *d);
void put_hmm_outprob(HMM *d);
void put_hmm(HMM *d);

#endif /* __SENT_HMM_NEW2_H__ */
