/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/******** these functions are out of date.  BOGUS!!! *********/

/*
** dialog.c --- communicate with dialog manager
**
*/


/* $Id: dialog.c,v 1.3 2002/09/11 22:01:50 ri Exp $ */

#include <sent/stddefs.h>
#include <sent/tcpip.h>

/* socket */
static int sock;

/* whether connect */
static int connect_flag = FALSE;

/* connect to dialog manager */
void
dm_connect(char *hostname)
{
  struct sockaddr_in dm;
  struct hostent *host;

  memset((char *)&dm, 0, sizeof(dm));
  dm.sin_family = AF_INET;
  dm.sin_port = DM_PORT_NUM;
  if ((host = gethostbyname(hostname)) == NULL)
    {
      j_error("%s: unknown host\n",hostname);
    }
  memcpy(&dm.sin_addr, host->h_addr, host->h_length);
  if ((sock = socket(PF_INET, SOCK_STREAM, 0)) == -1)
    {
      j_error("Can't create socket\n");
    }
  if (connect(sock, (struct sockaddr *)&dm, sizeof(dm)) == -1)
    {
      j_error("Can't connect to %s\n",hostname);
    }
  connect_flag = TRUE;
}

/* send sentence hypothesis to dialog manager */
void
dm_send_sentence(WORD_ID words[], short num)
{
  int nbyte;
  if (!connect_flag)
    {
      j_error( "Connection hasn't established yet.\n");
    }
  nbyte = num * sizeof(WORD_ID);
  if (write(sock, words, nbyte) != nbyte)
    {
      j_error("Failed to write to socket.\n");
    }
}
      
/* receive acknowledgement from dialog manager */
int				/* return value: the acknowledge value */
dm_receive_ack()
{
  int ack;
  int nbyte;
  if (!connect_flag)
    {
      j_printerr( "Connection hasn't established yet.\n");
      return -1;
    }
  nbyte = sizeof(int);
  if (read(sock, &ack, nbyte) != nbyte)
    {
      j_printerr("Failed to write to socket.\n");
      return -1;
    }
  return(ack);
}
