/*
 * Copyright (c) 1991-2004 Kyoto University
 * Copyright (c) 2000-2004 NAIST
 * All rights reserved
 */

/* global.h --- global variables */

/* $Id: global.h,v 1.28 2004/04/27 04:55:31 ri Exp $ */

#ifndef __SENT_EXTERNAL_DEFINITION__
#define __SENT_EXTERNAL_DEFINITION__

#include <sent/stddefs.h>
#include <sent/hmm.h>
#include <sent/vocabulary.h>
#ifdef USE_NGRAM
#include <sent/ngram2.h>
#else  /* USE_DFA */
#include <sent/dfa.h>
#endif
#include "wchmm.h"

/* If GLOBAL_VARIABLE_DEFINE is defined, global variables are actually made */
/* Else, these are external definition */
#ifdef GLOBAL_VARIABLE_DEFINE
#define GLOBAL /*  */
#define GLOBAL_VAL(v) = (v)
#else
#define GLOBAL extern
#define GLOBAL_VAL(v) /*  */
#endif


/* -------------------------------------------------------------- */
/* ------- user-specified filenames ----------------------------- */
/* -------------------------------------------------------------- */

/* filenames */
GLOBAL char *hmmfilename GLOBAL_VAL(NULL);/* HMM hmmdefs */
GLOBAL char *mapfilename GLOBAL_VAL(NULL); /* HMMlist */
GLOBAL char *hmm_gs_filename GLOBAL_VAL(NULL); /* hmmdefs for GMS (NULL if not used) */
GLOBAL char *dictfilename GLOBAL_VAL(NULL); /* word dictionary */
#ifdef USE_NGRAM
GLOBAL char *ngram_filename GLOBAL_VAL(NULL); /* N-gram (binary format) */
GLOBAL char *ngram_filename_lr_arpa GLOBAL_VAL(NULL); /* N-gram in ARPA format(LR 2-gram)*/
GLOBAL char *ngram_filename_rl_arpa GLOBAL_VAL(NULL); /* N-gram in ARPA format(RL 3-gram)*/
#endif
#ifdef USE_DFA
GLOBAL char *dfa_filename GLOBAL_VAL(NULL); /* DFA grammar */
#endif

GLOBAL char *inputlist_filename GLOBAL_VAL(NULL); /* input file list */
GLOBAL char *cmnload_filename GLOBAL_VAL(NULL);	/* load CMN parameter from */
GLOBAL char *cmnsave_filename GLOBAL_VAL(NULL);	/* save CMN parameter to */
GLOBAL char *ssload_filename GLOBAL_VAL(NULL); /* load SS parameter from */
GLOBAL char *record_dirname GLOBAL_VAL(NULL); /* record speech data to dir */


/* -------------------------------------------------------------- */
/* ------- user-specified parameters ---------------------------- */
/* -------------------------------------------------------------- */

/* input source */
GLOBAL int speech_input GLOBAL_VAL(SP_MFCFILE); /* specify input source */
GLOBAL int adinnet_port GLOBAL_VAL(ADINNET_PORT); /* port number for adinnet input */
#ifdef USE_NETAUDIO
GLOBAL char *netaudio_devname GLOBAL_VAL("localhost:0"); /* host and unit name for NetAudio/DatLink input */
#endif

/* input triggering and silence cutting (pause segmentation) */
GLOBAL int silence_cut GLOBAL_VAL(2); /* 0..off 1.. on 2.. use device default */
GLOBAL int level_thres GLOBAL_VAL(2000); /* level threshold */
GLOBAL int zero_cross_num GLOBAL_VAL(60); /* zero cross num per second */
GLOBAL int head_margin_msec GLOBAL_VAL(300); /* head margin in msec */
GLOBAL int tail_margin_msec GLOBAL_VAL(400); /* tail margin in msec */

GLOBAL boolean strip_zero_sample GLOBAL_VAL(TRUE); /* strip off zero samples */
GLOBAL boolean use_zmean GLOBAL_VAL(FALSE); /* remove DC by zero mean */

/* speech analysis parameters */
GLOBAL int smpPeriod GLOBAL_VAL(625); /* sampling period (16kHz: 625ns) */
GLOBAL int smpFreq GLOBAL_VAL(16000); /* sampling freq.  (16kHz: 625ns) */
GLOBAL int fshift GLOBAL_VAL(DEF_FRAMESHIFT); /* Frame shift (160sample = 10ms in 16kHz) */
GLOBAL int fsize GLOBAL_VAL(DEF_FRAMESIZE); /* Window size (400sample = 25ms in 16kHz) */
GLOBAL int delwin GLOBAL_VAL(DEF_DELWIN); /* delta window length (2 frame = 20ms) */
/* lo-pass/hi-pass filter */
GLOBAL int hipass GLOBAL_VAL(-1); /* frequency of hi pass filter. -1 means no use hi pass filter */
GLOBAL int lopass GLOBAL_VAL(-1); /* frequency of lo pass filter. -1 means no use lo pass filter */

/* spectral subtraction */
GLOBAL boolean sscalc GLOBAL_VAL(FALSE); /* compute SS using head silence for file input */
GLOBAL int sscalc_len GLOBAL_VAL(300); /* head silence length used to compute SS (in msec) */
GLOBAL float ssalpha GLOBAL_VAL(DEF_SSALPHA); /* alpha coef. for SS */
GLOBAL float ssfloor GLOBAL_VAL(DEF_SSFLOOR); /* spectral floor for SS */

/* LM parameters */
#ifdef USE_NGRAM
GLOBAL LOGPROB lm_weight;	/* language model weight */
GLOBAL LOGPROB lm_penalty;	/* insertion penalty */
GLOBAL LOGPROB lm_weight2;	/* language model weight for 2nd pass */
GLOBAL LOGPROB lm_penalty2;	/* insertion penalty for 2nd pass*/
GLOBAL LOGPROB lm_penalty_trans GLOBAL_VAL(0.0); /* insertion penalty for transparent word */
#endif /* USE_NGRAM */
#ifdef USE_DFA
GLOBAL LOGPROB penalty1 GLOBAL_VAL(0.0); /* insertion penalty for 1st pass */
GLOBAL LOGPROB penalty2 GLOBAL_VAL(0.0); /* insertion penalty for 2nd pass */
#endif
#ifdef CONFIDENCE_MEASURE
#ifdef CM_MULTIPLE_ALPHA	/* test multiple alpha coef. */
GLOBAL LOGPROB cm_alpha_bgn GLOBAL_VAL(0.03); /* begin value */
GLOBAL LOGPROB cm_alpha_end GLOBAL_VAL(0.15); /* end value */
GLOBAL LOGPROB cm_alpha_step GLOBAL_VAL(0.03); /* step value */
GLOBAL int cm_alpha_num GLOBAL_VAL(5); /* number of output calculated from above */
#else  /* single value (default) */
GLOBAL LOGPROB cm_alpha GLOBAL_VAL(0.05); /* CM log score scaling factor */
#endif
#endif /* CONFIDENCE_MEASURE */

/* pause model names */
#ifdef USE_NGRAM
GLOBAL char *head_silname GLOBAL_VAL(BEGIN_WORD_DEFAULT); /* sil model name to begin search */
GLOBAL char *tail_silname GLOBAL_VAL(END_WORD_DEFAULT); /* sil model name to end search */
/* short pause word auto create */
GLOBAL boolean enable_iwspword GLOBAL_VAL(FALSE); /* enable inter-word short pause word creation */
GLOBAL char *iwspentry GLOBAL_VAL(IWSPENTRY_DEFAULT); /* given dict entry for the iwspword */
#endif
GLOBAL char *spmodel_name GLOBAL_VAL(SPMODEL_NAME_DEFAULT); /* sp model logical name that will be skipped at search */

/* 1) in DFA mode, a word with only "spmodel_name" model as a pronunciation will be specially handled as "short-pause word" */
/* 2) if "-iwsp" enabled, the "spmodel_name" model will be attached to every word end within the dictionary */
/* short pause special handling */
GLOBAL boolean enable_iwsp GLOBAL_VAL(FALSE); /* enable inter-word short pause handling */
GLOBAL LOGPROB iwsp_penalty GLOBAL_VAL(IWSP_PENALTY_DEFAULT); /* transition penalty of inter-word short pause */

/* search parameters for acoustic computation */
GLOBAL int gprune_method GLOBAL_VAL(GPRUNE_SEL_UNDEF); /* Gaussian pruning method (default: use default of engine configuration) */
GLOBAL int mixnum_thres GLOBAL_VAL(2);	/* Gaussian pruning: number of Gaussian to select per mixture */
GLOBAL int gs_statenum GLOBAL_VAL(24);	/* GMS: number of mixture PDF to select */

/* search parameters for 1st pass */
GLOBAL int trellis_beam_width GLOBAL_VAL(-1); /* beam width of 1st pass (-1 == guess from vocabulary size */
#ifdef SEPARATE_BY_UNIGRAM
GLOBAL int separate_wnum GLOBAL_VAL(DEFAULT_SEPARATE_WNUM); /* word num from best freq. to separate from tree */
#endif
#ifdef WPAIR
# ifdef WPAIR_KEEP_NLIMIT
GLOBAL int wpair_keep_nlimit GLOBAL_VAL(3); /* keeps only N token on wpair */
# endif
#endif
#ifdef HASH_CACHE_IW
GLOBAL int iw_cache_rate GLOBAL_VAL(10);	/* inter-word LM cache size rate for vocabulary size */
#endif

/* search parameters for 2nd pass */
GLOBAL int enveloped_bestfirst_width GLOBAL_VAL(30); /* word beam width of 2nd pass (word envelope) (-1 means no beaming) */
#ifdef SCAN_BEAM
GLOBAL LOGPROB scan_beam_thres GLOBAL_VAL(80.0); /* score beam threshold of 2nd pass (score envelope) */
#endif
GLOBAL int hypo_overflow GLOBAL_VAL(2000); /* hypo. overflow thres at 2nd pass */
GLOBAL int stack_size GLOBAL_VAL(500); /* hypo. stack size of 2nd pass */
GLOBAL int lookup_range GLOBAL_VAL(5); /* trellis lookup range for word expansion in 2nd pass */
GLOBAL int nbest;		/* search until n sentence are found */
GLOBAL int output_hypo_maxnum GLOBAL_VAL(1); /* number of sentence to output */

#ifdef SP_BREAK_CURRENT_FRAME
/* short-pause segmentation */
GLOBAL int sp_frame_duration GLOBAL_VAL(10);/* default length of sp frames to be treated as break point */
#endif /* SP_BREAK_CURRENT_FRAME */

/* output parameters */
GLOBAL int result_output GLOBAL_VAL(SP_RESULT_TTY);/* select output device */
GLOBAL int progout_interval GLOBAL_VAL(300); /* progout interval in msec */

/* module mode parameters */
GLOBAL int module_port GLOBAL_VAL(DEFAULT_MODULEPORT); /* port number to listen */

/* if input is shorter than this msec, input will be rejected */
GLOBAL int rejectshortlen GLOBAL_VAL(0);

/* -------------------------------------------------------------- */
/* -------- user-specified switches ----------------------------- */
/* -------------------------------------------------------------- */

/* enable/disable model check function */
GLOBAL boolean wchmm_check_flag GLOBAL_VAL(FALSE); /* enter wchmm interactive check if TRUE */
GLOBAL boolean trellis_check_flag GLOBAL_VAL(FALSE); /* enter trellis interactive check if TRUE */
GLOBAL boolean triphone_check_flag GLOBAL_VAL(FALSE); /* enter triphone existence check if TRUE */

/* dictionary */
GLOBAL boolean forcedict_flag GLOBAL_VAL(FALSE); /* if TRUE, ignore error words and keep going */

/* search */
GLOBAL boolean compute_only_1pass GLOBAL_VAL(FALSE); /* if TRUE, compute only 1pass */
GLOBAL boolean forced_realtime GLOBAL_VAL(FALSE); /* user-specified value of whether to do on-the-fly decoding on 1st pass */
GLOBAL boolean force_realtime_flag GLOBAL_VAL(FALSE); /* TRUE if explicitly specified by user (if not specified (FALSE), use device-dependent default) */
#ifdef CATEGORY_TREE
GLOBAL boolean old_tree_function_flag GLOBAL_VAL(FALSE); /* use build_wchmm() instead of fast build_wchmm2() (for debug only) */
#ifdef PASS1_IWCD
GLOBAL boolean old_iwcd_flag GLOBAL_VAL(FALSE); /* use full lcdset instead of *category-pair-aware lcdset (new in 3.2) */
#endif
#endif
#ifdef USE_NGRAM
GLOBAL short iwcdmethod GLOBAL_VAL(IWCD_NBEST); /* use average score of lcdset in cross-word triphone */
#else
GLOBAL short iwcdmethod GLOBAL_VAL(IWCD_AVG);
#endif
GLOBAL short iwcdmaxn GLOBAL_VAL(3);
#ifdef USE_DFA
GLOBAL boolean looktrellis_flag GLOBAL_VAL(FALSE); /* restrict expansion on only neighbor frames (-looktrellis) for 2nd pass */
#endif
GLOBAL boolean result_reorder_flag GLOBAL_VAL(TRUE); /* re-order n-best result by score on 2nd pass if TRUE */

/* forced alignment */
GLOBAL boolean align_result_word_flag GLOBAL_VAL(FALSE); /* -walign */
GLOBAL boolean align_result_phoneme_flag GLOBAL_VAL(FALSE); /* -palign */
GLOBAL boolean align_result_state_flag GLOBAL_VAL(FALSE); /* -salign */

/* server module mode */
GLOBAL boolean module_mode GLOBAL_VAL(FALSE);/* TRUE if started as module */

/* output */
GLOBAL boolean verbose_flag GLOBAL_VAL(TRUE); /* verbose output */
GLOBAL boolean debug2_flag GLOBAL_VAL(FALSE); /* debug^2 output */
GLOBAL boolean paramtype_check_flag GLOBAL_VAL(TRUE); /* check MFCC parameter type toward hmmdefs */
GLOBAL boolean progout_flag GLOBAL_VAL(FALSE); /* progressive output */
#ifdef USE_NGRAM
GLOBAL boolean separate_score_flag GLOBAL_VAL(FALSE); /* output score in AM/LM */
#endif

/* -------------------------------------------------------------- */
/* -------- inner status holders -------------------------------- */
/* -------------------------------------------------------------- */
/* for LM */
GLOBAL boolean lmp_specified GLOBAL_VAL(FALSE); /* true if -lmp specified */
GLOBAL boolean lmp2_specified GLOBAL_VAL(FALSE); /* true if -lmp2 specified */
/* for search */
GLOBAL boolean realtime_flag GLOBAL_VAL(FALSE);	/* do on-the-fly decoding if TRUE */
GLOBAL boolean ccd_flag GLOBAL_VAL(TRUE); /* handle hmmdefs as context-dependent HMM if TRUE (default determined from hmmdefs macro name) */
GLOBAL boolean ccd_flag_force GLOBAL_VAL(FALSE); /* if TRUE, user-specified ccd_flag will override hmmdefs defaults */

/* misc */
GLOBAL boolean catch_intr_flag GLOBAL_VAL(FALSE); /* TRUE when catch SIGINT */

/* -------------------------------------------------------------- */
/* -------- work area for search -------------------------------- */
/* -------------------------------------------------------------- */

/* models */
GLOBAL HTK_HMM_INFO *hmminfo GLOBAL_VAL(NULL);/* main phoneme HMM */
GLOBAL HTK_HMM_INFO *hmm_gs GLOBAL_VAL(NULL); /* HMM for GS */
GLOBAL WORD_INFO *winfo GLOBAL_VAL(NULL); /* word dictionary */
#ifdef USE_NGRAM
GLOBAL NGRAM_INFO *ngram GLOBAL_VAL(NULL); /* N-gram language model */
#else
GLOBAL MULTIGRAM *gramlist GLOBAL_VAL(NULL); /* list of grammars */
GLOBAL DFA_INFO *dfa GLOBAL_VAL(NULL); /* global DFA grammar */
#endif

/* tree lexicon HMM */
GLOBAL WCHMM_INFO *wchmm GLOBAL_VAL(NULL);/* word-conjunction HMM */
GLOBAL BACKTRELLIS backtrellis; /* heuristic infos */
GLOBAL LOGPROB backmax;		/* best score of last 1st pass */

/* misc. for search */
GLOBAL int peseqlen;

/* for score envelope beaming */
#ifdef SCAN_BEAM
GLOBAL LOGPROB *framemaxscore;/* maximum score of each frame on 2nd pass */
#endif

/* input speech related */
GLOBAL SP16 speech[MAXSPEECHLEN]; /* speech data */
GLOBAL int speechlen GLOBAL_VAL(0);		/* speech length */
GLOBAL boolean cmn_loaded GLOBAL_VAL(FALSE); /* TRUE if CMN loaded from file */
GLOBAL boolean c0_required GLOBAL_VAL(FALSE); /* TRUE when 0'th Cepstral parameter is used instead of energy in hmmdefs */
GLOBAL boolean cmn_required GLOBAL_VAL(TRUE);

/* spectral subtraction */
GLOBAL float *ssbuf GLOBAL_VAL(NULL);/* noise spectrum */
GLOBAL int sslen;		/* length of above */

#ifdef SP_BREAK_CURRENT_FRAME
/* short-pause segmentation */
GLOBAL HTK_Param *rest_param GLOBAL_VAL(NULL);/* rest param of next segment */
GLOBAL WORD_ID sp_break_last_word GLOBAL_VAL(WORD_INVALID); /* last maximum word hypothesis on the begin point */
GLOBAL WORD_ID sp_break_last_nword GLOBAL_VAL(WORD_INVALID); /* last (not transparent) word for LM */
GLOBAL boolean sp_break_last_nword_allow_override GLOBAL_VAL(TRUE);
GLOBAL WORD_ID sp_break_2_begin_word GLOBAL_VAL(WORD_INVALID);
GLOBAL WORD_ID sp_break_2_end_word GLOBAL_VAL(WORD_INVALID);
#endif

/* output */
GLOBAL WORD_ID pass1_wseq[MAXSEQNUM]; /* word seq. of best hypo on 1st pass */
GLOBAL int pass1_wnum; /* word num of above */
GLOBAL LOGPROB pass1_score;	/* score of above */

/* pointer to output functions (switched by 'result_output') */
GLOBAL void (*status_recready)();
GLOBAL void (*status_recstart)();
GLOBAL void (*status_recend)();
GLOBAL void (*status_param)(HTK_Param *p);
GLOBAL void (*result_pass1_begin)();
GLOBAL void (*result_pass1_current)(int t, WORD_ID *seq, int num, LOGPROB score, LOGPROB LMscore, WORD_INFO *winfo);
GLOBAL void (*result_pass1_final)(WORD_ID *seq, int num, LOGPROB score, LOGPROB LMscore, WORD_INFO *winfo);
GLOBAL void (*result_pass1_end)();
GLOBAL void (*result_pass2_begin)();
GLOBAL void (*result_pass2)(NODE *hypo, int rank, WORD_INFO *winfo);
GLOBAL void (*result_pass2_end)();
GLOBAL void (*result_pass2_failed)(WORD_INFO *winfo);
GLOBAL void (*result_rejected)(const char *);

#endif /* __SENT_EXTERNAL_DEFINITION__ */
