package org.junitdoc.core.decisiontable;

import java.util.List;

import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.junitdoc.core.rewriter.ASTUtils;
import org.junitdoc.preferences.PreferenceConstants;
import org.junitdoc.preferences.PreferenceUtils;

public class TestMethod {

	private DecisionTableModel decisionTable;

	private MethodDeclaration methodDeclaration;

	private String name;

	private int index;

	public TestMethod(DecisionTableModel decisionTable,
			MethodDeclaration methodDeclaration, int index) {
		this.decisionTable = decisionTable;
		this.methodDeclaration = methodDeclaration;
		this.name = methodDeclaration.getName().getFullyQualifiedName();
		this.index = index;
	}

	public DecisionTableModel getDecisionTable() {
		return decisionTable;
	}

	public MethodDeclaration getMethodDeclaration() {
		return methodDeclaration;
	}

	public String getName() {
		return name;
	}

	public int getIndex() {
		return index;
	}

	public String getCheckState(Type type) {

		List modifiers = methodDeclaration.modifiers();
		for (Object modifier : modifiers) {
			if (modifier instanceof MarkerAnnotation) {
				MarkerAnnotation anno = (MarkerAnnotation) modifier;

				String typeName = type.getFullName();
				if (anno.getTypeName().getFullyQualifiedName().equals(typeName)) {
					return PreferenceUtils
							.getString(PreferenceConstants.DECISION_TABLE_CHECK_LABEL);
				}
			}
		}
		return PreferenceUtils
				.getString(PreferenceConstants.DECISION_TABLE_UNCHECK_LABEL);
	}

	public boolean isChecked(Type type) {
		String checkState = getCheckState(type);
		if (checkState.equals(PreferenceUtils
				.getString(PreferenceConstants.DECISION_TABLE_CHECK_LABEL))) {
			return true;
		} else {
			return false;
		}
	}

	public List<MarkerAnnotation> getMarkerAnnotations() {
		List<MarkerAnnotation> markers = ASTUtils
				.findAnnotatedMarkerAnnotation(methodDeclaration);
		return markers;
	}

	public MarkerAnnotation getMarkerAnnotation(Type type) {
		List<MarkerAnnotation> markers = getMarkerAnnotations();

		for (MarkerAnnotation marker : markers) {
			if (marker.getTypeName().getFullyQualifiedName().equals(
					type.getFullName())) {

				return marker;
			}
		}
		return null;
	}
}
