package org.junitdoc.core.testcasetable;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jface.viewers.TreeNode;
import org.junitdoc.core.util.JavaDocUtils;
import org.junitdoc.ui.Const;

public class TestCaseTableModel {

	List<Category> categories = new ArrayList<Category>();

	public TreeNode[] toTreeNodeModel() {
		TreeNode[] rootNode = new TreeNode[categories.size()];

		for (int i = 0; i < rootNode.length; i++) {
			Category category = categories.get(i);
			rootNode[i] = new TreeNode(category);
			setChildren(rootNode[i], category);
		}

		return rootNode;
	}

	private void setChildren(TreeNode parent, Category category) {

		if (category.hasChildren()) {
			List<Category> children = category.getChildren();

			TreeNode[] childrenNode = new TreeNode[children.size()];
			for (int i = 0; i < childrenNode.length; i++) {
				Category child = children.get(i);
				childrenNode[i] = new TreeNode(child);
				childrenNode[i].setParent(parent);

				setChildren(childrenNode[i], child);
			}

			parent.setChildren(childrenNode);
		}
	}

	public void parse(List<MethodDeclaration> methods) {

		TreeMap<String, Category> map = new TreeMap<String, Category>();

		for (MethodDeclaration method : methods) {
			Javadoc javadoc = method.getJavadoc();
			if (javadoc == null) {
				continue;
			}

			TextElement testCaseElement = JavaDocUtils.findSingleJavadocValue(
					javadoc, Const.JAVADOC.TESTCASE);
			TextElement testsuiteElement = JavaDocUtils.findSingleJavadocValue(
					javadoc, Const.JAVADOC.TESTSUITE);
			List<TextElement> stepElements = JavaDocUtils
					.findMultiJavadocValue(javadoc, Const.JAVADOC.STEPs);
			List<TextElement> expectedElements = JavaDocUtils
					.findMultiJavadocValue(javadoc, Const.JAVADOC.EXPECTED_RESULTS);

			if (isNull(testCaseElement, testsuiteElement)) {
				continue;
			}

			String categoryName = testsuiteElement.getText();
			if (!map.containsKey(categoryName)) {
				Category category = new Category(categoryName);
				map.put(categoryName, category);
			}

			TestCase testCase = new TestCase(testCaseElement);
			testCase.setCategory(map.get(categoryName));
			map.get(categoryName).addChild(testCase);

			testCase.setSteps(stepElements);
			testCase.setExpected(expectedElements);

		}
		categories.clear();
		categories.addAll(map.values());
	}

	private boolean isNull(TextElement testCaseElement,
			TextElement categoryElement) {
		return testCaseElement == null || categoryElement == null;
	}

}
