package org.junitdoc.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.junitdoc.JUnitDocPlugin;

public abstract class Exporter {

	private Shell shell;

	private String title;

	public Exporter(Shell shell, String title) {
		this.shell = shell;
		this.title = title;
	}

	protected abstract String getContents() throws Exception;

	protected abstract String[] getFilterExtensions();

	public void export() {

		FileDialog dialog = new FileDialog(shell, SWT.SAVE);
		dialog.setText("Export " + title);
		dialog.setFilterExtensions(getFilterExtensions());
		dialog.setFilterPath(new File(".").getAbsolutePath());
		String fileName = dialog.open();
		if (fileName != null) {
			String contents;
			try {
				contents = getContents();
				save(fileName, contents);

			} catch (Throwable e) {
				JUnitDocPlugin.errorLog("can't save a file. path=" + fileName, e);
			}
		}
	}

	private void save(String fileName, String contents) throws IOException {
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));

			pw.print(contents);
			pw.close();

		} finally {
			if (pw != null) {
				pw.close();
			}
		}

	}

}
