package org.junitdoc.core.jdt;

import java.util.List;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.core.rewriter.ASTUtils;
import org.junitdoc.core.rewriter.JDTUtils;

public class Method {

	private MethodDeclaration methodDeclaration;

	public Method(MethodDeclaration methodDeclaration) {
		this.methodDeclaration = methodDeclaration;
	}

	public Method(IMethod method) {
		ICompilationUnit source = method.getCompilationUnit();
		CompilationUnit ast = ASTUtils.createAST(source);

		this.methodDeclaration = ASTUtils.findMethodDeclaration(ast, method);

		if (methodDeclaration == null) {
			JUnitDocPlugin.errorLog("ERROR !!!!");
		}
	}

	public MethodDeclaration getSource() {
		return methodDeclaration;
	}

	public List<MarkerAnnotation> getMarkerAnnotations() {
		List<MarkerAnnotation> markers = ASTUtils
				.findAnnotatedMarkerAnnotation(methodDeclaration);
		return markers;
	}

	public MarkerAnnotation getMarkerAnnotation(String fullName) {
		List<MarkerAnnotation> markers = getMarkerAnnotations();

		for (MarkerAnnotation marker : markers) {
			if (marker.getTypeName().getFullyQualifiedName().equals(fullName)) {

				return marker;
			}
		}
		return null;
	}

	public boolean hasMarkerAnnotation(String annotationName) {
		List modifiers = methodDeclaration.modifiers();
		for (Object modifier : modifiers) {
			if (modifier instanceof MarkerAnnotation) {
				MarkerAnnotation anno = (MarkerAnnotation) modifier;

				if (anno.getTypeName().getFullyQualifiedName().equals(
						annotationName)) {
					return true;
				}
			}
		}
		return false;
	}

	public void selectAndReveal() {
		selectAndReveal(JDTUtils.getActiveJavaEditor());
	}

	public void selectAndReveal(JavaEditor javaEditor) {
		if (javaEditor == null) {
			return;
		}

		javaEditor.selectAndReveal(methodDeclaration.getName()
				.getStartPosition(), methodDeclaration.getName().getLength());
	}

}
