package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.junitdoc.ui.Const;

public class NewTestMethodHandler extends RewriteHandlerAdapter {

	private String decisionTableName;

	private String testMethodName;

	public NewTestMethodHandler(String decisionTableName, String testMethodName) {
		this.decisionTableName = decisionTableName;
		this.testMethodName = testMethodName;
	}

	@Override
	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		TypeDeclaration type = ASTUtils.findFirstTypeDeclaration(node);

		AST ast = node.getAST();

		// declare test method.
		ListRewrite listRewrite = rewrite.getListRewrite(type,
				TypeDeclaration.BODY_DECLARATIONS_PROPERTY);

		MethodDeclaration newMethodDeclaration = ast.newMethodDeclaration();
		newMethodDeclaration.setName(ast.newSimpleName(testMethodName));

		// @decisionTableName
		MarkerAnnotation newDecisionTableMarkAnnotation = ast
				.newMarkerAnnotation();
		newDecisionTableMarkAnnotation.setTypeName(ast
				.newName(decisionTableName));
		newMethodDeclaration.modifiers().add(newDecisionTableMarkAnnotation);

		// @Test
		MarkerAnnotation newTestAnnotation = ast.newMarkerAnnotation();
		newTestAnnotation.setTypeName(ast.newName(Const.TEST_ANNOTATION));
		newMethodDeclaration.modifiers().add(newTestAnnotation);

		// add "public void".
		newMethodDeclaration.modifiers().add(
				ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
		newMethodDeclaration.setReturnType2(ast
				.newPrimitiveType(PrimitiveType.VOID));

		// add "throws Exception"
		newMethodDeclaration.thrownExceptions().add(
				ast.newSimpleName("Exception"));

		// add block {};
		newMethodDeclaration.setBody(ast.newBlock());

		// write
		listRewrite.insertLast(newMethodDeclaration, null);

	}
}
