package org.junitdoc.core.testcasetable;

import java.util.List;

import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TextElement;

public class TestCase extends Category {

	private MethodDeclaration methodDeclaration;

	private List<TextElement> steps;

	private List<TextElement> expected;

	private Category category;

	private TextElement testCaseElement;

	public TestCase(String name) {
		super(name);
	}

	public TestCase(TextElement testCaseElement) {
		super(testCaseElement.getText());
		this.testCaseElement = testCaseElement;
	}

	public void setSteps(List<TextElement> steps) {
		this.steps = steps;
	}

	public void setExpected(List<TextElement> expectedElements) {
		this.expected = expectedElements;
	}

	public List<TextElement> getSteps() {
		return steps;
	}

	public List<TextElement> getExpected() {
		return expected;
	}

	public void setMethodDeclaration(MethodDeclaration methodDeclaration) {
		this.methodDeclaration = methodDeclaration;
	}

	public MethodDeclaration getMethodDeclaration() {
		return methodDeclaration;
	}

	public void setCategory(Category category) {
		this.category = category;
	}

	public Category getCategory() {
		return category;
	}

}
