package org.junitdoc.ui.decisiontable;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.ToggleLinkingAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.junitdoc.JUnitDocPlugin;
import org.junitdoc.core.rewriter.JDTUtils;
import org.junitdoc.core.rewriter.NewActionHandler;
import org.junitdoc.core.rewriter.NewConditionHandler;
import org.junitdoc.core.rewriter.NewDecisionTableHandler;
import org.junitdoc.core.rewriter.NewTestMethodHandler;
import org.junitdoc.core.rewriter.Rewriter;
import org.junitdoc.preferences.PreferenceConstants;
import org.junitdoc.preferences.PreferenceUtils;
import org.junitdoc.ui.UIMessages;

public class DecisionTableViewPart extends ViewPart {

	private Composite parent;
	private DecisionTablesTabPage tabPage;
	private Action newDecisionTableAction;
	private Action newCondtionAction;
	private Action newActionAction;
	private Action newTestMethodAction;
	private Action exportAction;
	private Action refreshAction;
	private Action syncAction;
	private Action doubleClickAction;
	private ICompilationUnit source;

	private ISelectionListener listener = new ISelectionListener() {
		public void selectionChanged(IWorkbenchPart workbenchPart,
				ISelection selection) {

			JUnitDocPlugin.debugLog("selectionChanged"); //$NON-NLS-1$
			JUnitDocPlugin.debugLog(selection.getClass());
			JUnitDocPlugin.debugLog(selection);

			final ICompilationUnit currentUnit = JDTUtils.getICompilationUnit();

			if (currentUnit == null || tabPage.getControl() == null
					|| tabPage.getControl().isDisposed()) {
				return;
			}

			if (!currentUnit.equals(source)) {
				Display d = tabPage.getControl().getDisplay();
				if (d != null) {
					d.asyncExec(new Runnable() {
						public void run() {
							initialize(currentUnit);
						}
					});
				}
			}
			source = currentUnit;
		}
	};

	public void newDecisionTable(final String name) {
		Rewriter.execute(source, new NewDecisionTableHandler(name));
	}

	public void newCondition(String decisionTableName, String conditionName) {
		Rewriter.execute(source, new NewConditionHandler(decisionTableName,
				conditionName));
	}

	public void newAction(String decisionTableName, String actionName) {
		Rewriter.execute(source, new NewActionHandler(decisionTableName,
				actionName));
	}

	public void newTestMethod(String decisionTableName, String testMethodName) {
		Rewriter.execute(source, new NewTestMethodHandler(decisionTableName,
				testMethodName));
	}

	public void initialize(ICompilationUnit source) {
		JUnitDocPlugin.debugLog("initialize...."); //$NON-NLS-1$
		this.source = source;
		tabPage.initialize(source);
	}

	public void createPartControl(Composite parent) {
		JUnitDocPlugin.debugLog("createPart"); //$NON-NLS-1$

		this.parent = parent;
		if (tabPage == null) {
			tabPage = new DecisionTablesTabPage(parent);
			JavaCore.addElementChangedListener(tabPage);
		}

		makeActions();
		hookContextMenu();
		// hookDoubleClickAction();
		contributeToActionBars();

		getSite().getPage().addPostSelectionListener(listener);
	}

	@Override
	public void dispose() {
		JUnitDocPlugin.debugLog("DecisionTableViewPart dispose()"); //$NON-NLS-1$
		getSite().getPage().removeSelectionListener(listener);
		JavaCore.removeElementChangedListener(tabPage);
		super.dispose();
	}

	private void hookContextMenu() {
		MenuManager menuMgr = new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				DecisionTableViewPart.this.fillContextMenu(manager);
			}
		});
		tabPage.setMenuManager(menuMgr);
		// getSite().registerContextMenu(menuMgr,
		// tabPage.getControl().getSelection().getData());
	}

	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		fillLocalPullDown(bars.getMenuManager());
		fillLocalToolBar(bars.getToolBarManager());
	}

	private void fillLocalPullDown(IMenuManager manager) {
		manager.add(newDecisionTableAction);
		manager.add(new Separator());
		manager.add(newCondtionAction);
		manager.add(newActionAction);
		manager.add(new Separator());
		manager.add(newTestMethodAction);
		manager.add(new Separator());
		manager.add(exportAction);
		manager.add(refreshAction);
		// manager.add(syncAction);
	}

	private void fillContextMenu(IMenuManager manager) {
		manager.add(newDecisionTableAction);
		manager.add(new Separator());
		manager.add(newCondtionAction);
		manager.add(newActionAction);
		manager.add(new Separator());
		manager.add(newTestMethodAction);
		manager.add(new Separator());
		manager.add(exportAction);
		manager.add(refreshAction);
		// manager.add(syncAction);
		// Other plug-ins can contribute there actions here
		manager.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
	}

	private void fillLocalToolBar(IToolBarManager manager) {
		manager.add(newDecisionTableAction);
		manager.add(new Separator());
		manager.add(newCondtionAction);
		manager.add(newActionAction);
		manager.add(new Separator());
		manager.add(newTestMethodAction);
		manager.add(new Separator());
		manager.add(exportAction);
		manager.add(refreshAction);
		// manager.add(syncAction);
	}

	private void makeActions() {
		newDecisionTableAction = new Action() {
			public void run() {
				InputDialog dialog = new InputDialog(
						parent.getShell(),
						UIMessages
								.getString("DecisionTableViewPart.new.decisiontable.title"), UIMessages.getString("DecisionTableViewPart.new.decisiontable.description"), "", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						new IInputValidator() {
							public String isValid(String newText) {
								if (newText.length() == 0) {
									return UIMessages
											.getString("DecisionTableViewPart.new.decisiontable.validmessage"); //$NON-NLS-1$
								}
								return null; // OK
							}
						});
				if (dialog.open() == Window.OK) {
					newDecisionTable(dialog.getValue());
				}
			}
		};
		newDecisionTableAction.setText(UIMessages
				.getString("DecisionTableViewPart.new.decisiontable.title")); //$NON-NLS-1$
		newDecisionTableAction.setToolTipText(UIMessages
				.getString("DecisionTableViewPart.new.decisiontable.title")); //$NON-NLS-1$
		newDecisionTableAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_NEW_DECISIONTABLE));

		newCondtionAction = new Action() {
			public void run() {
				InputDialog dialog = new InputDialog(
						parent.getShell(),
						UIMessages
								.getString("DecisionTableViewPart.new.condition.title"), UIMessages.getString("DecisionTableViewPart.new.condition.description"), "", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						new IInputValidator() {
							public String isValid(String newText) {
								if (newText.length() == 0) {
									return UIMessages
											.getString("DecisionTableViewPart.new.condition.validmessage"); //$NON-NLS-1$
								}
								return null; // OK
							}
						});
				if (dialog.open() == Window.OK) {
					newCondition(tabPage.getSelectedTabName(), dialog
							.getValue());
				}
			}
		};
		newCondtionAction.setText(UIMessages
				.getString("DecisionTableViewPart.new.condition.title")); //$NON-NLS-1$
		newCondtionAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_NEW_DECISIONTABLE_ITEM));

		newActionAction = new Action() {
			public void run() {
				InputDialog dialog = new InputDialog(
						parent.getShell(),
						UIMessages
								.getString("DecisionTableViewPart.new.action.title"), UIMessages.getString("DecisionTableViewPart.new.action.description"), "", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						new IInputValidator() {
							public String isValid(String newText) {
								if (newText.length() == 0) {
									return UIMessages
											.getString("DecisionTableViewPart.new.action.validmessage"); //$NON-NLS-1$
								}
								return null; // OK
							}
						});
				if (dialog.open() == Window.OK) {
					newAction(tabPage.getSelectedTabName(), dialog.getValue());
				}
			}
		};
		newActionAction.setText(UIMessages
				.getString("DecisionTableViewPart.new.action.title")); //$NON-NLS-1$
		newActionAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_NEW_DECISIONTABLE_ITEM));

		newTestMethodAction = new Action() {
			public void run() {
				InputDialog dialog = new InputDialog(
						parent.getShell(),
						UIMessages
								.getString("DecisionTableViewPart.new.testMethod.title"),
						UIMessages
								.getString("DecisionTableViewPart.new.testMethod.description"),
						"", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						new IInputValidator() {
							public String isValid(String newText) {
								if (newText.length() == 0) {
									return UIMessages
											.getString("DecisionTableViewPart.new.testMethod.validmessage"); //$NON-NLS-1$
								}
								return null; // OK
							}
						});
				if (dialog.open() == Window.OK) {
					newTestMethod(tabPage.getSelectedTabName(), dialog
							.getValue());
				}
			}
		};
		newTestMethodAction.setText(UIMessages
				.getString("DecisionTableViewPart.new.testMethod.title")); //$NON-NLS-1$
		newTestMethodAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_NEW_TESTMETHOD_ITEM));

		exportAction = new Action() {
			public void run() {
				new HtmlExporter(
						parent.getShell(),
						UIMessages
								.getString("DecisionTableViewPart.export.decisiontable.title"),
						tabPage.getDecisionTableModels()).export();
			}
		};
		exportAction.setText(UIMessages
				.getString("DecisionTableViewPart.export.decisiontable.title"));
		exportAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_EXPORT_DECISIONTABLE));

		refreshAction = new Action() {
			public void run() {
				initialize(JDTUtils.getICompilationUnit());
			}
		};
		refreshAction.setText(UIMessages
				.getString("DecisionTableViewPart.refresh.title"));
		refreshAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_REFRESH));

		syncAction = new Action(UIMessages
				.getString("DecisionTableViewPart.sync.title"),
				Action.AS_CHECK_BOX) {
			public void run() {
				if (isChecked()) {
					PreferenceUtils.setBoolean(
							PreferenceConstants.IS_LINK_WITH_EDITOR, true);
				} else {
					PreferenceUtils.setBoolean(
							PreferenceConstants.IS_LINK_WITH_EDITOR, false);
				}
			}
		};
		if (PreferenceUtils.getBoolean(PreferenceConstants.IS_LINK_WITH_EDITOR)) {
			syncAction.setChecked(true);
		}
		syncAction.setImageDescriptor(JUnitDocPlugin
				.getImageDescriptor(JUnitDocPlugin.IMG_SYNCED));

		doubleClickAction = new Action() {
			public void run() {
				CTabItem selection = tabPage.getControl().getSelection();
				JUnitDocPlugin.debugLog(selection);
				// Object obj = ((IStructuredSelection) selection)
				// .getFirstElement();
				showMessage(UIMessages.getString("DecisionTableViewPart.23") + selection); //$NON-NLS-1$
			}
		};
	}

	//
	// private void hookDoubleClickAction() {
	// viewer.addDoubleClickListener(new IDoubleClickListener() {
	// public void doubleClick(DoubleClickEvent event) {
	// doubleClickAction.run();
	// }
	// });
	// }

	private void showMessage(String message) {
		MessageDialog.openInformation(tabPage.getControl().getShell(),
				UIMessages.getString("DecisionTableViewPart.24"), message); //$NON-NLS-1$
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		// tabPage.getControl().setFocus();
	}
}