/*
 * Decompiled with CFR 0.152.
 */
package junkutil.excel;

import java.util.ArrayList;
import java.util.zip.DataFormatException;

public class CSV {
    public static final int MOST_QUOTE = 1;
    public static final int ANY_QUOTE = 2;
    public static final int NO_QUOTE = 3;

    private CSV() {
    }

    public static String stringsToCsv(String[] strings, int mode) {
        return CSV.stringsToCsv(strings, ",", mode);
    }

    public static String stringsToTsv(String[] strings, int mode) {
        return CSV.stringsToCsv(strings, "\t", mode);
    }

    private static String stringsToCsv(String[] strings, String delim, int mode) {
        if (mode < 1 || 3 < mode) {
            throw new IllegalArgumentException("mode=" + mode);
        }
        StringBuffer tempStringBuffer = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            String localCvsSource;
            if (i != 0) {
                tempStringBuffer.append(delim);
            }
            if ((localCvsSource = strings[i]) == null) {
                throw new NullPointerException("cvsSource[" + i + "] is null.");
            }
            tempStringBuffer.append(CSV.toCSV(localCvsSource, mode));
        }
        return new String(tempStringBuffer);
    }

    private static String toCSV(String column, int mode) {
        int idx = column.indexOf(34);
        StringBuffer strBuf = new StringBuffer();
        if (mode == 1 || mode == 2 && idx != -1) {
            strBuf.append("\"");
        }
        for (int i = 0; i < column.length(); ++i) {
            char sourceChar = column.charAt(i);
            if (sourceChar == '\"') {
                strBuf.append("\"\"");
                continue;
            }
            strBuf.append(sourceChar);
        }
        if (mode == 1 || mode == 2 && idx != -1) {
            strBuf.append("\"");
        }
        return new String(strBuf);
    }

    public static String[] csvToStrings(String csvStr) throws DataFormatException {
        return CSV.csvToStrings(csvStr, ',');
    }

    public static String[] tsvToStrings(String csvStr) throws DataFormatException {
        return CSV.csvToStrings(csvStr, '\t');
    }

    private static String[] csvToStrings(String csvStr, char delim) throws DataFormatException {
        int i;
        String[] resultStringArray = null;
        ArrayList<String> columnStringList = new ArrayList<String>();
        int argCSVStringLength = csvStr.length();
        int lastChar = 95;
        for (i = 0; i < argCSVStringLength; ++i) {
            String readedColumnString;
            char localChar = csvStr.charAt(i);
            if (localChar == '\"') {
                if (++i > argCSVStringLength) {
                    throw new DataFormatException();
                }
                readedColumnString = CSV.readUntilDoubleQuote(csvStr, i);
                if (lastChar == 34) {
                    int lastIndex = columnStringList.size() - 1;
                    String lastString = (String)columnStringList.get(lastIndex);
                    columnStringList.set(lastIndex, lastString + "\"" + readedColumnString);
                } else {
                    columnStringList.add(readedColumnString);
                }
                i += readedColumnString.length();
                lastChar = 34;
                continue;
            }
            if (localChar == delim) {
                if (lastChar == 34) {
                    lastChar = delim;
                    continue;
                }
                columnStringList.add("");
                lastChar = 44;
                continue;
            }
            if (i > argCSVStringLength) {
                throw new DataFormatException();
            }
            readedColumnString = CSV.readUntilColon(csvStr, i);
            columnStringList.add(readedColumnString);
            i += readedColumnString.length();
            lastChar = 95;
        }
        resultStringArray = new String[columnStringList.size()];
        for (i = 0; i < columnStringList.size(); ++i) {
            String localColumnString;
            resultStringArray[i] = localColumnString = (String)columnStringList.get(i);
        }
        return resultStringArray;
    }

    private static String readUntilDoubleQuote(String argCSVString, int argStartIndex) throws DataFormatException {
        StringBuffer workStringBuffer = new StringBuffer();
        boolean isFound = false;
        for (int i = argStartIndex; i < argCSVString.length(); ++i) {
            char localChar = argCSVString.charAt(i);
            if (localChar == '\"') {
                isFound = true;
                break;
            }
            workStringBuffer.append(localChar);
        }
        if (!isFound) {
            throw new DataFormatException();
        }
        return new String(workStringBuffer);
    }

    private static String readUntilColon(String argCSVString, int argStartIndex) throws DataFormatException {
        char localChar;
        StringBuffer workStringBuffer = new StringBuffer();
        for (int i = argStartIndex; i < argCSVString.length() && (localChar = argCSVString.charAt(i)) != ','; ++i) {
            workStringBuffer.append(localChar);
        }
        return new String(workStringBuffer);
    }
}

