/*
 * Decompiled with CFR 0.152.
 */
package junkutil.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class FileUtil {
    private static final String ln = System.getProperty("line.separator");

    private FileUtil() {
    }

    public static boolean exists(String filename) {
        return new File(filename).exists();
    }

    public static String readFile(String filename) throws IOException {
        return FileUtil.readFile(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filename, String encoding) throws IOException {
        BufferedReader br = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            br = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            ArrayList<String> temp = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                temp.add(line);
            }
            for (int i = 0; i < temp.size(); ++i) {
                result.append((String)temp.get(i));
                if (i + 1 >= temp.size()) continue;
                result.append(ln);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return new String(result);
    }

    public static List readLines(String filename) throws IOException {
        return FileUtil.readLines(filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List readLines(String filename, String encoding) throws IOException {
        BufferedReader br = null;
        ArrayList<String> result = null;
        try {
            String line;
            br = encoding != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding)) : new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
            result = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception ee) {}
        }
        return result;
    }

    public static void writeLines(String filename, List list) throws IOException {
        FileUtil.writeLines(filename, list, null, false);
    }

    public static void writeLines(String filename, List list, String encoding) throws IOException {
        FileUtil.writeLines(filename, list, encoding, false);
    }

    public static void appendLines(String filename, List list) throws IOException {
        FileUtil.writeLines(filename, list, null, true);
    }

    public static void appendLines(String filename, List list, String encoding) throws IOException {
        FileUtil.writeLines(filename, list, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLines(String filename, List list, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            for (int i = 0; i < list.size(); ++i) {
                String line = (String)list.get(i);
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    public static void writeFile(String filename, String text) throws IOException {
        FileUtil.writeFile(filename, text, null, false);
    }

    public static void writeFile(String filename, String text, String encoding) throws IOException {
        FileUtil.writeFile(filename, text, encoding, false);
    }

    public static void appendFile(String filename, String text) throws IOException {
        FileUtil.writeFile(filename, text, null, true);
    }

    public static void appendFile(String filename, String text, String encoding) throws IOException {
        FileUtil.writeFile(filename, text, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filename, String text, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            bw.write(text);
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    public static void writeLine(String filename, String line) throws IOException {
        FileUtil.writeLine(filename, line, null, false);
    }

    public static void writeLine(String filename, String line, String encoding) throws IOException {
        FileUtil.writeLine(filename, line, encoding, false);
    }

    public static void appendLine(String filename, String line) throws IOException {
        FileUtil.writeLine(filename, line, null, true);
    }

    public static void appendLine(String filename, String line, String encoding) throws IOException {
        FileUtil.writeLine(filename, line, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLine(String filename, String line, String encoding, boolean append) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = encoding != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, append), encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, append)));
            bw.write(line);
            bw.write(ln);
            bw.flush();
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception ee) {}
        }
    }
}

