package junkutil.common;

import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import junkutil.set.LzList;
import junkutil.set.LzMap;

/**
 * NullB
 * @author Hiroyuki Shiota
 */
public class NullUtilTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public NullUtilTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("NullUtilTest");
		test.addTest(new TestSuite(NullUtilTest.class));
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testNvl() throws Exception {
		assertTrue(NullUtil.nvl(null).equals(""));
		assertTrue(NullUtil.nvl("nvl1", "nvl2").equals("nvl1"));
		assertTrue(NullUtil.nvl(null, "nvl2").equals("nvl2"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testNvlObject() throws Exception {
		assertTrue(NullUtil.nvlObject(new LzList(new String[]{"1","2","3"})).equals("[1, 2, 3]"));
		assertTrue(NullUtil.nvlObject(new LzList(new String[]{"1","2","3"}), null).toString().equals("[1, 2, 3]"));
		assertTrue(NullUtil.nvlObject(null, new LzList(new String[]{"4","5","6"})).toString().equals("[4, 5, 6]"));
		assertTrue(NullUtil.nvlObject(new LzList(new String[]{"1","2","3"}), new LzList(new String[]{"4","5","6"})).toString().equals("[1, 2, 3]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testNvlNull() throws Exception {
		assertTrue(NullUtil.nvlNull(null).equals("null"));
	}

	/**
	 * @throws Exception
	 */
	public void testNvlList() throws Exception {
		List list1 = NullUtil.nvlList(new LzList(new String[]{"1","2","3"}).list(), null);
		assertTrue(list1.toString().equals("[1, 2, 3]"));
		List list2 = NullUtil.nvlList(null, new LzList(new String[]{"1","2","3"}).list());
		assertTrue(list2.toString().equals("[1, 2, 3]"));
	}
	
	/**
	 * @throws Exception
	 */
	public void testNvlMap() throws Exception {
		Map map1 = NullUtil.nvlMap(new LzMap(new String[]{"a","1","b", "2"}).map(), null);
		assertTrue(new LzMap(map1).toString().equals("{a=1, b=2}"));
		Map map2 = NullUtil.nvlMap(null, new LzMap(new String[]{"a","1","b", "2"}).map());
		assertTrue(new LzMap(map2).toString().equals("{a=1, b=2}"));
	}
}
