/*
 * Decompiled with CFR 0.152.
 */
package junkutil.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class LzFixedTextField
extends JTextField {
    private int maxLength = -1;

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int arg) {
        this.maxLength = arg;
    }

    public LzFixedTextField(int cols) {
        super(cols);
    }

    public LzFixedTextField(int cols, int maxLength) {
        super(cols);
        this.maxLength = maxLength;
    }

    @Override
    protected Document createDefaultModel() {
        return new LzFixedTextDocument();
    }

    private class LzFixedTextDocument
    extends PlainDocument {
        private LzFixedTextDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (LzFixedTextField.this.maxLength != -1 && LzFixedTextField.this.maxLength < this.getLength() + str.length()) {
                str = str.substring(0, LzFixedTextField.this.maxLength - this.getLength());
            }
            super.insertString(offs, str, a);
        }
    }
}

