package junkutil.crypt;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * ʌÍ/ASYB
 * DES,gvDES,AES,RC2,RC4ɑΉ
 * @author Hiroyuki Shiota
 */
public class DES {
	public static final String DES = "DES";
	public static final String DESEDE = "DESede";
	public static final String AES = "AES";
	public static final String BLOWFISH = "Blowfish";
	public static final String RC2 = "RC2";
	public static final String RC4 = "RC4";

	/**
	 * ftHg̃ASY
	 */
	private DES() {
	}

	/**
	 * BASE64ŃGR[h
	 * @param bytes
	 * @return
	 */
	public static String encodeBASE64(byte[] bytes) {
		return BASE64.encodeBytes(bytes);
	}

	/**
	 * BASE64ŃfR[h
	 * @param value
	 * @return
	 * @throws IOException
	 */
	public static byte[] decodeBASE64(String value) throws IOException {
		return BASE64.decode(value);
	}

	/**
	 * L[i_j
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws IOException
	 */
	public static String createKey(String algorithm) throws NoSuchAlgorithmException, IOException {
		return createKey(algorithm, null);
	}

	/**
	 * L[iwj
	 * @param seed
	 * @return
	 * @throws NoSuchAlgorithmException
	 * @throws IOException
	 */
	public static String createKey(String algorithm, String seed) throws NoSuchAlgorithmException, IOException {
		SecureRandom secureRandom = null;
		if (seed != null) {
			secureRandom = new SecureRandom(decodeBASE64(seed));
		} else {
			secureRandom = new SecureRandom();
		}
		KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
		keyGenerator.init(secureRandom);
		SecretKey secretKey = keyGenerator.generateKey();
		return encodeBASE64(secretKey.getEncoded());
	}

	/**
	 * L[̎擾B
	 * @param key
	 */
	private static Key asKey(String algorithm, byte[] key) {
		SecretKey secretKey = new SecretKeySpec(key, algorithm);
		return secretKey;
	}

	/**
	 * ÍB
	 * @param data
	 * @param key
	 * @return
	 * @throws IOException
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchPaddingException
	 * @throws InvalidKeyException
	 * @throws IllegalBlockSizeException
	 * @throws BadPaddingException
	 */
	public static byte[] encrypt(String algorithm, byte[] data, String key) throws IOException, NoSuchAlgorithmException,
			NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
		Key secretKey = asKey(algorithm, decodeBASE64(key));
		Cipher cipher = Cipher.getInstance(algorithm);
		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		return cipher.doFinal(data);
	}

	/**
	 * B
	 * @param data
	 * @param key
	 * @return
	 * @throws IOException
	 * @throws NoSuchAlgorithmException
	 * @throws NoSuchPaddingException
	 * @throws InvalidKeyException
	 * @throws IllegalBlockSizeException
	 * @throws BadPaddingException
	 */
	public static byte[] decrypt(String algorithm, byte[] data, String key) throws IOException, NoSuchAlgorithmException,
			NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
		Key secretKey = asKey(algorithm, decodeBASE64(key));
		Cipher cipher = Cipher.getInstance(algorithm);
		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		return cipher.doFinal(data);
	}

}
