/*
 * Decompiled with CFR 0.152.
 */
package org.stormcat.commons.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.stormcat.commons.exception.IllegalAccessRuntimeException;
import org.stormcat.commons.exception.NoSuchFieldRuntimeException;
import org.stormcat.commons.reflect.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldUtil {
    protected FieldUtil() {
    }

    public static Field getField(String fieldName, Class<?> target) {
        try {
            return target.getField(fieldName);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(e);
        }
    }

    public static Object getValue(Field field, Object obj) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(e);
        }
    }

    public static Method getGetterMethod(Field field) {
        String fieldName = field.getName();
        StringBuilder builder = new StringBuilder("get");
        builder.append(fieldName.substring(0, 1).toUpperCase());
        builder.append(fieldName.subSequence(1, fieldName.length()));
        return MethodUtil.getDeclareMethod(field.getDeclaringClass(), builder.toString(), new Class[0]);
    }

    public static Method getSetterMethod(Field field) {
        String fieldName = field.getName();
        StringBuilder builder = new StringBuilder("set");
        builder.append(fieldName.substring(0, 1).toUpperCase());
        builder.append(fieldName.subSequence(1, fieldName.length()));
        return MethodUtil.getDeclareMethod(field.getDeclaringClass(), builder.toString(), field.getType());
    }
}

