#include "stdafx.h"

#include "ConfigParser.hpp"
#include <fstream>

ConfigParser::ConfigParser()
{
}

ConfigParser::~ConfigParser()
{
}

void ConfigParser::parse( const std::string& v_fileName )
{
	std::ifstream fin;
	fin.open( v_fileName.c_str() );
	if( ! fin.is_open() ) {
		throw std::runtime_error( "ݒt@CJ܂B" );
	}
	std::string line;
	while( getline( fin, line ) ) {
		char firstChar = 0;
		for( std::string::const_iterator p=line.begin(), last=line.end();
			p != last;
			++p)
		{
			if( *p == '#' || *p == ';' ) {
				break;
			}
			if( ! ( *p >= 0 && *p <= ' ' ) ) {
				firstChar = *p;
				break;
			}
		}
		if( firstChar == 0 ) {
			continue;
		}

		if( firstChar == '-' ) {
			parseJVMOption( line );
		}
		else {
			parseMethodOption( line );
		}
	}
	fin.close();
}

const JavaVMStartupInfo& ConfigParser::getJavaVMStartupInfo() const
{
	return jvmStartupInfo_;
}

ConfigParser::iterator ConfigParser::begin()
{
	return methods_.begin();
}

ConfigParser::const_iterator ConfigParser::begin() const
{
	return methods_.begin();
}

ConfigParser::iterator ConfigParser::end()
{
	return methods_.end();
}

ConfigParser::const_iterator ConfigParser::end() const
{
	return methods_.end();
}

ConfigParser::size_type ConfigParser::size() const
{
	return methods_.size();
}

void ConfigParser::parseJVMOption( const std::string v_line )
{
	jvmStartupInfo_.push_back( v_line );
}

void ConfigParser::parseMethodOption( const std::string v_line )
{
	std::string className;
	std::string methodName;
	
	const char *p = v_line.c_str();
	while(*p > 0 && *p <= ' ' ) {
		p++;
	}
	bool bFork = false;
	if( *p == '&' ) {
		bFork = true;
		p++;
	}

	while(*p) {
		if( *p == '#' || ( *p > 0 && *p <= ' ' ) ) {
			break;
		}
		className += *p;
		p++;
	}

	if( *p == '#' ) {
		p++;
		while(*p) {
			if( *p > 0 && *p <= ' ' ) {
				break;
			}
			methodName += *p;
			p++;
		}
	}
	else {
		methodName = "main";
	}

	if( ! className.empty() && ! methodName.empty() ) {
		StartupInfo startupInfo( className, methodName, bFork );
		std::string arg;
		enum escape_mode {
			escape_mode_init = 0,
			escape_mode_normal = 1,
			escape_mode_escape = 2,
			escape_mode_cancel = 3
		} mode = escape_mode_init;
		while(*p) {
			const char c = *p;
			if( mode == escape_mode_init ) {
				if( c == '\"' ) {
					arg.clear();
					mode = escape_mode_escape;
				}
				else if( c > 0 && c <= ' ' ) {
					// do nothing.
				}
				else {
					mode = escape_mode_normal;
					arg.clear();
					arg += c;
				}
			}
			else if( mode == escape_mode_normal ) {
				if( c > 0 && c <= ' ' ) {
					if( ! arg.empty() ) {
						startupInfo.push_back( arg );
					}
					mode = escape_mode_init;
				}
				else {
					arg += c;
				}
			}
			else if( mode == escape_mode_escape ) {
				if( c == '\"' ) {
					mode = escape_mode_cancel;
				}
				else {
					arg += c;
				}
			}
			else if( mode == escape_mode_cancel ) {
				if( c == '\"' ) {
					mode = escape_mode_escape;
					arg += c;
				}
				else {
					mode = escape_mode_normal;
					continue;
				}
			}
			p++;
		}
		if( ! arg.empty() ) {
			startupInfo.push_back( arg );
		}

		methods_.push_back( startupInfo );
	}
}
