#include "stdafx.h"

#include "ExceptionFilter.hpp"

#include "message.h"

#include <assert.h>

namespace
{
	const EventLog* pEventLog_ = NULL;

	LONG ExceptionFilter( EXCEPTION_POINTERS* v_pExceptionInfo )
	{
		if( pEventLog_ != NULL ) {
			pEventLog_->reportEvent(
				MSG_UNHANDLED_EXCEPTION,
				0,
				NULL,
				EVENTLOG_ERROR_TYPE
				);
		}
		return EXCEPTION_EXECUTE_HANDLER;
	}
}

void UnhandledExceptionHandler::setUnhandledExceptionHandler() throw()
{
	SetUnhandledExceptionFilter( (LPTOP_LEVEL_EXCEPTION_FILTER) ExceptionFilter );
}

void UnhandledExceptionHandler::setEventLog( const EventLog* v_pEventLog ) throw()
{
	//required:
	assert( pEventLog_ == NULL && "łɃCxgOo^Ă܂B" );
	
	//do:
	pEventLog_ = v_pEventLog;
}

