//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_SYSTEM                  0x0
#define FACILITY_STUBS                   0x3
#define FACILITY_RUNTIME                 0x2
#define FACILITY_IO_ERROR_CODE           0x4


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: MSG_JAVAVM_STARTED
//
// MessageText:
//
//  JavaVM created.
//
#define MSG_JAVAVM_STARTED               ((DWORD)0x00020001L)

//
// MessageId: MSG_JAVAVM_EXITED
//
// MessageText:
//
//  JavaVM exited.(exit code=%1)
//
#define MSG_JAVAVM_EXITED                ((DWORD)0x40020002L)

//
// MessageId: MSG_JAVAVM_ABORTED
//
// MessageText:
//
//  JavaVM was aborted.
//
#define MSG_JAVAVM_ABORTED               ((DWORD)0xC0020003L)

//
// MessageId: MSG_JAVAVM_EXCEPTION
//
// MessageText:
//
//  occure exception: %1
//
#define MSG_JAVAVM_EXCEPTION             ((DWORD)0xC0020004L)

//
// MessageId: MSG_UNHANDLED_EXCEPTION
//
// MessageText:
//
//  occur unhandled exception.
//
#define MSG_UNHANDLED_EXCEPTION          ((DWORD)0xC0000004L)

//
// MessageId: MSG_PRELOADLIB_FAILURE
//
// MessageText:
//
//  library load failure: %1
//
#define MSG_PRELOADLIB_FAILURE           ((DWORD)0xC0000005L)

