// $Id: BS2SecsAtom.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2SecsAtom.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "BS2DeclAtoms.h"
#include "BS2Array.h"
#include "BS2SecsFuncs.h"

#include "tcl.h"
extern Tcl_Encoding _encoding_sjis;
extern Tcl_Encoding _encoding_iso2022jp;

#undef INIT_FUNCTION
#define INIT_FUNCTION(p)

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_binary(int bin)
{
    INIT_FUNCTION("make_atom_binary");
    BS2Binary * atom;
    if (bin >= 0 && bin < 256)
        atom = new BS2Binary((BYTE)bin);
    else
        atom = NULL;
    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_add_binary(Atom * atomptr, Atom * bin)
{
    INIT_FUNCTION("make_add_binary");

    BS2Binary * atom = (BS2Binary *)atomptr;
    BS2Binary * nextAtom = (BS2Binary *)bin;
    atom->add(nextAtom);
    delete nextAtom;
    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_boolean(int i)
{
    INIT_FUNCTION("make_atom_boolean");
    BS2Boolean * atom = new BS2Boolean((i != 0) ? true : false);

    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_integer(int i)
{
    INIT_FUNCTION("make_atom_integer");
    BS2Int4 * atom = new BS2Int4(i);

    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_int1(int i)
{
    INIT_FUNCTION("make_atom_int1");
    if (i >= -128 && i < 128)
    {
       BS2Int1 * i_atom = new BS2Int1((char)i);
       return (Atom *)i_atom;
    }
    else
         return (Atom *)NULL;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_int2(int i)
{
    INIT_FUNCTION("make_atom_int2");
    if (i >= -32768 && i < 32767)
    {
        BS2Int2 * i_atom = new BS2Int2((short)i);
        return (Atom *)i_atom;
    }
    else
        return (Atom *)NULL;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_uint4(int i)
{
    INIT_FUNCTION("make_atom_uint4");
    BS2UInt4 * ui_atom = new BS2UInt4((ULONG)i);
    return (Atom *)ui_atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_uint1(int i)
{
    INIT_FUNCTION("make_atom_uint1");
    if (i >= 0 && i < 256)
    {
         BS2UInt1 * ui_atom = new BS2UInt1((BYTE)i);
         return (Atom *)ui_atom;
    }
    else
         return (Atom *)NULL;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_uint2(int i)
{
    INIT_FUNCTION("make_atom_uint2");
    if (i >= 0 && i < 0x10000)
    {
         BS2UInt2 * ui_atom = new BS2UInt2((USHORT)i);
         return (Atom *)ui_atom;
    }
    else
         return (Atom *)NULL;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_int8(LONGLONG i64)
{
    INIT_FUNCTION("make_atom_int8");

    BS2Int8 * i_atom = new BS2Int8(i64);
    return (Atom *)i_atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_uint8(ULONGLONG ui64)
{
    INIT_FUNCTION("make_atom_uint8");

    BS2UInt8 * ui_atom = new BS2UInt8(ui64);
    return (Atom *)ui_atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_string(char * str)
{
    INIT_FUNCTION("make_atom_string");
    BS2Ascii * atom = new BS2Ascii((const TCHAR *)str);
    free(str);
    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_jstring(char * str)
{
    INIT_FUNCTION("make_atom_jstring");
    BS2Jis * atom;
    Tcl_DString iso2022Buf;
    char * jptr;
    int  len;

    // convert UTF-8 to iso2022-jp
    Tcl_DStringInit(&iso2022Buf);
    len = strlen(str);
    Tcl_UtfToExternalDString(_encoding_iso2022jp, str, len, &iso2022Buf);
    jptr = Tcl_DStringValue(&iso2022Buf);
    atom = new BS2Jis((const TCHAR *)jptr);
    Tcl_DStringFree(&iso2022Buf);

    free(str);
    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_sjis_string(char * str)
{
    INIT_FUNCTION("make_atom_sjis_string");
    BS2Ascii * atom;
    Tcl_DString sjisBuf;
    char * jptr;
    int  len;

    // convert UTF-8 to siftjis
    Tcl_DStringInit(&sjisBuf);
    len = strlen(str);
    Tcl_UtfToExternalDString(_encoding_sjis, str, len, &sjisBuf);
    jptr = Tcl_DStringValue(&sjisBuf);
    atom = new BS2Ascii((const TCHAR *)jptr);
    Tcl_DStringFree(&sjisBuf);
    free(str);
    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_list(Atom * listptr, Atom * memberAtom)
{
    INIT_FUNCTION("make_atom_list");
    BS2List * aList;
    if (listptr == NULL)
        aList = new BS2List;
    else
        aList = (BS2List *)listptr;

    if (memberAtom != NULL)
    {
        BS2Atom * atom = (BS2Atom *)memberAtom;
        aList->add(*atom);
    }
    return (Atom *)aList;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_real(double r)
{
    INIT_FUNCTION("make_atom_real");
    BS2Float8 * atom = new BS2Float8(r);

    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_float(float f)
{
    INIT_FUNCTION("make_atom_float");
    BS2Float4 * atom = new BS2Float4(f);

    return (Atom *)atom;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_int_array(Atom * arrayptr, int element)
{
    INIT_FUNCTION("make_int_array");
    BS2Int4Array * i4Array;
    if (arrayptr == NULL)
        i4Array = new BS2Int4Array;
    else
        i4Array = (BS2Int4Array *)arrayptr;

    i4Array->add(element);
    return (Atom *)i4Array;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_uint_array(Atom * arrayptr, int element)
{
    INIT_FUNCTION("make_uint_array");
    BS2UInt4Array * ui4Array;
    if (arrayptr == NULL)
        ui4Array = new BS2UInt4Array;
    else
        ui4Array = (BS2UInt4Array *)arrayptr;

    ui4Array->add(element);
    return (Atom *)ui4Array;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_uint_array(Atom * arrayptr, UINT element)
{
    INIT_FUNCTION("make_uint_array");
    BS2UInt4Array * ui4Array;
    if (arrayptr == NULL)
        ui4Array = new BS2UInt4Array;
    else
        ui4Array = (BS2UInt4Array *)arrayptr;

    ui4Array->add(element);
    return (Atom *)ui4Array;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Atom * make_atom_unicode(wchar_t *)
{
    INIT_FUNCTION("make_atom_unicode");
    return (Atom *)NULL;
}


//
// *** End of File ***
