// $Id: BS2SecsFuncs.h,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2SecsFuncs.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BS2SECSFUNCS_H
#define BS2SECSFUNCS_H

#include "beelib.h"

#define Item     void
#define Atom     void
#define Message  void
#define myHeader void
#define Buffer   void

#ifdef __cplusplus
extern "C" {
#endif

/*---------------------------------------------------------------------------*/
typedef struct MessageFormatInfo
{
    Message * m_msg;
    void * m_topNode;
    void * m_curNode;
    void * m_beforeNode;
} MessageFormatInfo;

/*---------------------------------------------------------------------------*/

extern void make_secs2_buffer(myHeader * head, Message * msg);
extern myHeader * make_header(unsigned int trnum , int wbit);

extern int getMessageFormat(MessageFormatInfo * msginfo, char * sfnum);

/*---------------------------------------------------------------------------*/
/* M E S S A G E                                                             */
/*---------------------------------------------------------------------------*/
extern Message * func_sxxfxx(MessageFormatInfo * msginfo);
extern Message * func_sxxfxx_top(MessageFormatInfo * msginfo, Item * items);
extern Message * func_sxxfxx_toplist(MessageFormatInfo * msginfo, Item * items);
extern Message * func_nobody(UINT sfnum);
extern Message * func_listitem(UINT sfnum, Item * listitem);
extern Message * func_item1(UINT sfnum, Item * item);
extern Message * func_item2(UINT sfnum, Item * item1, Item * item2);
extern Message * func_item3(UINT sfnum, Item * item1, Item * item2,
                                   Item * item3);
extern Message * func_item4(UINT sfnum, Item * item1, Item * item2,
                                   Item * item3, Item * item4);
extern Message * func_item5(UINT sfnum, Item * item1, Item * item2,
                                   Item * item3, Item * item4, Item * item5);
extern Message * func_il(UINT sfnum, Item * item, Item * listitem);
extern Message * func_iil(UINT sfnum, Item * item1, Item * item2,
                          Item * listitem);
extern Message * func_iiil(UINT sfnum, Item * item1, Item * item2, Item * item3,
                           Item * listitem);
extern Message * func_iiiil(UINT sfnum, Item * item1, Item * item2, Item * item3,
                           Item * item4, Item * listitem);
extern Message * func_ill(UINT sfnum, Item * item, Item * list1, Item * list2);
extern Message * func_li(UINT sfnum, Item * listitem, Item * item);
extern Message * func_ll(UINT sfnum, Item * listitem1, Item * listitem2);

extern Message * func_s1f0(void);
extern Message * func_s1f2(Item * mdln, Item * softrev);
extern Message * func_s1f6(Item * val);         /* ??? */
extern Message * func_s1f8(Item * val);         /* ??? */
extern Message * func_s1f10(Item * tsip_list, Item * tsop_list);  /* ??? */
extern Message * func_s1f13(Item * mdln, Item * softrev);
extern Message * func_s1f14(Item * commack, Item * mdln, Item * softrev);
extern Message * func_s1f19(Item * objtype, Item * objid_list,
                            Item * attrid_list);
extern Message * func_s1f20(Item * attrdata_list, Item * error_list);
extern Message * func_s2f27(Item * loc, Item * ppid, Item * mid_list);
extern Message * func_s4f19(Item * dataid, Item * trjobname, Item * trjob_decl);
extern Message * func_s4f20(Item * trjobid, Item * tratomic_decl,
                            Item * tr_result);
extern Message * func_s4f27(Item * eqname, Item * trlink, Item * trport,
                            Item * trobjname, Item * trobjtype, Item * trrole,
                            Item * trptnr, Item * trptport, Item * trdir,
                            Item * trtype, Item * trlocation);
extern Message * func_s5f5(Item * alid);
extern Message * func_s6f1(Item * trid, Item * smpln, Item * stime,
                           Item * sv_list);
extern Message * func_s6f3(Item * dataid, Item * ceid, Item * senddata_list);
extern Message * func_s6f25(Item * dataid, Item * opid, Item * linkid,
                            Item * rcpspec, Item * rmchgstat,
                            Item * rcpattr_list, Item * rmack_list);
extern Message * func_s6f30(Item * trid, Item * rpt_list, Item * errcode);
extern Message * func_s7f36(Item * mid, Item * ppid, Item * ppbody);
extern Message * func_s8f2(Item * bpd);
extern Message * func_s8f4(Item * epd);
extern Message * func_s12f1(Item * mid, Item * idtyp, Item * fnloc,
                            Item * ffrot, Item * orloc, Item * rpsel,
                            Item * refp_decl, Item * dutms, Item * xdies,
                            Item * ydies, Item * rowct, Item * colct,
                            Item * nulbc, Item * prdct, Item * praxi);
extern Message * func_s12f3(Item * mid, Item * idtyp, Item * mapft,
                            Item * fnloc, Item * ffrot, Item * orloc,
                            Item * praxi, Item * bcequ, Item * nulbc);
extern Message * func_s12f4(Item * mid, Item * idtyp, Item * fnloc,
                            Item * orloc, Item * rpsel, Item * refp_decl,
                            Item * dutms, Item * xdies, Item * ydies,
                            Item * rowct, Item * colct, Item * prdct,
                            Item * bcequ, Item * nulbc, Item * mlcl);
extern Message * func_s13f13(Item * dataid, Item * objspec, Item * tbltyp, Item * tblid,
                             Item * tblcmd, Item * property_list, Item * colhdr_list,
                             Item * table_element_list);
extern Message * func_s13f15(Item * dataid, Item * objspec, Item * tbltyp, Item * tblid,
                             Item * tblcmd, Item * colhdr_list, Item * tblelt_list);
extern Message * func_s13f16(Item * tbltyp, Item * tblid, Item * property_list, Item * colhdr_list,
                             Item * table_element_list, Item * tblack_list);
extern Message * func_s14f1(Item * objspec, Item * objtype, Item * objid_list,
                            Item * attr_decl, Item * attrid_list_decl);
extern Message * func_s14f3(Item * objspec, Item * objtype,
                            Item * objid_list, Item * property_list);
extern Message * func_s14f5(Item * objspec);
extern Message * func_s15f13(Item * dataid, Item * rcpupdt, Item * rcpspec,
                             Item * rcpattr_list, Item * rcpbody);
extern Message * func_s15f21(Item * dataid, Item * rcpcmd, Item * rmnsspec,
                             Item * opid, Item * agent, Item * rcpid_list);
extern Message * func_s15f27(Item * dataid, Item * rcpowcode, Item * rcpspec,
                             Item * rcpattr_list, Item* rcpbody);
extern Message * func_s15f37(Item * rmsegspec, Item * objtoken, Item * rmgrnt,
                             Item * opid, Item * rcpid, Item * rmchgtype);
extern Message * func_s16f11(Item * dataid, Item * prjobid, Item * carrier_mf,
                             Item * carslot_list, Item * proc_recipe,
                             Item * prprocessstart, Item * prpauseevent);
extern Message * func_s16f13(Item * dataid, Item * prjob_list, Item * proc_recipe,
                             Item * prprocessstart, Item * prpauseevent);
extern Message * func_s17f5(Item * dataid, Item * trid, Item * ceed,
                            Item * rptid_list, Item * trsper,
                            Item * trace_decl);


/*---------------------------------------------------------------------------*/
/* I T E M - L I S T                                                         */
/*---------------------------------------------------------------------------*/
extern Item * make_item_list(Item * aList, Item * item);
extern Item * make_alid_array(Item * anArray, Item * item);
extern Item * make_item(char * iname, Atom * atom);
extern Item * make_rsinf_xyd(int rsinfx, int rsinfy, int rsinfd);
extern Item * make_xy_point(unsigned char refp_x, unsigned char refp_y);
extern Item * make_xypos(int xops, int ypos);
extern Item * make_xypos_ll(LONGLONG xops, LONGLONG ypos);
extern Item * make_cepack_list(Atom * name, Atom * val);
extern Item * make_cepval_list(Atom * name, Atom * val);

/*----------------------------------------------------------------------------*/
extern Item * mklist_2items(Item * item1, Item * item2);
extern Item * mklist_3items(Item * item1, Item * item2, Item * item3);
extern Item * mklist_item_itemlist(Item * item, Item * i_list);
extern Item * make_equipment_info(Item * ecid, Item * ecname, Item * ecmin,
                                  Item *  ecmax, Item * ecdef, Item * units);
extern Item * make_limit_ack(Item * vid, Item * lvack, Item * limitid,
                             Item * limitack);
extern Item * make_limit_data(Item * limitid, Item * upperdb, Item * lowerdb);
extern Item * make_parameter(Item * pname, Item * rqpar, Item * pdflt,
                             Item * pmax, Item * llim, Item * ulim,
                             Item * units, Item * resc, Item * resv);
extern Item * make_proc_prog(Item * ccode, Item * cname, Item * rqcmd,
                             Item * blkdef, Item * bcds, Item * ibcds,
                             Item * nbcds, Item * acds, Item * iacds,
                             Item * nacds, Item * parameter_data);
extern Item * make_recipe_info(Item * rcpsec1, Item * rcpbody, Item * rcpsec2);
extern Item * make_recipe_section(Item * name, Item * rcpattr);
extern Item * make_recipe_descriptor(Item * rcpdescnm, Item * rcpdesctime,
                                     Item * rcpdesclth);
extern Item * make_rec_info(Item * rcpid, Item * rcpnewid, Item * rmsegspec,
                     Item * rmchgtype, Item * opid, Item * timestamp,
                     Item * rmrequestor);
extern Item * make_stream_ack(Item * strid, Item * strack, Item * fcnid_list);
extern Item * make_trace_decl(Item * totsmp, Item * repgsz, Item * start_evtsrc,
                              Item * start_ceid, Item * stop_evtsrc,
                              Item * stop_ceid, Item * trautod, Item * rptoc);
extern Item * make_trjob(Item * trlink, Item * trport, Item * trobjname,
                         Item * trobjtype, Item * trrole, Item * trrcp,
                         Item * trptnr, Item * trptport, Item * trdir,
                         Item * trtype, Item * trlocation, Item * trautostart);
extern Item * make_var_limit(Item * vid, Item * units, Item * limitmin,
                             Item * limitmax, Item * limit_decl);
extern Item * make_prjob(Item * prjobid, Item * carrier_mf, Item * carslot_list,
                         Item * proc_recipe, Item * prprocessstart,
                         Item * prpauseevent);

/*---------------------------------------------------------------------------*/
/* A T O M                                                                   */
/*---------------------------------------------------------------------------*/
extern Atom * make_atom_binary(int bin);
extern Atom * make_add_binary(Atom * atom, Atom * addAtom);
extern Atom * make_atom_boolean(int i);
extern Atom * make_atom_integer(int i);
extern Atom * make_atom_int1(int i);
extern Atom * make_atom_int2(int i);
extern Atom * make_atom_uint4(int i);
extern Atom * make_atom_uint1(int i);
extern Atom * make_atom_uint2(int i);
extern Atom * make_atom_int8(LONGLONG i64);
extern Atom * make_atom_uint8(ULONGLONG ui64);
extern Atom * make_atom_string(char * str);
extern Atom * make_atom_jstring(char * str);
extern Atom * make_atom_sjis_string(char * str);
extern Atom * make_atom_list(Atom * aList, Atom * atom);
extern Atom * make_atom_real(double r);
extern Atom * make_atom_float(float f);
extern Atom * make_int_array(Atom * array, int element);
extern Atom * make_uint_array(Atom * array, int element);

/*-- secs 98 ----------------------------------------------------------------*/
extern Atom * make_atom_unicode(wchar_t * str);

#ifdef __cplusplus
}
#endif

#endif  /* BS2SECSFUNCS_H */
