// $Id: BS2SecsItemList.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2SecsItemList.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "BS2ListItem.h"
#include "BS2SecsFuncs.h"

#undef INIT_FUNCTION
#define INIT_FUNCTION(p)

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * mklist_2items(Item * item1, Item * item2)
{
    INIT_FUNCTION("make_alarm_data");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)item1);
    listItem->add((BS2Item *)item2);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * mklist_3items(Item * item1, Item * item2, Item * item3)
{
    INIT_FUNCTION("make_alarm_data");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)item1);
    listItem->add((BS2Item *)item2);
    listItem->add((BS2Item *)item3);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * mklist_item_itemlist(Item * item, Item * i_list)
{
    INIT_FUNCTION("make_event_data");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)item);
    if (i_list != NULL)
        listItem->add((BS2Item *)i_list);
    else
    {
        BS2ListItem * _empty_list  = new BS2ListItem;
        listItem->add((BS2Item *)_empty_list);
    }
    return (Item *)listItem;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_equipment_info(Item * ecid, Item * ecname, Item * ecmin,
                           Item * ecmax, Item * ecdef, Item * units)
{
    INIT_FUNCTION("make_equipment_info");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)ecid);
    listItem->add((BS2Item *)ecname);
    listItem->add((BS2Item *)ecmin);
    listItem->add((BS2Item *)ecmax);
    listItem->add((BS2Item *)ecdef);
    listItem->add((BS2Item *)units);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_limit_ack(Item * vid, Item * lvack, Item * limitid,
                      Item * limitack)
{
    INIT_FUNCTION("make_limit_ack");
    BS2ListItem * listItem  = new BS2ListItem;
    BS2ListItem * listAck = new BS2ListItem;
    listItem->add((BS2Item *)vid);
    listItem->add((BS2Item *)lvack);
    listItem->add((BS2Item *)listAck);
    if (limitid != NULL && limitack != NULL)
    {
        listAck->add((BS2Item *)limitid);
        listAck->add((BS2Item *)limitack);
    }
    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_limit_data(Item * limitid, Item * upperdb, Item * lowerdb)
{
    INIT_FUNCTION("make_limit_data");
    BS2ListItem * list1Item  = new BS2ListItem;
    BS2ListItem * list2Item  = new BS2ListItem;
    if (upperdb != NULL && lowerdb != NULL)
    {
        list2Item->add((BS2Item *)upperdb);
        list2Item->add((BS2Item *)lowerdb);
    }
    list1Item->add((BS2Item *)limitid);
    list1Item->add((BS2Item *)list2Item);

    return (Item *)list1Item;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_parameter(Item * pname, Item * rqpar, Item * pdflt, Item * pmax,
                      Item * llim, Item * ulim, Item * units, Item * resc,
                      Item * resv)
{
    INIT_FUNCTION("make_parameter");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)pname);
    listItem->add((BS2Item *)rqpar);
    listItem->add((BS2Item *)pdflt);
    listItem->add((BS2Item *)pmax);
    listItem->add((BS2Item *)llim);
    listItem->add((BS2Item *)ulim);
    listItem->add((BS2Item *)units);
    listItem->add((BS2Item *)resc);
    listItem->add((BS2Item *)resv);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_proc_prog(Item * ccode, Item * cname, Item * rqcmd, Item * blkdef,
                      Item * bcds, Item * ibcds, Item * nbcds, Item * acds,
                      Item * iacds, Item * nacds, Item * parameter_data)
{
    INIT_FUNCTION("make_proc_prog");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)ccode);
    listItem->add((BS2Item *)cname);
    listItem->add((BS2Item *)rqcmd);
    listItem->add((BS2Item *)blkdef);
    listItem->add((BS2Item *)bcds);
    listItem->add((BS2Item *)ibcds);
    listItem->add((BS2Item *)nbcds);
    listItem->add((BS2Item *)acds);
    listItem->add((BS2Item *)iacds);
    listItem->add((BS2Item *)nacds);
    listItem->add((BS2Item *)parameter_data);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_stream_ack(Item * strid, Item * strack, Item * fcnid_list)
{
    INIT_FUNCTION("make_stream_ack");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)strid);
    listItem->add((BS2Item *)strack);
    if (fcnid_list != NULL)
        listItem->add((BS2Item *)fcnid_list);
    else
    {
        BS2ListItem * _empty_list  = new BS2ListItem;
        listItem->add((BS2Item *)_empty_list);
    }
    return (Item *)listItem;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_trjob(Item * trlink, Item * trport, Item * trobjname,
                  Item * trobjtype, Item * trrole, Item * trrcp,
                  Item * trptnr, Item * trptport, Item * trdir,
                  Item * trtype, Item * trlocation, Item * trautostart)
{
    INIT_FUNCTION("make_trjob");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)trlink);
    listItem->add((BS2Item *)trport);
    listItem->add((BS2Item *)trobjname);
    listItem->add((BS2Item *)trobjtype);
    listItem->add((BS2Item *)trrole);
    listItem->add((BS2Item *)trrcp);
    listItem->add((BS2Item *)trptnr);
    listItem->add((BS2Item *)trptport);
    listItem->add((BS2Item *)trdir);
    listItem->add((BS2Item *)trtype);
    listItem->add((BS2Item *)trlocation);
    listItem->add((BS2Item *)trautostart);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_var_limit(Item * vid, Item * units, Item * limitmin,
                      Item * limitmax, Item * limit_decl)
{
    INIT_FUNCTION("make_var_limit");
    BS2ListItem * list1Item = new BS2ListItem;
    BS2ListItem * list2Item = new BS2ListItem;
    list1Item->add((BS2Item *)vid);
    if (units != NULL && limitmin != NULL && limitmax != NULL &&
        limit_decl != NULL)
    {
        list2Item->add((BS2Item *)units);
        list2Item->add((BS2Item *)limitmin);
        list2Item->add((BS2Item *)limitmax);
        list2Item->add((BS2Item *)limit_decl);
        list1Item->add((BS2Item *)list2Item);
    }
    return (Item *)list1Item;
}


/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_recipe_info(Item * rcpsec1, Item * rcpbody, Item * rcpsec2)
{
    INIT_FUNCTION("make_recipe_info");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)rcpsec1);

    if (rcpbody == NULL)
    {
    }
    listItem->add((BS2Item *)rcpbody);

    if (rcpsec2 == NULL)
    {
    }
    listItem->add((BS2Item *)rcpsec2);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_recipe_section(Item * name, Item * rcpattr)
{
    INIT_FUNCTION("make_recipe_section");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)name);
    if (rcpattr == NULL)
    {
    }
    listItem->add((BS2Item *)rcpattr);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_recipe_descriptor(Item * rcpdescnm, Item * rcpdesctime,
                             Item * rcpdesclth)
{
    INIT_FUNCTION("make_recipe_descriptor");
    BS2ListItem * listItem  = new BS2ListItem;
    if (rcpdescnm != NULL && rcpdesctime != NULL && rcpdesclth != NULL)
    {
        listItem->add((BS2Item *)rcpdescnm);
        listItem->add((BS2Item *)rcpdesctime);
        listItem->add((BS2Item *)rcpdesclth);
    }
    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_rec_info(Item * rcpid, Item * rcpnewid, Item * rmsegspec,
                     Item * rmchgtype, Item * opid, Item * timestamp,
                     Item * rmrequestor)
{
    INIT_FUNCTION("make_rec_info");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)rcpid);
    listItem->add((BS2Item *)rcpnewid);
    listItem->add((BS2Item *)rmsegspec);
    listItem->add((BS2Item *)rmchgtype);
    listItem->add((BS2Item *)opid);
    listItem->add((BS2Item *)timestamp);
    listItem->add((BS2Item *)rmrequestor);

    return (Item *)listItem;
}

/*---------------------------------------------------------------------------*/
/* make                                                                      */
/*---------------------------------------------------------------------------*/
Item * make_trace_decl(Item * totsmp, Item * repgsz, Item * start_evtsrc,
                       Item * start_ceid, Item * stop_evtsrc,
                       Item * stop_ceid, Item * trautod, Item * rptoc)
{
    INIT_FUNCTION("make_trace_decl");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)totsmp);
    listItem->add((BS2Item *)repgsz);
    listItem->add((BS2Item *)start_evtsrc);
    listItem->add((BS2Item *)start_ceid);
    listItem->add((BS2Item *)stop_evtsrc);
    listItem->add((BS2Item *)stop_ceid);
    listItem->add((BS2Item *)trautod);
    listItem->add((BS2Item *)rptoc);

    return (Item *)listItem;
}

//---------------------------------------------------------------------------
// Make prosess job
//---------------------------------------------------------------------------
Item * make_prjob(Item * prjobid, Item * carrier_mf, Item * carslot_list,
                  Item * proc_recipe, Item * prprocessstart,
                  Item * prpauseevent)
{
    INIT_FUNCTION("make_prjob");
    BS2ListItem * listItem  = new BS2ListItem;
    listItem->add((BS2Item *)prjobid);
    listItem->add((BS2Item *)carrier_mf);
    if (carslot_list != NULL)
    {
        listItem->add((BS2Item *)carslot_list);
    }
    else
    {
        BS2ListItem * empty_list = new BS2ListItem;
        listItem->add((BS2Item *)empty_list);
    }
    listItem->add((BS2Item *)proc_recipe);
    listItem->add((BS2Item *)prprocessstart);
    listItem->add((BS2Item *)prpauseevent);

    return (Item *)listItem;
}


//
// *** End of File ***
