// $Id: BS2TclDevice.h,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2TclDevice.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BS2TCLDEVICE_H
#define BS2TCLDEVICE_H

#include "BS2Device.h"
#include "BS2Interpreter.h"
#include "tcl.h"

// Forward declaration
class BS2State;
class BS2StateTable;
class BS2Message;
class BS2TclDevice;

// Definition of ClientData
struct Tcl_Equipment
{
    BS2TclInterp m_tcl;
    BS2TclDevice * m_device;

    Tcl_Equipment() {}
    ~Tcl_Equipment() {}
};

//-----------------------------------------------------------------------------
//
// Delay Time handler for Tcl Management class
//
//-----------------------------------------------------------------------------
#define INIT_TIMERID            -1
#define ERROR_TIMERID           -1

class TCLDelayHandler : public ACE_Handler
{
public:
    TCLDelayHandler() : m_eventName("Tcl_Device") { }

    virtual void handle_time_out(const ACE_Time_Value &tv,
                                 const void * arg);
private:
    string      m_eventName;
};

//-----------------------------------------------------------------------------
//
// Tcl Device Manager class
//
//-----------------------------------------------------------------------------
class BS2TclDevice: public ACE_Task<ACE_MT_SYNCH>
{
public:
    BS2TclDevice(char * name);
    ~BS2TclDevice() { }

    virtual int open(void * = 0);
    virtual int close(int = 0);
    virtual int svc(void);

    BS2Driver * getDriver() const { return m_device->getDriver(); }
    BS2TransactionManager * getTransactionManager() const {
            return m_device->getTransactionManager(); 
        }
    void * getInterp() const      { return m_interp.value(); }
    const char * getGlobalName()  { return m_varname.c_str(); }
    Tcl_ThreadId getThreadId()    { return m_threadId; }
    void setInterp(Tcl_Interp * interp) { m_interp = interp; }
    void setThreadId(Tcl_ThreadId id)   { m_threadId = id; }
    void setGlobalName(const char * varname) { m_varname = varname; }

    int   stopLoop();                      // terminate thread
    int   send(BS2Message * msg);
    int   accept();
    const char * name() const { return m_name.c_str(); }
    void  device(BS2Device * device)  { m_device = device; }
    long  timerId() const     { return m_tmid; }
    void  timerId(long id)    { m_tmid = id; }
    UINT  logmask() const     { return m_logmask; }
    void  logmask(UINT bits)  { m_logmask = bits; }

    static BS2TclDevice * instance();

protected:
    int startTimer(long sec);
    int cancelTimer();

//
protected:
    string m_name;
    string m_varname;
    UINT   m_logmask;
    long   m_tmid;
    BS2Device *     m_device;
    ACE_Time_Value  m_tv;         // event watching time in thread
    ACE_Auto_Event  m_synch;      // synchronized for request
    Tcl_ThreadId    m_threadId;
    TCLDelayHandler m_timer;
    ACE_Atomic_Op<ACE_Thread_Mutex, Tcl_Interp *> m_interp;
};


#endif
