// $Id: tclSecs.cpp,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

//=============================================================================
/**
 *  @file    tclSecs.cpp
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#include "BS2TclDevice.h"
#include "tcl.h"

#define NAMESPACE "secs::"
#define PACKAGE_NAME "secs"
#define PACKAGE_VERSION "1.0"

extern int Ace_logCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_initializeCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_viewCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_createCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_deleteCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_sendCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_receiveCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_testCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_configCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_convertCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);
extern int Secs_dictionaryCmd (ClientData, Tcl_Interp *, int, Tcl_Obj *CONST []);

// Uninitialze ACE when the Tcl interpreter is deleted.

static void
Secs_InterpDeleteProc (ClientData clientData, Tcl_Interp *interp)
{
    BS2TclDevice * device = (BS2TclDevice *)clientData;

    delete device;
}

/*
 *  This procedure performs application-specific initialization.
 *  Most applications, especially those that incorporate additional
 *  packages, will have their own version of this procedure.
 *
 * Results:
 *  Returns a standard Tcl completion code, and leaves an error
 *  message in interp->result if an error occurs.
 *
 * Side effects:
 *  Depends on the startup script.
 */
extern "C" DLLEXPORT int
Secs_Init (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    Tcl_CallWhenDeleted(interp, Secs_InterpDeleteProc, 0);

    Tcl_Equipment * equipInfo = new Tcl_Equipment;
    equipInfo->m_tcl.interp(interp);

    // Create additional commands.
    Tcl_CreateObjCommand(interp, NAMESPACE "log", Ace_logCmd,
        (ClientData)NULL, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "init", Secs_initializeCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "create", Secs_createCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "view", Secs_viewCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "delete", Secs_deleteCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "test", Secs_testCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "format", Secs_configCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "convert", Secs_convertCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    Tcl_CreateObjCommand(interp, NAMESPACE "dictionary", Secs_dictionaryCmd,
        (ClientData)equipInfo, (Tcl_CmdDeleteProc *)0);
    return Tcl_PkgProvide(interp, PACKAGE_NAME, PACKAGE_VERSION);
}

/*
 *  This procedure initializes commands for a safe interpreter.
 *  You would leave out of this procedure any commands you deemed unsafe.
 *
 * Results:
 *  A standard Tcl result.
 *
 * Side effects:
 *  None.
 */
extern "C" DLLEXPORT int
Secs_SafeInit (Tcl_Interp *interp)
{
#ifdef USE_TCL_STUBS
    if (Tcl_InitStubs(interp, "8.3", 0) == NULL) {
        return TCL_ERROR;
    }
#endif

    return Tcl_PkgProvide(interp, PACKAGE_NAME, PACKAGE_VERSION);
}

