# $Id: testsecs.tcl,v 1.1.1.1 2002/08/31 04:47:24 fukasawa Exp $

##############################################################################
#
#   @file    testsecs.tcl
#
#   @author Fukasawa Mitsuo
#
#
#     Copyright (C) 1998-2001 BEE Co.,Ltd. All rights reserved.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

##############################################################################
#
secs::test {
    message {WAIT} S0F0 {
        0x00 0x11 0x22 0x33 0x44 0x55 0x66 0x77
        0x88 0x99 0xaa 0xbb 0xcc 0xdd 0xee 0xff
    }
}

###############################################################################
# Stream 1
###############################################################################
secs::initialize xml/secs2.xml

secs::test {message {} S1F0  }

secs::test {message S1F1  }
secs::test {message {WAIT} S1F1  }
secs::test {message {NOWAIT} S1F1  }

set mdln {"ABCDEF"}
set softrev {"V1R0.0"}
set message {message {} S1F2 { $mdln $softrev } }
secs::test $message

secs::test {
    message {WAIT} S1F3 {1i1 2u2 100i2 256u2 200i4 1023u4 100i8 2222222u8 }
}

set sv(1,svid) 100
set sv(2,svid) 255
set sv(3,svid) 200
set sv(4,svid) 1023
set sv(5,svid) 55555
secs::test {
    message {WAIT} S1F3 {
        $sv(1,svid) $sv(2,svid) $sv(3,svid) $sv(4,svid) $sv(5,svid)
    }
}

secs::test {message {} S1F4 {"abcd" 99999.9 0x200 1023 10} }
set sv(1,sv)   {"abcd"}
set sv(2,sv)   99999.9
set sv(3,sv)   0x200
set sv(4,sv)   1023
set sv(5,sv)   0
secs::test {
    message {} S1F4 {$sv(1,sv) $sv(2,sv) $sv(3,sv) $sv(4,sv) $sv(5,sv)}
}

set sfcd 0x0
secs::test {message {} S1F5 $sfcd }
### secs::test {message {} S1F6 $sfcd }
secs::test {message {WAIT} S1F7 $sfcd }
### secs::test {message {} S1F8 $sfcd }
secs::test {message {WAIT} S1F9 }
### secs::test {message {} S1F10 ?????   }

secs::test {message {WAIT} S1F11 {100 256 200 1023 0x111111} }
set sv(1,svid) 100
set sv(2,svid) 255
set sv(3,svid) 200
set sv(4,svid) 1023
set sv(5,svid) 0x111111
set svid_list {100 255 200 1023 0x111111}
secs::test {message {} S1F11 {$svid_list} }
secs::test {message {WAIT} S1F11 {} }

set sv_list {{1 "ABC" "lot"} {10 "defghijk" "umHg"} {100 "dai_stock" "dai"}}
secs::test { message {} S1F12 {$sv_list} }

set mdln {"ABCDEF"}
set softrev {"V1R0.0"}
secs::test {message {WAIT} S1F13 {$mdln $softrev} }
secs::test {message {WAIT} S1F13 {} }

set mdln {"ABCDEF"}
set softrev {"V1R0.0"}
secs::test {message {} S1F14 { 0x00 { $mdln $softrev } } }
secs::test {message {} S1F14 { 0x00 {} }  }

secs::test {message {WAIT} S1F15 }

set ack 0x00
secs::test {message {} S1F16 $ack }

secs::test {message {WAIT} S1F17  }

set ack 0x00
secs::test {message {} S1F18 $ack }

set objtype {"BSMachine"}
set objid(0) {"spin"}
set objid(1) {"cvd"}
set objid(2) {"cmp"}
set objid(3) {"robocop"}
set objid(4) {"tetsuwan-atom"}
set attrid(NAME)    {"name"}
set attrid(VERSION) {"version"}
set attrid(VENDOR)  {"vendor"}
set attrid(MODEL)   {"model"}
set attrid(SERIALNUM) {"serial#"}
secs::test {
    message {WAIT} S1F19 {
        $objtype {$objid(0) $objid(1) $objid(2) $objid(3) $objid(4)}
                 {$attrid(NAME) $attrid(VERSION) $attrid(VENDOR)
                  $attrid(MODEL) $attrid(SERIALNUM)}
    }
}

set spin(name)    {"SPIN200W"}
set spin(version) {"v1.00"}
set spin(vendor)  {"SCREEN"}
set spin(model)   {"SPIN"}
set spin(serial-num) {"10000"}
set cvd(name)     {"CERAUS ZX-1000CVD"}
set cvd(version)  {"v2.10"}
set cvd(vendor)   {"NSG"}
set cvd(model)    {"CVD"}
set cvd(serial-num) {"1000"}
set cmp(name)     {"EPO-222"}
set cmp(version)  {"V1R00"}
set cmp(vendor)   {"EBARA"}
set cmp(model)    {"CMP"}
set cmp(serial-num) {"98011"}
secs::test {
     message {} S1F20 {
         {{$spin(name) $spin(version) $spin(vendor) $spin(model)
           $spin(serial-num)}
          {$cvd(name) $cvd(version) $cvd(vendor) $cvd(model) $cvd(serial-num)}
          {$cmp(name) $cmp(version) $cmp(vendor) $cmp(model) $cmp(serial-num)}
         }
         {{1 "tetsuwan-atom" } {5 "robocop"}}
     }
}

###############################################################################
# Stream 2
###############################################################################
set grant 123
set ack_ok 0
secs::test {message {WAIT} S2F1 {"100" 128} }
secs::test {message {} S2F2 $grant }

secs::test {
    message {WAIT} S2F3 {
        0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07
        0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f
        0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17
        0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f
        0x20 0x21 0x22 0x23 0x24 0x25 0x26 0x27
        0x28 0x29 0x2a 0x2b 0x2c 0x2d 0x2e 0x2f
        0x30 0x31 0x32 0x33 0x34 0x35 0x36 0x37
        0x38 0x39 0x3a 0x3b 0x3c 0x3d 0x3e 0x3f
        0x40 0x41 0x42 0x43 0x44 0x45 0x46 0x47
        0x48 0x49 0x4a 0x4b 0x4c 0x4d 0x4e 0x4f
        0x50 0x51 0x52 0x53 0x54 0x55 0x56 0x57
        0x58 0x59 0x5a 0x5b 0x5c 0x5d 0x5e 0x5f
        0x60 0x61 0x62 0x63 0x64 0x65 0x66 0x67
        0x68 0x69 0x6a 0x6b 0x6c 0x6d 0x6e 0x6f
        0x70 0x71 0x72 0x73 0x74 0x75 0x76 0x77
        0x78 0x79 0x7a 0x7b 0x7c 0x7d 0x7e 0x7f
        0x80 0x81 0x82 0x83 0x84 0x85 0x86 0x87
        0x88 0x89 0x8a 0x8b 0x8c 0x8d 0x8e 0x8f
        0x90 0x91 0x92 0x93 0x94 0x95 0x96 0x97
        0x98 0x99 0x9a 0x9b 0x9c 0x9d 0x9e 0x9f
        0xa0 0xa1 0xa2 0xa3 0xa4 0xa5 0xa6 0xa7
        0xa8 0xa9 0xaa 0xab 0xac 0xad 0xae 0xaf
        0xb0 0xb1 0xb2 0xb3 0xb4 0xb5 0xb6 0xb7
        0xb8 0xb9 0xba 0xbb 0xbc 0xbd 0xbe 0xbf
        0xc0 0xc1 0xc2 0xc3 0xc4 0xc5 0xc6 0xc7
        0xc8 0xc9 0xca 0xcb 0xcc 0xcd 0xce 0xcf
        0xd0 0xd1 0xd2 0xd3 0xd4 0xd5 0xd6 0xd7
        0xd8 0xd9 0xda 0xdb 0xdc 0xdd 0xde 0xdf
        0xe0 0xe1 0xe2 0xe3 0xe4 0xe5 0xe6 0xe7
        0xe8 0xe9 0xea 0xeb 0xec 0xed 0xee 0xef
        0xf0 0xf1 0xf2 0xf3 0xf4 0xf5 0xf6 0xf7
        0xf8 0xf9 0xfa 0xfb 0xfc 0xfd 0xfe 0xff}
}

secs::test {message {} S2F4 $ack_ok  }

secs::test {message {WAIT} S2F5 "ServiceProgrem_1"  }

secs::test {
    message {} S2F6 {
        0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
        0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
        0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
        0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
        0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
        0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
        0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
        0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
        0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
        0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
        0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
        0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
        0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
        0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
        0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
        0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
        0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
        0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
        0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
        0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
        0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
        0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
        0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
        0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
        0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
        0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
        0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
        0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
        0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
        0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
        0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
        0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00
    }
}

secs::test {message {WAIT} S2F7 "ServiceProgrem_1"  }

secs::test {message {} S2F8 $ack_ok  }

secs::test {message {WAIT} S2F9 "ServiceProgrem_1"  }

secs::test {message {} S2F10 "" }

secs::test {message {WAIT} S2F11 }

set spid(1) {"ServiceProgrem_1"}
set spid(2) {"ServiceProgrem_2_ABC"}
set spid(3) {"SPID3"}
set spid(4) {"10000002"}
set spid(5) {"ServiceProgrem_5.5"}
set spid(6) {"ServiceProgrem_6"}
set spid(7) {"ServiceProgrem_7"}
set spid(8) {"ServiceProgrem_8"}
set spid(9) {"ServiceProgrem_9"}
set spid(10) {"ServiceProgrem_TEN"}
secs::test {
    message {} S2F12 {
        $spid(1) $spid(2) $spid(3) $spid(4) $spid(5) $spid(6)
        $spid(7) $spid(8) $spid(9) $spid(10)
    }
}

secs::test {message {WAIT} S2F13 {100 95 200 23 11} }

set ecv(1) {0}
set ecv(2) {10000}
set ecv(3) {123.456}
set ecv(4) {"10000002"}
set ecv(5) {0.000009}
secs::test {message {WAIT} S2F14 {$ecv(1) $ecv(2) $ecv(3) $ecv(4) $ecv(5)} }

set ecid(1) {100}
set ecid(2) {95}
set ecid(3) {200}
set ecid(4) {23}
set ecid(5) {11}
secs::test {
    message {WAIT} S2F15 {
        {$ecid(1) 10} {$ecid(2) 9990} {$ecid(3) 78.901} {$ecid(4) 10000004}
        {$ecid(5) 0.00001}
    }
}

set ack_ok 0
secs::test {message {} S2F16 $ack_ok  }

secs::test {message {WAIT} S2F17  }

secs::test {message {} S2F18 "980711183459" }

secs::test {message {WAIT} S2F19 1  }
secs::test {message {WAIT} S2F19 135  }

set ack_ok 0
secs::test {message {} S2F20 $ack_ok  }

set rcmd(start) {"BEGIN"}
set rcmd(stop)  {"END"}
set rcmd(pause) 999999
set rcmd(resume) 999998
secs::test {message {WAIT} S2F21 $rcmd(start)   }

set ack_ok 01
secs::test {message {} S2F22 $ack_ok  }

set trid   {1}
set dsper  {"123456"}
set totsmp {0}
set repgsz {12}
secs::test {
    message {WAIT} S2F23 {$trid $dsper $totsmp $repgsz {1 2 3 4 5 6 7 8 9 } }
}
secs::test {message {WAIT} S2F23 {$trid $dsper $totsmp $repgsz {} } }

set ack_ok 0
secs::test {message {} S2F24 $ack_ok  }

secs::test {
    message {WAIT} S2F25 {
        0x00 0x11 0x22 0x33 0x44 0x55 0x66 0x77
        0x88 0x99 0xaa 0xbb 0xcc 0xdd 0xee 0xff
    }
}

secs::test {
    message {} S2F26 {
        0x00 0x11 0x22 0x33 0x44 0x55 0x66 0x77
        0x88 0x99 0xaa 0xbb 0xcc 0xdd 0xee 0xff
    }
}

set mid(1) 200
secs::test {message {WAIT} S2F27 {100 250 {$mid(1) 23 0x11} } }

set ack_ok 0
secs::test {message {} S2F28 $ack_ok  }

set ecids  {{ 100 95 200 23 11 } }
secs::test {message {WAIT} S2F29 $ecids  }

set ecvinfo(100)  { {100 "NAME100" 0 100 99 "wfr"} }
set ecvinfo(95)   { {95  "NAME095" 0 100 99 "wfr"} }
set ecvinfo(200)  { {200 "NAME200" 0 100 99 "wfr"} }
set ecvinfo(23)   { {23  "NAME023" 0 100 99 "wfr"} }
set ecvinfo(11)   { {11  "NAME011" 0 100 99 "wfr"} }
secs::test {
    message {} S2F30 {
        $ecvinfo(100) $ecvinfo(95) $ecvinfo(200) $ecvinfo(23) $ecvinfo(11)
    }
}

secs::test {message {WAIT} S2F31 "980711183459" }

set ack_ok 0
secs::test {message {} S2F32 $ack_ok  }

set dataid  111
set report(1)  { {1 {123 456 7890 "abcdefg"}} }
set report(2)  { {2 {234 567 8901 "hij"}} }
set report(3)  { {3 {345 678 9012 "klmn"}} }
set report(4)  { {4 {456 789 0123 "opqrstu"}} }
set report(5)  { {5 {567 890 1234 "vwxyz"}} }
set report(6)  { {6 {678 901 2345 "Bee"}} }
secs::test {
    message {WAIT} S2F33 {
        $dataid {
            $report(1) $report(2) $report(3) $report(4) $report(5) $report(6)
        }
    }
}

set ack_ok 0
secs::test {message {} S2F34 $ack_ok  }

set dataid  111
set rptids(1)  { {1 {123 456 7890 "abcdefg"}} }
set rptids(2)  { {2 {234 567 8901 "hij"}} }
set rptids(3)  { {3 {345 678 9012 "klmn"}} }
set rptids(4)  { {4 {456 789 0123 "opqrstu"}} }
secs::test {
    message {WAIT} S2F35 {
        $dataid {$rptids(1) $rptids(2) $rptids(3) $rptids(4) }
    }
}

set ack_ok 0
secs::test {message {} S2F36 $ack_ok  }

secs::test {
    message {WAIT} S2F37 { true {1 2 3 4 5 6 7 } }
}

set ack_ok 0
secs::test {message {} S2F38 $ack_ok }

secs::test {message {WAIT} S2F39 {1 512} }

set grant 0
secs::test {message {} S2F40 $grant  }

set rcmdx {"lp"}
set parm1 { {"-d" "LPT0" } }
set parm2 { {"-n" 1 } }
set parm3 { {"-o" "nobanner" } }
set parm4 { {"-o" "width=80" } }
set parm5 { {"-t" "test print" } }
set parm6 { {"-x" "illegal" } }
secs::test {
    message {WAIT} S2F41 {$rcmdx {$parm1 $parm2 $parm3 $parm4 $parm5 $parm6 } }
}

set ack_ng 3
set parmerr6 { {"-x" 1 } }
secs::test {message {} S2F42 { $ack_ng { $parmerr6 } } }

set s1fxx { {1 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20} } }
set s2fxx { {2 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39
                40 41 42 43 44 45 46 47 48} } }
set s3fxx { {3 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14} } }
set s4fxx { {4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39
                40 41 42} } }
set s5fxx { {5 {0 1 2 3 4 5 6 7 8} } }
set s6fxx { {6 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                20 21 22 23 24} } }
set s7fxx { {7 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36} } }
set s8fxx { {8 {0 1 2 3 4} } }
set s9fxx { {9 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14} } }
set s10fxx { {10 {0 1 2 3 4 5 6 7 8 9 10} } }
# set s11fxx { {11 { 0 } } }
set s12fxx { {12 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20} } }
set s13fxx { {13 {0 1 2 3 4 5 6 7 8 9 10} } }
set s14fxx { {14 {0 1 2 3 4 5 6 7 8} } }
secs::test {
    message {WAIT} S2F43 {
        $s1fxx $s2fxx $s3fxx $s4fxx $s5fxx $s6fxx $s7fxx
        $s8fxx $s9fxx $s10fxx $s12fxx $s13fxx $s14fxx
    }
}

set ack_ng 1
set s1fxx_ack { {1 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20} } }
set s2fxx_ack { {2 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                      20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36
                      37 38 39 40 41 42 43 44 45 46 47 48} } }
set s3fxx_ack { {3 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14} } }
set s4fxx_ack { {4 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                      20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36
                      37 38 39 40 41 42} } }
set s5fxx_ack { {5 4 {0 1 2 3 4 5 6 7 8} } }
set s6fxx_ack { {6 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                      20 21 22 23 24} } }
set s7fxx_ack { {7 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19
                      20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36} } }
set s8fxx_ack { {8 4 {0 1 2 3 4} } }
set s9fxx_ack { {9 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14} } }
set s10fxx_ack { {10 4 {0 1 2 3 4 5 6 7 8 9 10} } }
# set s11fxx_ack { {11 4 { 0 } } }
set s12fxx_ack { {12 4 {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20} } }
set s13fxx_ack { {13 4 {0 1 2 3 4 5 6 7 8 9 10} } }
set s14fxx_ack { {14 4 {0 1 2 3 4 5 6 7 8} } }
secs::test {
    message {} S2F44 {
        $ack_ng {$s1fxx_ack $s2fxx_ack $s3fxx_ack $s4fxx_ack $s5fxx_ack
                 $s6fxx_ack $s7fxx_ack $s8fxx_ack $s9fxx_ack $s10fxx_ack $s12fxx_ack
                 $s13fxx_ack $s14fxx_ack}
    }
}

set dataid  111
set vid_1       {"temperature"}
set limit_1(1)  { {1 {123 456} } }
set limit_1(2)  { {2 {234 567} } }
set limit_1(3)  { {3 {345 678} } }
set limit_1(4)  { {4 {456 789} } }
set vid_2       {"rotate"}
set limit_2(1)  { {1 {1000 1500} } }
set limit_2(2)  { {2 {2000 2500} } }
set limit_2(3)  { {3 {3000 3500} } }
set limit_2(4)  { {4 {4000 4500} } }
set vid_3       {"pressure"}
set limit_3(1)  { {1 {1.0 1.5} } }
set limit_3(2)  { {2 {1.2 2.0} } }
set limit_3(3)  { {3 {2.0 2.2} } }
set limit_3(4)  { {4 {3.0 4.0} } }
secs::test {
    message {WAIT} S2F45 {
        $dataid { {$vid_1 {$limit_1(1) $limit_1(2) $limit_1(3) $limit_1(4)} }
                  {$vid_2 {$limit_2(1) $limit_2(2) $limit_2(3) $limit_2(4)} }
                  {$vid_3 {$limit_3(1) $limit_3(2) $limit_3(3) $limit_3(4)} }
        }
    }
}

set ack_ng 1
set vid_2       {"rotate"}
set vid_3       {"pressure"}
set limitid(1) 1
set limitid(2) 2
set limitid(3) 3
set limitid(4) 4
secs::test {
    message {} S2F46 {
        $ack_ng {{$vid_2 4 $limitid(2) 1 } {$vid_3 4 $limitid(3) 5 }}
    }
}

set vid_1       {444}
set vid_2       {"rotate"}
set vid_3       {"pressure"}
secs::test {message {WAIT} S2F47 { $vid_1 $vid_2 $vid_3 }  }

set vid_1       {"temperature"}
set limit_1(1)  { {1 123 456} }
set limit_1(2)  { {2 234 567} }
set limit_1(3)  { {3 345 678} }
set limit_1(4)  { {4 456 789} }
set vid_2       {"rotate"}
set limit_2(1)  { {1 1000 1500} }
set limit_2(2)  { {2 2000 2500} }
set limit_2(3)  { {3 3000 3500} }
set limit_2(4)  { {4 4000 4500} }
set vid_3       {"pressure"}
set limit_3(1)  { {1 1.0 1.5} }
set limit_3(2)  { {2 1.2 2.0} }
set limit_3(3)  { {3 2.0 2.2} }
set limit_3(4)  { {4 3.0 4.0} }
secs::test {
    message {} S2F48 {
        {$vid_1 "degC" 0   1000  {$limit_1(1) $limit_1(2) $limit_1(3) $limit_1(4) } }
        {$vid_2 "r"    0   6000  {$limit_2(1) $limit_2(2) $limit_2(3) $limit_2(4) } }
        {$vid_3 "Pa"   1.0 5.0 {$limit_3(1) $limit_3(2) $limit_3(3) $limit_3(4)}  }
    }
}

set dataid {12}
set objspec {"Recipe:Recipe100>"}
set rcmdx {"PP-SELECT"}
set exrcmd_parm(1) { {"parm1" "value1"} }
set exrcmd_parm(2) { {"parm2" "value2"} }
set exrcmd_parm(3) { {"parm3" "value3"} }
secs::test {
    message {WAIT} S2F49 {
        $dataid $objspec $rcmdx { $exrcmd_parm(1) $exrcmd_parm(2) $exrcmd_parm(3) }
    }
}

secs::test {message {WAIT} S2F49 { $dataid $objspec $rcmdx {} } }

set ack 0
set cpname(1) {"name1"}
set cpname(2) {"name2"}
set cpname(3) {"name3"}
set cepack(1) { 10 }
set cepack(2) { {"name2" 200} }
set cepack(3) { {"name3" 300} }
secs::test {
    message {} S2F50 {
        $ack { {$cpname(1) $cepack(1)} {$cpname(2) $cepack(2)}
               {$cpname(3) $cepack(3)}
        }
   }
}
secs::test {message {} S2F50 {$ack {} } }

###############################################################################
# Stream 3
###############################################################################
secs::test {message {WAIT} S3F1 }

set mf 1
set loc(1) {1}
set qua(1) {1}
set mid(1) {"wafer_1"}
set loc(2) {2}
set qua(2) {2}
set mid(2) {"wafer_2"}
set loc(3) {3}
set qua(3) {3}
set mid(3) {"wafer_3"}
set loc(4) {4}
set qua(4) {4}
set mid(4) {"wafer_4"}
set loc(5) {5}
set qua(5) {5}
set mid(5) {"wafer_5"}
secs::test {message {} S3F2 {$mf { {$loc(1) $qua(1) $mid(1)}
                                {$loc(2) $qua(2) $mid(2)}
                                {$loc(3) $qua(3) $mid(3)}
                                {$loc(4) $qua(4) $mid(4)}
                                {$loc(5) $qua(5) $mid(5)} } } }
secs::test {message {} S3F2 {$mf {} } }

secs::test {message {WAIT} S3F3 }

set mf 2
set ttc(1) {1234560}
set qua(1) {11}
set mid(1) {"wafer_11"}
set ttc(2) {1234570}
set qua(2) {22}
set mid(2) {"wafer_22"}
set ttc(3) {1234580}
set qua(3) {33}
set mid(3) {"wafer_33"}
set ttc(4) {1234590}
set qua(4) {44}
set mid(4) {"wafer_44"}
set ttc(5) {1234600}
set qua(5) {55}
set mid(5) {"wafer_55"}
secs::test {message {} S3F4 {$mf { {$ttc(1) $qua(1) $mid(1)}
                                {$ttc(2) $qua(2) $mid(2)}
                                {$ttc(3) $qua(3) $mid(3)}
                                {$ttc(4) $qua(4) $mid(4)}
                                {$ttc(5) $qua(5) $mid(5)} } } }
secs::test {message {} S3F4 {$mf {} } }

set mf 3
set qua(1) {131}
secs::test {message {WAIT} S3F5 {$mf $qua(1)}}

set ack_ok 0
secs::test {message {} S3F6 $ack_ok}

set mf 2
set qua(1) {11}
set mid(1) {"wafer_11"}
secs::test {message {WAIT} S3F7 {$mf $qua(1) $mid(1)} }

set ack_ok 0
secs::test {message {} S3F8 $ack_ok}

set mid(1) {"wafer_11"}
set emid   { {0x01 0x02 0x03 0x04 0x05} }
secs::test {message {WAIT} S3F9 {$mid(1) $emid } }

set ack_ok 0
secs::test {message {} S3F10 $ack_ok}

set ptn 10
secs::test {message {WAIT} S3F11 $ptn}

set ptn 99
set mid(1) {"wafer_99"}
set midra  {1}
secs::test {message {} S3F12 {$ptn $midra $mid(1)}}

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {WAIT} S3F13 {$ptn $mid(1) } }

set midac 0
secs::test {message {} S3F14 $midac}

###############################################################################
# Stream 4
###############################################################################
set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {WAIT} S4F1 {$ptn $mid(1)} }

set ack_ok 0
secs::test {message {} S4F2 $ack_ok}

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F3 {$ptn $mid(1)} }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F5 {$ptn $mid(1)}}

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F7 {$ptn $mid(1)} }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F9 {$ptn $mid(1) } }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F11 {$ptn $mid(1) } }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F13 {$ptn $mid(1) } }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {} S4F15 {$ptn $mid(1)} }

set ptn 100
set mid(1) {"wafer_100"}
secs::test {message {WAIT} S4F17 {$ptn $mid(1)} }

set ack_ok 0
secs::test {message {} S4F18 $ack_ok}

set dataid {"job_1"}
set trjobname {"move1to2"}
set trlink(1)      {100}
set trport(1)      {1}
set trobjname(1)   {"cassette_1"}
set trobjtype(1)   {2}
set trrole(1)      {0}
set trrcp(1)       {"recipe_123"}
set trptnr(1)      {"indexer1"}
set trptport(1)    {3}
set trdir(1)       {1}
set trtype(1)      {10}
set trlocation(1)  {5}
set trautostart(1) {true}
set trlink(2)      {101}
set trport(2)      {2}
set trobjname(2)   {"cassette_2"}
set trobjtype(2)   {3}
set trrole(2)      {1}
set trrcp(2)       {"recipe_124"}
set trptnr(2)      {"indexer2"}
set trptport(2)    {4}
set trdir(2)       {2}
set trtype(2)      {11}
set trlocation(2)  {6}
set trautostart(2) {false}
secs::test {
    message {WAIT} S4F19 {
        $dataid $trjobname
        {$trlink(1) $trport(1) $trobjname(1) $trobjtype(1) $trrole(1)
         $trrcp(1) $trptnr(1) $trptport(1) $trdir(1) $trtype(1)
         $trlocation(1) $trautostart(1)}
        {$trlink(2) $trport(2) $trobjname(2) $trobjtype(2) $trrole(2)
         $trrcp(2) $trptnr(2) $trptport(2) $trdir(2) $trtype(2)
         $trlocation(2) $trautostart(2)}
    }
}

set trjobid 10
set tratomicid(1) 1234
set tratomicid(2) 2345
set tratomicid(3) 3456
set tratomicid(4) 4567
set tratomicid(5) 5678
set track false
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S4F20 {
        $trjobid
        {$tratomicid(1) $tratomicid(2) $tratomicid(3) $tratomicid(4)
         $tratomicid(5) }
        {$track {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) } }
        }
    }
}

set trjobid 22
set trcmdname {"move"}
set cpname(1) {"north"}
set cpval(1)  {30}
set cpname(2) {"west"}
set cpval(2)  {40}
set cpname(3) {"east"}
set cpval(3)  {50}
set cpname(4) {"south"}
set cpval(4)  {60}
secs::test {
    message {WAIT} S4F21 {
        $trjobid $trcmdname {
           {$cpname(1) $cpval(1) } {$cpname(2) $cpval(2) }
           {$cpname(3) $cpval(3) } {$cpname(4) $cpval(4) }
        }
    }
}

set track false
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S4F22 {
        $track {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) }
        }
    }
}

set trjobid {23}
set trjobname {"movejob"}
set trjobms {1}
set track   {false}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {WAIT} S4F23 {
        $trjobid $trjobname $trjobms
        {$track {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) } }
        }
    }
}

secs::test {message {} S4F24}

set dataid 25
set datalength 1800
secs::test {message {WAIT} S4F25 {$dataid $datalength}}

set grant 3
secs::test {message {} S4F26 $grant}

set eqname    {"equipment"}
set trlink(1)      {100}
set trport(1)      {1}
set trobjname(1)   {"cassette_1"}
set trobjtype(1)   {2}
set trrole(1)      {0}
set trrcp(1)       {"recipe_123"}
set trptnr(1)      {"indexer1"}
set trptport(1)    {3}
set trdir(1)       {1}
set trtype(1)      {10}
set trlocation(1)  {5}
secs::test {
    message {} S4F27 {
        $eqname $trlink(1) $trport(1) $trobjname(1) $trobjtype(1) $trrole(1)
        $trptnr(1) $trptport(1) $trdir(1) $trtype(1) $trlocation(1)
    }
}

set trlink_1  {100}
set mcindex   22
set hocmdname {"move"}
set cpname(1) {"north"}
set cpval(1)  {30}
set cpname(2) {"west"}
set cpval(2)  {40}
set cpname(3) {"east"}
set cpval(3)  {50}
set cpname(4) {"south"}
set cpval(4)  {60}
secs::test {
    message {} S4F29 {
        $trlink_1 $mcindex $hocmdname {
            {$cpname(1) $cpval(1) } {$cpname(2) $cpval(2) }
            {$cpname(3) $cpval(3) } {$cpname(4) $cpval(4) }
        }
    }
}

set trlinkx {23}
set mcindex {22}
set hoack   {false}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S4F31 {
        $trlinkx $mcindex {
            $hoack {
                {$errcode(1) $errtext(1)} {$errcode(2) $errtext(2)}
                {$errcode(3) $errtext(3)} {$errcode(4) $errtext(4)}
                {$errcode(5) $errtext(5)}
            }
        }
    }
}

set trlinkx {33}
set hoack   {false}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S4F33 {
        $trlinkx {
            $hoack {
                {$errcode(1) $errtext(1)} {$errcode(2) $errtext(2)}
                {$errcode(3) $errtext(3)} {$errcode(4) $errtext(4)}
                {$errcode(5) $errtext(5)}
            }
        }
    }
}

set trlinkx {35}
secs::test {message {} S4F35 $trlinkx}

set trlinkx {37}
set hocancelack {1}
secs::test {message {} S4F37 {$trlinkx $hocancelack}}

set trlinkx {39}
secs::test {message {} S4F39 $trlinkx}

set trlinkx {41}
set hohaltack {1}
secs::test {message {} S4F41 {$trlinkx $hohaltack}}

###############################################################################
# Stream 5
###############################################################################
set altx {"error text"}
set alcd {0x80}
secs::test {message {WAIT} S5F1 {$alcd 1 $altx}}

set ack_ok {0}
secs::test {message {} S5F2 $ack_ok}

set aled {0x80}
set alid {100}
secs::test {message {WAIT} S5F3 {$aled $alid} }

set ack_ok {0}
secs::test {message {} S5F4 $ack_ok}

#
# secs::test {message {WAIT} S5F5 {$alcd $alid $altx}}
#

set alcd_(1) {0x80}
set alid_(1) {98}
set altx_(1) {"error_123456789"}
set alcd_(2) {0x80}
set alid_(2) {99}
set altx_(2) {"error: abort"}
set alcd_(3) {0x80}
set alid_(3) {100}
set altx_(3) {"error"}
secs::test {
    message {} S5F6 {
        {$alcd_(1) $alid_(1) $altx_(1)}
        {$alcd_(2) $alid_(2) $altx_(2)}
        {$alcd_(3) $alid_(3) $altx_(3)}
    }
}

secs::test {message {WAIT} S5F7 }

set alcd_(1) {0x80}
set alid_(1) {98}
set altx_(1) {"error_123456789"}
set alcd_(2) {0x80}
set alid_(2) {99}
set altx_(2) {"error: abort"}
set alcd_(3) {0x80}
set alid_(3) {100}
set altx_(3) {"error"}
secs::test {
    message {} S5F8 {
        {$alcd_(1) $alid_(1) $altx_(1)}
        {$alcd_(2) $alid_(2) $altx_(2)}
        {$alcd_(3) $alid_(3) $altx_(3)}
    }
}

######################################################################
proc get_system_time {} {
    set clockval [clock seconds]
    set date [clock format $clockval -format "%Y%m%d"]
    set time [clock format $clockval -format "%H%M%S"]
    set sys_time "$date$time"
    return $sys_time
}
######################################################################

set timestamp \"[get_system_time]\"
set exid {"1"}
#set extype {"ALARM"}
set extype {"ERROR"}
set exmessage {""}
set exrecva { {} }
secs::test {
    message {WAIT} S5F9 {$timestamp $exid $extype $exmessage $exrecva}
}

secs::test {message {} S5F10 }

set timestamp \"[get_system_time]\"
set exid {"1"}
set extype {"ALARM"}
set exmessage {""}
secs::test {
    message {WAIT} S5F11 { $timestamp $exid $extype $exmessage }
}

secs::test {message {} S5F12 }

set exid {"exception_1"}
set exrecova { "specifies a recovery action" }
secs::test {message {WAIT} S5F13 { $exid $exrecova } }

set exid {"exception_2"}
set ack { true }
set errcodex { 12 }
set errtextx { "Parameters improperly specified" }
secs::test {message {WAIT} S5F14 {$exid {$ack {$errcodex $errtextx}}}}
secs::test {message {WAIT} S5F14 {$exid {$ack {} }}}

set timestamp \"[get_system_time]\"
set exid {"exception_2"}
set ack { true }
set errcode { 12 }
set errtext { "Parameters improperly specified" }
secs::test {
    message {WAIT} S5F15 {$timestamp $exid {$ack {$errcode $errtext} } }
}
secs::test {message {WAIT} S5F15 { $timestamp $exid {$ack {} } } }

secs::test {message {WAIT} S5F16 }

set exid {"exception_2"}
secs::test {message {WAIT} S5F17 $exid }

set exid {"exception_2"}
set ack { true }
set errcode { 12 }
set errtext { "Parameters improperly specified" }
secs::test {message {WAIT} S5F18 { $exid {$ack {$errcode $errtext} } } }
secs::test {message {WAIT} S5F18 { $exid {$ack {} } } }

###############################################################################
# Stream 6
###############################################################################
set trid  {101010}
set smpln {202020}
set stime {"980712102030"}
set sv(1) {"ascii data"}
set sv(2) {1}
set sv(3) {0x22}
set sv(4) {333}
set sv(5) {4444.4444}
secs::test {
    message {WAIT} S6F1 {
        $trid $smpln $stime {$sv(1) $sv(2) $sv(3) $sv(4) $sv(5)}
    }
}

set ack_ok 0
secs::test {message {} S6F2 $ack_ok }

set dataid {9999}
set ceid   {8192}
set dsid(1) {"id_0001"}
set dsid(2) {"id_00002"}
set dsid(3) {"id_000003"}
set dsid(4) {"id_0000004"}
set dsid(5) {"id_00000005"}
set dvname(1) {"solution"}
set dvval(1) {35}
set dvname(2) {"manual"}
set dvval(2) {70}
set dvname(3) {"object"}
set dvval(3) {140}
set dvname(4) {"oriented"}
set dvval(4) {280}
set dvname(5) {"modeling"}
set dvval(5) {560}
set dvname(6) {"and"}
set dvval(6) {1120}
set dvname(7) {"design"}
set dvval(7) {2240}
set dvname(8) {"distributed"}
set dvval(8) {4480}
set dvname(9) {"computing"}
set dvval(9) {8960}
set dvname(10) {"html"}
set dvval(10) {17920}
set dvname(11) {"www"}
set dvval(11) {35840}
set dvname(12) {"active-x"}
set dvval(12) {71680}
set dvname(13) {"inside out"}
set dvval(13) {143360}
set dvname(14) {"java"}
set dvval(14) {286720}
set dvname(15) {"programing"}
set dvval(15) {573440}
secs::test {
    message {WAIT} S6F3 {
        $dataid $ceid {
            {$dsid(1) {{$dvname(1) $dvval(1)} }}
            {$dsid(2) {{$dvname(2) $dvval(2)} {$dvname(3) $dvval(3)}}}
            {$dsid(3) {{$dvname(4) $dvval(4)} {$dvname(5) $dvval(5)}
                       {$dvname(6) $dvval(6)}}}
            {$dsid(4) {{$dvname(7) $dvval(7)} {$dvname(8) $dvval(8)}
                       {$dvname(9) $dvval(9)} {$dvname(10) $dvval(10)} }}
            {$dsid(5) {{$dvname(11) $dvval(11)} {$dvname(12) $dvval(12)}
                       {$dvname(13) $dvval(13)} {$dvname(14) $dvval(14)}
                       {$dvname(15) $dvval(15)}} }
        }
    }
}

set ack_ng 1
secs::test {message {} S6F4 $ack_ng }

set dataid {777}
set datalength  {127}
secs::test {message {WAIT} S6F5 {$dataid $datalength}}

set grant6 100
secs::test {message {} S6F6 $grant6 }

set dataid {5900}
secs::test {message {WAIT} S6F7 $dataid}

set dataid {8888}
set ceid   {4096}
set dsid(1) {"id_1"}
set dsid(2) {"id_02"}
set dsid(3) {"id_003"}
set dsid(4) {"id_0004"}
set dsid(5) {"id_00005"}
set dvname(1) {"solution"}
set dvval(1) {35}
set dvname(2) {"manual"}
set dvval(2) {70}
set dvname(3) {"object"}
set dvval(3) {140}
set dvname(4) {"oriented"}
set dvval(4) {280}
set dvname(5) {"modeling"}
set dvval(5) {560}
set dvname(6) {"and"}
set dvval(6) {1120}
set dvname(7) {"design"}
set dvval(7) {2240}
set dvname(8) {"distributed"}
set dvval(8) {4480}
set dvname(9) {"computing"}
set dvval(9) {8960}
set dvname(10) {"html"}
set dvval(10) {17920}
set dvname(11) {"www"}
set dvval(11) {35840}
set dvname(12) {"active-x"}
set dvval(12) {71680}
set dvname(13) {"inside out"}
set dvval(13) {143360}
set dvname(14) {"java"}
set dvval(14) {286720}
set dvname(15) {"programing"}
set dvval(15) {573440}
secs::test {
    message {} S6F8 {
        $dataid $ceid {
            {$dsid(1) { {$dvname(1) $dvval(1)} } }
            {$dsid(2) { {$dvname(2) $dvval(2)} {$dvname(3) $dvval(3)} } }
            {$dsid(3) { {$dvname(4) $dvval(4)} {$dvname(5) $dvval(5)}
                        {$dvname(6) $dvval(6)} } }
            {$dsid(4) { {$dvname(7) $dvval(7)} {$dvname(8) $dvval(8)}
                        {$dvname(9) $dvval(9)} {$dvname(10) $dvval(10)} } }
            {$dsid(5) { {$dvname(11) $dvval(11)} {$dvname(12) $dvval(12)}
                        {$dvname(13) $dvval(13)} {$dvname(14) $dvval(14)}
                        {$dvname(15) $dvval(15)} } }
        }
    }
}

set pfcd   {0xbe}
set dataid {8888}
set ceid   {4096}
set dsid(1) {"id_1"}
set dsid(2) {"id_02"}
set dsid(3) {"id_003"}
set dsid(4) {"id_0004"}
set dsid(5) {"id_00005"}
set dvval(1) {35}
set dvval(2) {70}
set dvval(3) {140}
set dvval(4) {280}
set dvval(5) {560}
set dvval(6) {1120}
set dvval(7) {2240}
set dvval(8) {4480}
set dvval(9) {8960}
set dvval(10) {17920}
set dvval(11) {35840}
set dvval(12) {71680}
set dvval(13) {143360}
set dvval(14) {286720}
set dvval(15) {573440}
secs::test {
    message {WAIT} S6F9 {
        $pfcd $dataid $ceid {
            {$dsid(1) {$dvval(1)}}
            {$dsid(2) {$dvval(2) $dvval(3)}}
            {$dsid(3) {$dvval(4) $dvval(5) $dvval(6)}}
            {$dsid(4) {$dvval(7) $dvval(8) $dvval(9) $dvval(10)}}
            {$dsid(5) {$dvval(11) $dvval(12) $dvval(13) $dvval(14) $dvval(15)}}
        }
    }
}

set ack_ok 0
secs::test {message {} S6F4 $ack_ok }

set dataid {5550}
set ceid   {16384}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set v(1) {12}
set v(2) {24}
set v(3) {48}
set v(4) {96}
set v(5) {192}
set v(6) {384}
set v(7) {768}
set v(8) {1536}
set v(9) {3072}
set v(10) {6144}
set v(11) {12288}
set v(12) {24576}
set v(13) {49152}
set v(14) {98304}
set v(15) {196608}
secs::test {
    message {} S6F11 {
        $dataid $ceid {
            {$rptid(1) {$v(1)}}
            {$rptid(2) {$v(2) $v(3)}}
            {$rptid(3) {$v(4) $v(5) $v(6)}}
            {$rptid(4) {$v(7) $v(8) $v(9) $v(10)}}
            {$rptid(5) {$v(11) $v(12) $v(13) $v(14) $v(15)}}
        }
    }
}

set ack_ok 0
secs::test {message {} S6F12 $ack_ok }

set dataid {5525}
set ceid   {1023}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set vid(1)  {"vid_100"}
set v(1)    {12}
set vid(2)  {"vid_200"}
set v(2)    {24}
set vid(3)  {"vid_300"}
set v(3)    {48}
set vid(4)  {"vid_400"}
set v(4)    {96}
set vid(5)  {"vid_500"}
set v(5)    {192}
set vid(6)  {"vid_600"}
set v(6)    {384}
set vid(7)  {"vid_700"}
set v(7)    {768}
set vid(8)  {"vid_800"}
set v(8)    {1536}
set vid(9)  {"vid_900"}
set v(9)    {3072}
set vid(10) {"vid_1000"}
set v(10)   {6144}
set vid(11) {"vid_1100"}
set v(11)   {12288}
set vid(12) {"vid_1200"}
set v(12)   {24576}
set vid(13) {"vid_1300"}
set v(13)   {49152}
set vid(14) {"vid_1400"}
set v(14)   {98304}
set vid(15) {"vid_1500"}
set v(15)   {196608}
secs::test {
    message {} S6F13 {
        $dataid $ceid {
            {$rptid(1) {{$vid(1) $v(1)} }}
            {$rptid(2) {{$vid(2) $v(2)} {$vid(3) $v(3)} }}
            {$rptid(3) {{$vid(4) $v(4)} {$vid(5) $v(5)} {$vid(6) $v(6)}}}
            {$rptid(4) {{$vid(7) $v(7)} {$vid(8) $v(8)} {$vid(9) $v(9)}
                        {$vid(10) $v(10)}}}
            {$rptid(5) {{$vid(11) $v(11)} {$vid(12) $v(12)} {$vid(13) $v(13)}
                        {$vid(14) $v(14)} {$vid(15) $v(15)}}}
        }
    }
}

set ack_ok 0
secs::test {message {} S6F14 $ack_ok }

set ceid {12000}
secs::test {message {WAIT} S6F15 $ceid }

set dataid {5550}
set ceid   {16384}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set v(1) {12}
set v(2) {24}
set v(3) {48}
set v(4) {96}
set v(5) {192}
set v(6) {384}
set v(7) {768}
set v(8) {1536}
set v(9) {3072}
set v(10) {6144}
set v(11) {12288}
set v(12) {24576}
set v(13) {49152}
set v(14) {98304}
set v(15) {196608}
secs::test {
    message {} S6F16 {
        $dataid $ceid {
            {$rptid(1) { $v(1) } }
            {$rptid(2) { $v(2) $v(3) } }
            {$rptid(3) { $v(4) $v(5) $v(6) } }
            {$rptid(4) { $v(7) $v(8) $v(9) $v(10) } }
            {$rptid(5) { $v(11) $v(12) $v(13) $v(14) $v(15) } }
        }
    }
}

set ceid {12021}
secs::test {message {WAIT} S6F17 $ceid }

set dataid {5525}
set ceid   {1023}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set vid(1)  {"vid_100"}
set v(1)    {12}
set vid(2)  {"vid_200"}
set v(2)    {24}
set vid(3)  {"vid_300"}
set v(3)    {48}
set vid(4)  {"vid_400"}
set v(4)    {96}
set vid(5)  {"vid_500"}
set v(5)    {192}
set vid(6)  {"vid_600"}
set v(6)    {384}
set vid(7)  {"vid_700"}
set v(7)    {768}
set vid(8)  {"vid_800"}
set v(8)    {1536}
set vid(9)  {"vid_900"}
set v(9)    {3072}
set vid(10) {"vid_1000"}
set v(10)   {6144}
set vid(11) {"vid_1100"}
set v(11)   {12288}
set vid(12) {"vid_1200"}
set v(12)   {24576}
set vid(13) {"vid_1300"}
set v(13)   {49152}
set vid(14) {"vid_1400"}
set v(14)   {98304}
set vid(15) {"vid_1500"}
set v(15)   {196608}
secs::test {
    message {} S6F18 {
        $dataid $ceid {
            {$rptid(1) {{$vid(1) $v(1)}}}
            {$rptid(2) {{$vid(2) $v(2)} {$vid(3) $v(3)}}}
            {$rptid(3) {{$vid(4) $v(4)} {$vid(5) $v(5)} {$vid(6) $v(6)}}}
            {$rptid(4) {{$vid(7) $v(7)} {$vid(8) $v(8)} {$vid(9) $v(9)}
                        {$vid(10) $v(10)}}}
            {$rptid(5) {{$vid(11) $v(11)} {$vid(12) $v(12)} {$vid(13) $v(13)}
                        {$vid(14) $v(14)} {$vid(15) $v(15)}}}
        }
    }
}

set rptidx {12321}
secs::test {message {WAIT} S6F19 $rptidx }

set v(1) {12}
set v(2) {24}
set v(3) {48}
set v(4) {96}
set v(5) {192}
set v(6) {384}
set v(7) {768}
set v(8) {1536}
set v(9) {3072}
set v(10) {6144}
set v(11) {12288}
set v(12) {24576}
set v(13) {49152}
set v(14) {98304}
set v(15) {196608}
secs::test {
    message {} S6F20 {
        $v(1) $v(2) $v(3) $v(4) $v(5) $v(6) $v(7) $v(8) $v(9) $v(10)
        $v(11) $v(12) $v(13) $v(14) $v(15)
    }
}

set rptidx {23432}
secs::test {message {WAIT} S6F21 $rptidx }

set vid(1)  {"vid_100"}
set v(1)    {12}
set vid(2)  {"vid_200"}
set v(2)    {24}
set vid(3)  {"vid_300"}
set v(3)    {48}
set vid(4)  {"vid_400"}
set v(4)    {96}
set vid(5)  {"vid_500"}
set v(5)    {192}
set vid(6)  {"vid_600"}
set v(6)    {384}
set vid(7)  {"vid_700"}
set v(7)    {768}
set vid(8)  {"vid_800"}
set v(8)    {1536}
set vid(9)  {"vid_900"}
set v(9)    {3072}
set vid(10) {"vid_1000"}
set v(10)   {6144}
set vid(11) {"vid_1100"}
set v(11)   {12288}
set vid(12) {"vid_1200"}
set v(12)   {24576}
set vid(13) {"vid_1300"}
set v(13)   {49152}
set vid(14) {"vid_1400"}
set v(14)   {98304}
set vid(15) {"vid_1500"}
set v(15)   {196608}
secs::test {
    message {} S6F22 {
        {$vid(1) $v(1)} {$vid(2) $v(2)} {$vid(3) $v(3)} {$vid(4) $v(4)}
        {$vid(5) $v(5)} {$vid(6) $v(6)} {$vid(7) $v(7)} {$vid(8) $v(8)}
        {$vid(9) $v(9)} {$vid(10) $v(10)} {$vid(11) $v(11)} {$vid(12) $v(12)}
        {$vid(13) $v(13)} {$vid(14) $v(14)} {$vid(15) $v(15)}
    }
}

set rsdc {0}
secs::test {message {WAIT} S6F23 $rsdc }

set rsda {1}
secs::test {message {} S6F24 $rsda }

set dataid {1}
set opid   {98}
set linkid {20}
set rcpspec {"Recipr specifier"}
set rmchgstat {0}
set recipe_attr(1) {{"attribute_1" "attribute data"}}
set recipe_attr(2) {{"attribute_2" 1000u4}}
set recipe_attr(3) {{"attribute_3" 1000}}
set ack {1}
set error_info(1) {{10 "ERRORxxxx"}}
secs::test {
    message {WAIT} S6F25 {
        $dataid $opid $linkid $rcpspec $rmchgstat
        {$recipe_attr(1) $recipe_attr(2) $recipe_attr(3)}
        {$ack { $error_info(1) } }
    }
}
secs::test {
    message {WAIT} S6F25 {
        $dataid $opid $linkid $rcpspec $rmchgstat
        {$recipe_attr(1) $recipe_attr(2) $recipe_attr(3)}
        {$ack { } }
    }
}

set ack 0
secs::test {message {} S6F26 $ack}

set dataid {5550}
set trid   {16384}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set v(1) {12}
set v(2) {24}
set v(3) {48}
set v(4) {96}
set v(5) {192}
set v(6) {384}
set v(7) {768}
set v(8) {1536}
set v(9) {3072}
set v(10) {6144}
set v(11) {12288}
set v(12) {24576}
set v(13) {49152}
set v(14) {98304}
set v(15) {196608}
secs::test {
    message {} S6F27 {
        $dataid $trid {
        {$rptid(1) { $v(1) } }
        {$rptid(2) { $v(2) $v(3) } }
        {$rptid(3) { $v(4) $v(5) $v(6) } }
        {$rptid(4) { $v(7) $v(8) $v(9) $v(10) } }
        {$rptid(5) { $v(11) $v(12) $v(13) $v(14) $v(15) } } }
    }
}

set trid  {16384}
secs::test {message {} S6F28 $trid }

set trid  {16384}
secs::test {message {} S6F29 $trid }

set trid   {16384}
set rptid(1) {"rptid_1"}
set rptid(2) {"rptid_02"}
set rptid(3) {"rptid_003"}
set rptid(4) {"rptid_0004"}
set rptid(5) {"rptid_00005"}
set v(1) {12}
set v(2) {24}
set v(3) {48}
set v(4) {96}
set v(5) {192}
set v(6) {384}
set v(7) {768}
set v(8) {1536}
set v(9) {3072}
set v(10) {6144}
set v(11) {12288}
set v(12) {24576}
set v(13) {49152}
set v(14) {98304}
set v(15) {196608}
set errcode {15}
secs::test {
    message {} S6F30 {
        $trid {
            {$rptid(1) { $v(1) } }
            {$rptid(2) { $v(2) $v(3) } }
            {$rptid(3) { $v(4) $v(5) $v(6) } }
            {$rptid(4) { $v(7) $v(8) $v(9) $v(10) } }
            {$rptid(5) { $v(11) $v(12) $v(13) $v(14) $v(15) } }
        }
        $errcode
    }
}
secs::test {message {} S6F30 { $trid { } $errcode } }

###############################################################################
# Stream 7
###############################################################################
set ppid  { {0x19 0x98 0x07 0x13 } }
set length  {255}
secs::test {message {WAIT} S7F1 {$ppid $length }}

set ppgnt {1}
secs::test {message {} S7F2 $ppgnt }

set ppid  { {0x19 0x98 0x07 0x13 } }
set ppbody  { "secs send {message {WAIT} S7F3 $ppid $ppbody }" }
secs::test {message {WAIT} S7F3 {$ppid $ppbody }}

set ack_ok {0}
secs::test {message {} S7F4 $ack_ok }


set ppid  { "process-program" }
secs::test {message {WAIT} S7F5 $ppid }

set ppid  { "program_1" }
set ppbody { { 0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
               0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
               0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
               0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
               0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
               0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
               0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
               0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
               0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
               0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
               0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
               0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
               0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
               0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
               0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
               0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
               0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
               0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
               0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
               0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
               0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
               0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
               0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
               0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
               0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
               0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
               0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
               0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
               0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
               0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
               0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
               0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00} }
secs::test {message {} S7F6 {$ppid $ppbody} }

set mid  { {0x19 0x98 0x07 0x13 0x12 0x30 } }
secs::test {message {WAIT} S7F7 $mid }

set ppid { "recipe_abc" }
set mid  { {0x19 0x98 0x07 0x13 0x12 0x30 } }
secs::test {message {} S7F8 {$ppid $mid } }

secs::test {message {WAIT} S7F9 }

set ppidx(1) {"ProcessProgram_1"}
set ppidx(2) {"ProcessProgram_2"}
set ppidx(3) {"ProcessProgram_3"}
set midx(1) { {0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07
              0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f} }
set midx(2) { {0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17} }
set midx(3) { {0xf8 0xf9 0xfa 0xfb 0xfc 0xfd 0xfe 0xff} }
set midx(4) { "material 1" }
set midx(5) { "material 2" }
set midx(6) { "material 3" }
set midx(7) { "material all" }
secs::test {
    message {} S7F10 {
        {$ppidx(1) {$midx(1)} } {$ppidx(2) {$midx(2) $midx(3)} }
        {$ppidx(3) {$midx(4) $midx(5) $midx(6) $midx(7)} }
    }
}

set ppidx(1) {"ProcessProgram_1"}
set ppidx(2) {"ProcessProgram_2"}
set ppidx(3) {"ProcessProgram_3"}
set midx(1) { {0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07
              0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f} }
set midx(2) { {0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17} }
set midx(3) { {0xf8 0xf9 0xfa 0xfb 0xfc 0xfd 0xfe 0xff} }
set midx(4) { "material 1" }
set midx(5) { "material 2" }
set midx(6) { "material 3" }
set midx(7) { "material all" }
secs::test {
    message {WAIT} S7F11 {
        {$ppidx(1) {$midx(1)}} {$ppidx(2) {$midx(2) $midx(3)}}
        {$ppidx(3) {$midx(4) $midx(5) $midx(6) $midx(7)}}
    }
}

set ack_ok  {0}
secs::test {message {WAIT} S7F12 $ack_ok }

set ppidx(1) {"ProcessProgram_1"}
set ppidx(2) {"ProcessProgram_2"}
set ppidx(3) {"ProcessProgram_3"}
set midx(1) { {0x00 0x01 0x02 0x03 0x04 0x05 0x06 0x07
              0x08 0x09 0x0a 0x0b 0x0c 0x0d 0x0e 0x0f} }
set midx(2) { {0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17} }
set midx(3) { {0xf8 0xf9 0xfa 0xfb 0xfc 0xfd 0xfe 0xff} }
set midx(4) { "material 1" }
set midx(5) { "material 2" }
set midx(6) { "material 3" }
set midx(7) { "material all" }
secs::test {
    message {WAIT} S7F13 {
        {$ppidx(1) {$midx(1)} } {$ppidx(2) {$midx(2) $midx(3)} }
        {$ppidx(3) {$midx(4) $midx(5) $midx(6) $midx(7)} }
    }
}

set ack_ok  {0}
secs::test {message {} S7F14 $ack_ok }

set mmode  {3}
secs::test {message {WAIT} S7F15 $mmode }

set ack_ng  {1}
secs::test {message {} S7F16 $ack_ng }

set ppidx(1) {"ProcessProgram_1"}
set ppidx(2) {"ProcessProgram_2"}
set ppidx(3) {"ProcessProgram_3"}
secs::test {message {WAIT} S7F17 {$ppidx(1) $ppidx(2) $ppidx(3)} }

set ack_ok  {0}
secs::test {message {} S7F18 $ack_ok }

secs::test {message {WAIT} S7F19 }

set ppidx(1) {"ProcessProgram_1"}
set ppidx(2) {"ProcessProgram_2"}
set ppidx(3) {"ProcessProgram_3"}
secs::test {message {} S7F20 {$ppidx(1) $ppidx(2) $ppidx(3)} }

secs::test {message {WAIT} S7F21 }

set mdln {"model_number"}
set softrev {"V1R1.0"}
set cmdmax {7}
set bytmax {512}
# cmd: ccode cname rqcmd blkdef bcds ibcds nbcds acds iacds nacds
#          {pname rqpar rdflt pmax llim ulim units resc resv }
#          {pname rqpar pdflt pmax {stemp}}
set cmd(1) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 1 2 3 4 5 "0" 6 7} } }
set cmd(2) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(3) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(4) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(5) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(6) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(7) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
set cmd(8) { {0 "0" 0 0 0 0 0 0 0 0 {"0" 0 0 0 0 0 "0" 0 0} } }
##secs::test {
##    message {} S7F22 {
##        $mdln $softrev $cmdmax $bytmax
##        {$cmd(1) $cmd(2) $cmd(3) $cmd(4) $cmd(5) $cmd(6) $cmd(7) $cmd(8)}
##    }
##}

set ppid {"recipe"}
set mdln  {"model_number"}
set softrev {"V1R1.0"}
set ccode(1) {7}
set ccode(2) {14}
set ccode(3) {28}
set ccode(4) {56}
set ccode(5) {112}
set pparm(1) {"parameter:1"}
set pparm(2) {"parameter:2"}
set pparm(3) {"parameter:3"}
set pparm(4) {"parameter:4"}
set pparm(5) {"parameter:5"}
set pparm(6) {"parameter:6"}
set pparm(7) {"parameter:7"}
set pparm(8) {"parameter:8"}
set pparm(9) {"parameter:9"}
set pparm(10) {"parameter:10"}
set pparm(11) {"parameter:11"}
set pparm(12) {"parameter:12"}
set pparm(13) {"parameter:13"}
set pparm(14) {"parameter:14"}
set pparm(15) {"parameter:15"}
set pparm(16) {"parameter:16"}
secs::test {
    message {WAIT} S7F23 {
        $ppid $mdln $softrev {
            {$ccode(1) {$pparm(1) $pparm(2) $pparm(3)}}
            {$ccode(2) {$pparm(4) $pparm(5) $pparm(6) $pparm(7)}}
            {$ccode(3) {$pparm(8) $pparm(9)}}
            {$ccode(4) {$pparm(10) $pparm(11) $pparm(12) $pparm(13)
             $pparm(14)}}
            {$ccode(5) {$pparm(15)  $pparm(16)}}
        }
    }
}

set ack_ok  {0}
secs::test {message {} S7F24 $ack_ok }

set ppid {"req_recipe"}
secs::test {message {WAIT} S7F25 $ppid }

set ppid {"req_recipe"}
set mdln  {"model_number"}
set softrev {"V1R1.0"}
set ccode(1) {7}
set ccode(2) {14}
set ccode(3) {28}
set ccode(4) {56}
set ccode(5) {112}
set pparm(1) {"parameter:1"}
set pparm(2) {"parameter:2"}
set pparm(3) {"parameter:3"}
set pparm(4) {"parameter:4"}
set pparm(5) {"parameter:5"}
set pparm(6) {"parameter:6"}
set pparm(7) {"parameter:7"}
set pparm(8) {"parameter:8"}
set pparm(9) {"parameter:9"}
set pparm(10) {"parameter:10"}
set pparm(11) {"parameter:11"}
set pparm(12) {"parameter:12"}
set pparm(13) {"parameter:13"}
set pparm(14) {"parameter:14"}
set pparm(15) {"parameter:15"}
set pparm(16) {"parameter:16"}
secs::test {
    message {} S7F26 {
        $ppid $mdln $softrev {
            {$ccode(1) {$pparm(1) $pparm(2) $pparm(3)}}
            {$ccode(2) {$pparm(4) $pparm(5) $pparm(6) $pparm(7)}}
            {$ccode(3) {$pparm(8) $pparm(9)}}
            {$ccode(4) {$pparm(10) $pparm(11) $pparm(12) $pparm(13)
             $pparm(14)}}
            {$ccode(5) {$pparm(15) $pparm(16)}}
        }
    }
}


set ppid {"err_recipe"}
set errinfo(1) { {1 1 "error: illegal parameter"} }
set errinfo(2) { {0x22 2 "error: bad process code"} }
set errinfo(3) { {0x33 3 "error: process not ready"} }
secs::test {
    message {WAIT} S7F27 {$ppid {$errinfo(1) $errinfo(2) $errinfo(3)} }
}

secs::test {message {} S7F28 }

set length {1152}
secs::test {message {WAIT} S7F29 $length }

set ppgnt {3}
secs::test {message {} S7F30 $ppgnt }

set ppid {"req_recipe"}
set mdln  {"model_number"}
set softrev {"V1R1.0"}
set ccode(1) {7}
set ccode(2) {14}
set ccode(3) {28}
set ccode(4) {56}
set ccode(5) {112}
set pparm(1) {"parameter:1"}
set pparm(2) {"parameter:2"}
set pparm(3) {"parameter:3"}
set pparm(4) {"parameter:4"}
set pparm(5) {"parameter:5"}
set pparm(6) {"parameter:6"}
set pparm(7) {"parameter:7"}
set pparm(8) {"parameter:8"}
set pparm(9) {"parameter:9"}
set pparm(10) {"parameter:10"}
set pparm(11) {"parameter:11"}
set pparm(12) {"parameter:12"}
set pparm(13) {"parameter:13"}
set pparm(14) {"parameter:14"}
set pparm(15) {"parameter:15"}
set pparm(16) {"parameter:16"}
secs::test {
    message {WAIT} S7F31 {
        $ppid $mdln $softrev {
            {$ccode(1) {$pparm(1) $pparm(2) $pparm(3)}}
            {$ccode(2) {$pparm(4) $pparm(5) $pparm(6) $pparm(7)}}
            {$ccode(3) {$pparm(8) $pparm(9)}}
            {$ccode(4) {$pparm(10) $pparm(11) $pparm(12) $pparm(13)
             $pparm(14)}}
            {$ccode(5) {$pparm(15) $pparm(16)}}
        }
    }
}

set ack_ok {0}
secs::test {message {} S7F32 $ack_ok }

set ppid { {0x23 0x45 0x67 0xab} }
secs::test {message {WAIT} S7F33 $ppid }

set ppid { {0x23 0x45 0x67 0xab} }
set unflen {512}
set frmlen {512}
secs::test {message {} S7F34 {$ppid $unflen $frmlen }}

set mid {"type1_wafer"}
secs::test {message {WAIT} S7F35 $mid }

set mid   {"type1_wafer"}
set ppid  { {0x23 0x45 0x67 0xab} }
set ppbody { { 0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
               0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
               0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
               0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
               0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
               0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
               0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
               0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
               0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
               0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
               0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
               0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
               0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
               0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
               0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
               0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
               0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
               0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
               0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
               0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
               0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
               0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
               0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
               0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
               0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
               0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
               0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
               0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
               0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
               0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
               0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
               0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00} }
secs::test {message {} S7F36 {$mid $ppid $ppbody}}

###############################################################################
# Stream 8
###############################################################################
secs::test {message {WAIT} S8F1 }

set bpd { {0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
           0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
           0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
           0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
           0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
           0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
           0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
           0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
           0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
           0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
           0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
           0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
           0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
           0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
           0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
           0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
           0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
           0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
           0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
           0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
           0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
           0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
           0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
           0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
           0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
           0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
           0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
           0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
           0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
           0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
           0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
           0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00} }
secs::test {message {WAIT} S8F2 $bpd }

secs::test {message {WAIT} S8F3 }

set epd { {0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
           0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
           0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
           0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
           0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
           0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
           0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
           0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
           0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
           0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
           0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
           0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
           0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
           0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
           0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
           0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
           0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
           0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
           0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
           0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
           0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
           0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
           0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
           0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
           0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
           0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
           0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
           0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
           0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
           0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
           0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
           0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00} }
secs::test {message {WAIT} S8F4 $epd }

###############################################################################
# Stream 9
###############################################################################
set mhead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F1 $mhead}

set mhead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F3 $mhead}

set mhead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F5 $mhead}

set mhead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F7 $mhead}

set shead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F9 $shead}

set mhead { {0x80 0x33 0x44 0x00 0x00 0x00 0x00 0x00 0x00 0x00} }
secs::test {message {WAIT} S9F11 $mhead}

set mexp { "S02F03" }
set edid { "sp0001" }
secs::test {message {WAIT} S9F13 {$mexp $edid}}

###############################################################################
# Stream 10
###############################################################################
set tid { 0 }
set text {"this is test message."}
secs::test {message {WAIT} S10F1 {$tid $text}}

set ack_ok {0}
secs::test {message {} S10F2 $ack_ok}

set tid { 0 }
set text {"this is test message."}
secs::test {message {WAIT} S10F3 {$tid $text}}

set ack_ok {0}
secs::test {message {} S10F4 $ack_ok}

set tid { 0 }
set text1 {"this is the first test message."}
set text2 {"this is the middle test message."}
set text3 {"this is the last test message."}
secs::test {message {WAIT} S10F5 {$tid {$text1 $text2 $text3}} }

set ack_ok {0}
secs::test {message {} S10F6 $ack_ok}

set tid { 0 }
secs::test {message {WAIT} S10F7 $tid }

set text {"this is test message."}
secs::test {message {WAIT} S10F9 $text}

set ack_ok {0}
secs::test {message {WAIT} S10F10 $ack_ok}

###############################################################################
# Stream 11
###############################################################################

###############################################################################
# Stream 12
###############################################################################
set mid { 0 }
set idtyp {0x00}
set fnloc {355}
set ffrot {179}
set orloc {0x00}
set rpsel {1}
set refp(1) { {0 0} }
set refp(2) { {45 45} }
set refp(3) { {90 90} }
set refp(4) { {135 135} }
set dutms {"dei"}
set xdies {60}
set ydies {61}
set rowct {62}
set colct {63}
# set nulbc {{1 9 46 92 55}}
set nulbc {"000000000000000100000000100000000000000100000000001"}
set prdct {3100}
set praxi {5}
secs::test {
    message {WAIT} S12F1 {
        $mid $idtyp $fnloc $ffrot $orloc $rpsel
        {$refp(1) $refp(2) $refp(3) $refp(4)}
        $dutms $xdies $ydies $rowct $colct $nulbc $prdct $praxi
    }
}

set ack_ok {0}
secs::test {message {} S12F2 $ack_ok}

set mid { 0 }
set idtyp {0x00}
set mapft {0x01}
set fnloc {355}
set ffrot {179}
set orloc {0x00}
set praxi {5}
set bcequ {1}
# set nulbc {{1 9 46 92 55}}
set nulbc {"000000000000000100000000100000000000000100000000001"}
secs::test {
    message {WAIT} S12F3 {
        $mid $idtyp $mapft $fnloc $ffrot $orloc $praxi $bcequ $nulbc
    }
}

set mid { 0 }
set idtyp {0x00}
set fnloc {355}
set orloc {0x00}
set rpsel {1}
set refp(1) { {0 0} }
set refp(2) { {45 45} }
set refp(3) { {90 90} }
set refp(4) { {135 135} }
set dutms {"dei"}
set xdies {60}
set ydies {61}
set rowct {62}
set colct {63}
set prdct {3100}
set bcequ {1}
# set nulbc {{1 9 46 92 55}}
set nulbc {"000000000000000100000000100000000000000100000000001"}
set mlcl {80}
secs::test {
    message {} S12F4 {
        $mid $idtyp $fnloc $orloc $rpsel
        {$refp(1) $refp(2) $refp(3) $refp(4)}
        $dutms $xdies $ydies $rowct $colct $prdct $bcequ $nulbc $mlcl
    }
}

set mid { 0 }
set idtyp {0x00}
set mapft {0x01}
set mlcl {80}
secs::test {message {WAIT} S12F5 {$mid $idtyp $mapft $mlcl} }

set grnt1 {0}
secs::test {message {} S12F6 $grnt1 }

set mid     { 0 }
set idtyp    {0x00}
set rsinf(1) {1}
set binlt(1) {80}
set rsinf(2) {2}
set binlt(2) {90}
set rsinf(3) {3}
set binlt(3) {100}
set rsinf(4) {4}
set binlt(4) {110}
set rsinf(5) {5}
set binlt(5) {120}
secs::test {
    message {WAIT} S12F7 {
        $mid $idtyp {
            {$rsinf(1) $binlt(1)} {$rsinf(2) $binlt(2)}
            {$rsinf(3) $binlt(3)} {$rsinf(4) $binlt(4)}
            {$rsinf(5) $binlt(5)}
        }
    }
}

set ack_ok {0}
secs::test {message {} S12F8 $ack_ok }


set mid     { 0 }
set idtyp    {0x00}
set strp_x   {2000}
set strp_y   {3000}
set binlt(1) {80}
secs::test {
    message {WAIT} S12F9 {$mid $idtyp {$strp_x $strp_y} $binlt(1)}
}

set ack_ok   {0x00}
secs::test {message {} S12F10 $ack_ok }

set mid     { 0 }
set idtyp    {0x00}
set strpx(1) {2000}
set strpy(1) {3000}
set binlt(1) {80}
set strpx(2) {2001}
set strpy(2) {3001}
set binlt(2) {81}
set strpx(3) {2002}
set strpy(3) {3002}
set binlt(3) {82}
secs::test {
    message {WAIT} S12F11 {
        $mid $idtyp {
            { {$strpx(1) $strpy(1)} $binlt(1)}
            { {$strpx(2) $strpy(2)} $binlt(2)}
            { {$strpx(3) $strpy(3)} $binlt(3)}
        }
    }
}

set ack_ok   {0x00}
secs::test {message {} S12F12 $ack_ok }

set mid     { 0 }
set idtyp    {0x00}
secs::test {message {WAIT} S12F13 {$mid $idtyp }}

set mid      { 0 }
set idtyp     {0x00}
set rsinfx(1) {2000}
set rsinfy(1) {3000}
set rsinfd(1) {4000}
set binlt(1)  {80}
set rsinfx(2) {2001}
set rsinfy(2) {3001}
set rsinfd(2) {4001}
set binlt(2)  {81}
set rsinfx(3) {2002}
set rsinfy(3) {3002}
set rsinfd(3) {4002}
set binlt(3)  {82}
secs::test {
    message {} S12F14 {
        $mid $idtyp {
            { {$rsinfx(1) $rsinfy(1) $rsinfd(1)} $binlt(1)}
            { {$rsinfx(2) $rsinfy(2) $rsinfd(2)} $binlt(2)}
            { {$rsinfx(3) $rsinfy(3) $rsinfd(3)} $binlt(3)}
        }
    }
}

set mid  { 0 }
set idtyp {0x00}
secs::test {message {WAIT} S12F15 {$mid $idtyp} }

set mid     { 0 }
set idtyp    {0x00}
set strp_x   {2000}
set strp_y   {3000}
set binlt(1) {80}
secs::test {message {} S12F16 {$mid $idtyp {$strp_x $strp_y} $binlt(1)} }

set mid  { 0 }
set idtyp {0x00}
set sdbin {100}
secs::test {message {WAIT} S12F17 { $mid $idtyp $sdbin } }

set mid     { 0 }
set idtyp    {0x00}
set strpx(1) {2000}
set strpy(1) {3000}
set binlt(1) {80}
set strpx(2) {2001}
set strpy(2) {3001}
set binlt(2) {81}
set strpx(3) {2002}
set strpy(3) {3002}
set binlt(3) {82}
secs::test {
    message {} S12F18 {
        $mid $idtyp {
            {{$strpx(1) $strpy(1)} $binlt(1)}
            {{$strpx(2) $strpy(2)} $binlt(2)}
            {{$strpx(3) $strpy(3)} $binlt(3)}
        }
    }
}

set maper {10}
set datlc {20}
secs::test {message {} S12F19 {$maper $datlc} }


###############################################################################
# Stream 13
###############################################################################
set dsname {"command.com"}
secs::test {message {WAIT} S13F1 {$dsname} }

set dsname {"command.com"}
set ack_ok {0}
secs::test {message {} S13F2 {$dsname $ack_ok}}

set handle {1}
set dsname {"command.com"}
set ckpnt  {1000000}
secs::test {message {WAIT} S13F3 {$handle $dsname $ckpnt} }

set handle {1}
set dsname {"command.com"}
set ack_ok {0}
set rtype  {0}
set reclen {512}
secs::test {message {} S13F4 {$handle $dsname $ack_ok $rtype $reclen} }

set handle {1}
set reclen {512}
secs::test {message {WAIT} S13F5 {$handle $reclen} }

set handle {1}
set ack_ok {0}
set ckpnt  {1000000}
set fildat(1) {"set handle {1}; set ack_ok {0}; set ckpnt  {1000000}; secs::test {message {} S13F6 {$handle $ack_ok $ckpnt} }; "}
set fildat(2) { {0xFF 0xFE 0xFD 0xFC 0xFB 0xFA 0xF9 0xF8
                 0xF7 0xF6 0xF5 0xF4 0xF3 0xF2 0xF1 0xF0
                 0xEF 0xEE 0xED 0xEC 0xEB 0xEA 0xE9 0xE8
                 0xE7 0xE6 0xE5 0xE4 0xE3 0xE2 0xE1 0xE0
                 0xDF 0xDE 0xDD 0xDC 0xDB 0xDA 0xD9 0xD8
                 0xD7 0xD6 0xD5 0xD4 0xD3 0xD2 0xD1 0xD0
                 0xCF 0xCE 0xCD 0xCC 0xCB 0xCA 0xC9 0xC8
                 0xC7 0xC6 0xC5 0xC4 0xC3 0xC2 0xC1 0xC0
                 0xBF 0xBE 0xBD 0xBC 0xBB 0xBA 0xB9 0xB8
                 0xB7 0xB6 0xB5 0xB4 0xB3 0xB2 0xB1 0xB0
                 0xAF 0xAE 0xAD 0xAC 0xAB 0xAA 0xA9 0xA8
                 0xA7 0xA6 0xA5 0xA4 0xA3 0xA2 0xA1 0xA0
                 0x9F 0x9E 0x9D 0x9C 0x9B 0x9A 0x99 0x98
                 0x97 0x96 0x95 0x94 0x93 0x92 0x91 0x90
                 0x8F 0x8E 0x8D 0x8C 0x8B 0x8A 0x89 0x88
                 0x87 0x86 0x85 0x84 0x83 0x82 0x81 0x80
                 0x7F 0x7E 0x7D 0x7C 0x7B 0x7A 0x79 0x78
                 0x77 0x76 0x75 0x74 0x73 0x72 0x71 0x70
                 0x6F 0x6E 0x6D 0x6C 0x6B 0x6A 0x69 0x68
                 0x67 0x66 0x65 0x64 0x63 0x62 0x61 0x60
                 0x5F 0x5E 0x5D 0x5C 0x5B 0x5A 0x59 0x58
                 0x57 0x56 0x55 0x54 0x53 0x52 0x51 0x50
                 0x4F 0x4E 0x4D 0x4C 0x4B 0x4A 0x49 0x48
                 0x47 0x46 0x45 0x44 0x43 0x42 0x41 0x40
                 0x3F 0x3E 0x3D 0x3C 0x3B 0x3A 0x39 0x38
                 0x37 0x36 0x35 0x34 0x33 0x32 0x31 0x30
                 0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28
                 0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20
                 0x1F 0x1E 0x1D 0x1C 0x1B 0x1A 0x19 0x18
                 0x17 0x16 0x15 0x14 0x13 0x12 0x11 0x10
                 0x0F 0x0E 0x0D 0x0C 0x0B 0x0A 0x09 0x08
                 0x07 0x06 0x05 0x04 0x03 0x02 0x01 0x00} }
set fildat(3) {"0x2F 0x2E 0x2D 0x2C 0x2B 0x2A 0x29 0x28 0x27 0x26 0x25 0x24 0x23 0x22 0x21 0x20"}
secs::test {
    message {} S13F6 {
        $handle $ack_ok $ckpnt {$fildat(1) $fildat(2) $fildat(3)}
    }
}

set handle {1}
secs::test {message {WAIT} S13F7 {$handle} }

set handle {1}
set ack_ok {0}
secs::test {message {} S13F8 {$handle $ack_ok}}

secs::test {message {WAIT} S13F9 }
secs::test {message {} S13F10 }

set dataid {1}
set objspec {"CObject::CObject"}
set datalength {100}
secs::test {message {} S13F11 {$dataid $objspec $datalength}}

set grant {0x00}
secs::test {message {WAIT} S13F12 $grant }

set dataid {1010}
set objspec {"http://member.nifty.ne.jp/BEE/"}
set tbltyp {"excel"}
set tblid {"table-001"}
set tblcmd {0}
set attrid(1) { {1 "name" } }
set attrid(2) { {2 "type" } }
set attrid(3) { {3 "value" } }
set colhdr(1) {"name"}
set colhdr(2) {"type"}
set colhdr(3) {"value"}
set tblelt(1) { {"display" "INTEGER" 1} }
set tblelt(2) { {"cpu" "INTEGER" 10} }
set tblelt(3) { {"keyboard" "INTEGER" 100} }
set tblelt(4) { {"mouse" "INTEGER" 1000} }
set tblelt(5) { {"cdrom" "INTEGER" 10000} }
secs::test {message {WAIT} S13F13 {
    $dataid $objspec $tbltyp $tblid $tblcmd
    { $attrid(1) $attrid(2) $attrid(3) }
    { $colhdr(1) $colhdr(2) $colhdr(3) }
    { $tblelt(1) $tblelt(2) $tblelt(3) $tblelt(4) $tblelt(5) } }
}

set tblack {1}
set errorx(1) {{3002 "illegal name"}}
set errorx(2) {{1107 "overflow"}}
set errorx(3) {{9070 "type undefine"}}
secs::test {message {} S13F14 { $tblack {$errorx(1) $errorx(2) $errorx(3)} }}

set dataid {1010}
set objspec {"http://member.nifty.ne.jp/BEE/"}
set tbltyp {"excel"}
set tblid {"table-001"}
set tblcmd {0}
set colhdr(1) {"name"}
set colhdr(2) {"type"}
set colhdr(3) {"value"}
set tblelt(1) { "display" }
set tblelt(2) { "cpu" }
set tblelt(3) { "keyboard" }
set tblelt(4) { "mouse" }
set tblelt(5) { "cdrom" }
secs::test {message {WAIT} S13F15 {
    $dataid $objspec $tbltyp $tblid $tblcmd
    { $colhdr(1) $colhdr(2) $colhdr(3) }
    { $tblelt(1) $tblelt(2) $tblelt(3) $tblelt(4) $tblelt(5) } }
}

set dataid {1010}
set objspec {"http://member.nifty.ne.jp/BEE/"}
set tbltyp {"excel"}
set tblid {"table-001"}
set tblcmd {0}
set attrid(1) { {1 "name" } }
set attrid(2) { {2 "type" } }
set attrid(3) { {3 "value" } }
set colhdr(1) {"name"}
set colhdr(2) {"type"}
set colhdr(3) {"value"}
set tblelt(1) { {"display" "INTEGER" 1} }
set tblelt(2) { {"cpu" "INTEGER" 10} }
set tblelt(3) { {"keyboard" "INTEGER" 100} }
set tblelt(4) { {"mouse" "INTEGER" 1000} }
set tblelt(5) { {"cdrom" "INTEGER" 10000} }
set tblack {1}
set errorx(1) {{3002 "illegal name"}}
set errorx(2) {{1107 "overflow"}}
set errorx(3) {{9070 "type undefine"}}
secs::test {message {} S13F16 {
    $tbltyp $tblid
    { $attrid(1) $attrid(2) $attrid(3) }
    { $colhdr(1) $colhdr(2) $colhdr(3) }
    { $tblelt(1) $tblelt(2) $tblelt(3) $tblelt(4) $tblelt(5) }
    { $tblack {$errorx(1) $errorx(2) $errorx(3)} } }
}

###############################################################################
# Stream 14
###############################################################################
set objspec {"BEEObject"}
set objtype {"base"}
set objid(1) {10001}
set objid(2) {10002}
set objid(3) {10003}
set objid(4) {10004}
set attrid(1) {"m_name"}
set attrdata(1) {"obj_a"}
set attrlen     {0}
set attrid(2)   {"m_size"}
set attrdata(2) {128}
set attrid(3)   {"m_time"}
set attrdata(3) {"19980707123456"}
secs::test {
    message {WAIT} S14F1 {
        $objspec $objtype {$objid(1) $objid(2) $objid(3) $objid(4)} {
            {$attrid(1) $attrdata(1) $attrlen} {$attrid(2) $attrdata(2)
             $attrlen}
            {$attrid(3) $attrdata(3) $attrlen}
        }
        {$attrid(1) $attrid(2) $attrid(3)}
    }
}
secs::test {
    message {WAIT} S14F1 {$objspec $objtype {} {{1 2 3}} {}}
}


set objid(1) {10001}
set objid(2) {10002}
set objid(3) {10003}
set attrid(1)   {"m_name"}
set attrdata(1) {"obj_a"}
set attrid(2)   {"m_size"}
set attrdata(2) {128}
set attrid(3)   {"m_time"}
set attrdata(3) {"19980707123456"}
set ack_ok     {0}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S14F2 {
        { {$objid(1) { {$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                       {$attrid(3) $attrdata(3)} } }
          {$objid(2) { {$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                       {$attrid(3) $attrdata(3)} } }
          {$objid(3) { {$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                       {$attrid(3) $attrdata(3)} } }
        }
        {$ack_ok {
            {$errcode(1) $errtext(1)} {$errcode(2) $errtext(2)}
            {$errcode(3) $errtext(3)} {$errcode(4) $errtext(4)}
            {$errcode(5) $errtext(5)} }
        }
    }
}

set objspec  {"BEEObject"}
set objtype  {"base"}
set objid(1) {10001}
set objid(2) {10002}
set objid(3) {10003}
set objid(4) {10004}
set attrid(1) {"m_name"}
set attrdata(1) {"obj_a"}
set attrid(2)   {"m_size"}
set attrdata(2) {128}
set attrid(3)   {"m_time"}
set attrdata(3) {"19980707123456"}
secs::test {
    message {WAIT} S14F3 {
        $objspec $objtype {$objid(1) $objid(2) $objid(3) $objid(4)} {
            {$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
            {$attrid(3) $attrdata(3) }
        }
    }
}

set objid(1) {10001}
set objid(2) {10002}
set objid(3) {10003}
set attrid(1) {"m_name"}
set attrdata(1) {"obj_a"}
set attrid(2)   {"m_size"}
set attrdata(2) {128}
set attrid(3)   {"m_time"}
set attrdata(3) {"19980707123456"}
set ack_ok {0}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {WAIT} S14F4 {
        { {$objid(1) {{$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                      {$attrid(3) $attrdata(3)}} }
          {$objid(2) {{$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                      {$attrid(3) $attrdata(3)}} }
          {$objid(3) {{$attrid(1) $attrdata(1)} {$attrid(2) $attrdata(2)}
                      {$attrid(3) $attrdata(3)}} }
        }
        {$ack_ok {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) } }
        }
    }
}

set objspec {"BEEObject"}
secs::test {message {WAIT} S14F5 $objspec }

set objtypex(1) {10001}
set objtypex(2) {10002}
set objtypex(3) {10003}
set ack_ok {0}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S14F6 {
        {$objtypex(1) $objtypex(2) $objtypex(3) }
        {$ack_ok {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) } }
        }
    }
}

set objspec {"BEEObject"}
set objtypex(1) {10001}
set objtypex(2) {10002}
set objtypex(3) {10003}
secs::test {
    message {WAIT} S14F7 {$objspec {$objtypex(1) $objtypex(2) $objtypex(3)} }
}

set objtypex(1) {10001}
set objtypex(2) {10002}
set objtypex(3) {10003}
set attrid(1)  {"m_name"}
set attrid(2)  {"m_size"}
set attrid(3)  {"m_address"}
set attrid(4)  {"m_operation"}
set attrid(5)  {"m_dir"}
set attrid(6)  {"m_parm1"}
set attrid(7)  {"m_parm2"}
set attrid(8)  {"m_parm3"}
set attrid(9)  {"m_parm4"}
set ack_ok     {0}
set errcode(1) {1}
set errtext(1) {"error_1"}
set errcode(2) {2}
set errtext(2) {"error_2"}
set errcode(3) {3}
set errtext(3) {"error_3"}
set errcode(4) {4}
set errtext(4) {"error_4"}
set errcode(5) {5}
set errtext(5) {"error_5"}
secs::test {
    message {} S14F8 {
        { {$objtypex(1) {$attrid(1)} }
          {$objtypex(2) {$attrid(2) $attrid(3) $attrid(4)} }
          {$objtypex(3) {$attrid(5) $attrid(6) $attrid(7)
                        $attrid(8) $attrid(9)}}
        }
        {$ack_ok {
            {$errcode(1) $errtext(1) } {$errcode(2) $errtext(2) }
            {$errcode(3) $errtext(3) } {$errcode(4) $errtext(4) }
            {$errcode(5) $errtext(5) } }
        }
    }
}

set objtype {"base"}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
secs::test {
    message {WAIT} S14F9 {
        $objspec $objtype {$attr_info(1) $attr_info(2) $attr_info(3)}
    }
}

set objspec {"BEEObject"}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
set objack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {WAIT} S14F10 {
        $objspec
        {$attr_info(1) $attr_info(2) $attr_info(3)}
        {$objack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set objspec {"Class:Object>"}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
secs::test {
    message {WAIT} S14F11 {
        $objspec {$attr_info(1) $attr_info(2) $attr_info(3)}
    }
}

set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
set objack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {WAIT} S14F12 {
        {$attr_info(1) $attr_info(2) $attr_info(3)}
        {$objack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set objspec {"Class:Object>"}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
secs::test {
    message {WAIT} S14F13 {
        $objspec
        {$attr_info(1) $attr_info(2) $attr_info(3)}
    }
}

set objtoken {1234}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
set objack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {WAIT} S14F14 {
        $objtoken
        {$attr_info(1) $attr_info(2) $attr_info(3)}
        {$objack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set objspec {"Class:Object>"}
set objcmd {55}
set objtoken {4321}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
secs::test {
    message {WAIT} S14F15 {
        $objspec $objcmd $objtoken {$attr_info(1) $attr_info(2) $attr_info(3)}
    }
}

set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
set objack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {WAIT} S14F16 {
        {$attr_info(1) $attr_info(2) $attr_info(3)}
        {$objack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set objspec {"Class:Object>"}
set objcmd {55}
set targetspec {"target"}
set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
secs::test {
    message {WAIT} S14F17 {
        $objspec $objcmd $targetspec
        {$attr_info(1) $attr_info(2) $attr_info(3)}
    }
}

set attr_info(1) {{"m_name" "obj_a"}}
set attr_info(2) {{"m_size" 128}}
set attr_info(3) {{"m_time" "19980707123456"}}
set objack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {WAIT} S14F18 {
        {$attr_info(1) $attr_info(2) $attr_info(3)}
        {$objack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

###############################################################################
# Stream 15
###############################################################################
set dataid     {10001}
set rcpspec    {"BEEObject"}
set rmdatasize {789}
secs::test {message {WAIT} S15F1 {$dataid $rcpspec $rmdatasize} }

set rmgrnt {0}
secs::test {message {} S15F2 $rmgrnt }

set rmnsspec   {"Class:BEEObject>"}
set rmnscmd    {7}
secs::test {message {WAIT} S15F3 {$rmnsspec $rmnscmd} }

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {} S15F4 { $rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set rmnsspec   {"Class:BEEObject>"}
set rmnewns    {"Class:BEESubject>"}
secs::test {message {WAIT} S15F5 {$rmnsspec $rmnewns} }

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
set err_info(4) {{4 "error_4"}}
set err_info(5) {{5 "error_5"}}
secs::test {
    message {} S15F6 { $rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set objspec   {"Class:BEEObject>"}
secs::test {message {WAIT} S15F7 $objspec }

set rmspace     {6741}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F8 {
        $rmspace { $rmack {$err_info(1) $err_info(2) $err_info(3)} }
    }
}

set rcpspec   {"Class:BEEObject>"}
secs::test {message {WAIT} S15F9 $rcpspec }

set rcpstat     {8}
set rcpvers     {"1.9.98"}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F10 {
        $rcpstat $rcpvers {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
    }
}

set rmnsspec    {"Class:BEEObject>"}
set rcpclass    {"egg"}
set rcpname     {"omelette"}
set agent       {"agent000x"}
secs::test {message {WAIT} S15F11 {$rmnsspec $rcpclass $rcpname $agent} }

set agent       {"agent000x"}
set rcpvers     {"1.9.98"}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F12 {
        $agent $rcpvers {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set dataid     {10001}
set rcpupdt    {true}
set rcpspec    {"Class:BEEObject>"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rcpbody    {"****** recipe data ******"}
secs::test {
    message {WAIT} S15F13 {
        $dataid $rcpupdt $rcpspec
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)}
    }
}
secs::test {
    message {WAIT} S15F13 {
        $dataid $rcpupdt $rcpspec
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)}
        $rcpbody
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F14 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid     {10001}
set rcpspec    {"Class:BEEObject>"}
set rcpseccode {0x03}
set rcpbody    {"****** recipe data ******"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rcpattr_info(4) {{"recipe attribute 1" 200000}}
set rcpattr_info(5) {{"recipe attribute 2" 300000}}
set rcpattr_info(6) {{"recipe attribute 3" 400000}}
set rcpattr_info(7) {{"recipe attribute 4" 500000}}
set rcpsecnm(1) {"recipe_1"}
set rcpsecnm(2) {"recipe_2"}
set rcpsecnm(3) {"recipe_3"}
set rcpsecnm(4) {"recipe_4"}
secs::test {
    message {WAIT} S15F15 {
        $dataid $rcpspec $rcpseccode {
            {$rcpsecnm(1) {$rcpattr_info(1) $rcpattr_info(2)
                           $rcpattr_info(3)} }
            $rcpbody {
                {$rcpsecnm(2) {$rcpattr_info(4)}}
                {$rcpsecnm(3) {$rcpattr_info(5) $rcpattr_info(6)}}
                {$rcpsecnm(4) {$rcpattr_info(7) $rcpattr_info(1)
                               $rcpattr_info(2)}}
            }
        }
    }
}

set rcpseccode {0x03}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F16 {
        $rcpseccode {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
    }
}

set rcpspec    {"Class:BEEObject>"}
set rcpseccode {0x03}
secs::test {message {WAIT} S15F17 {$rcpspec $rcpseccode } }

set rcpbody    {"****** recipe data ******"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rcpattr_info(4) {{"recipe attribute 1" 200000}}
set rcpattr_info(5) {{"recipe attribute 2" 300000}}
set rcpattr_info(6) {{"recipe attribute 3" 400000}}
set rcpattr_info(7) {{"recipe attribute 4" 500000}}
set rcpsecnm(1) {"recipe_1"}
set rcpsecnm(2) {"recipe_2"}
set rcpsecnm(3) {"recipe_3"}
set rcpsecnm(4) {"recipe_4"}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F18 {
        { {$rcpsecnm(1) {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)} }
          $rcpbody
          {{$rcpsecnm(2) {$rcpattr_info(4)}}
           {$rcpsecnm(3) {$rcpattr_info(5) $rcpattr_info(6)}}
           {$rcpsecnm(4) {$rcpattr_info(7) $rcpattr_info(1) $rcpattr_info(2)}}
          }
        }
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set rcpspec    {"Class:BEEObject>"}
set rcprename  {false}
set rcpnewid   {"R100-23"}
secs::test {message {WAIT} S15F19 {$rcpspec $rcprename $rcpnewid}}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F20 {
        $rmack {$err_info(1) $err_info(2) $err_info(3)}
    }
}

set dataid     {7777}
set rcpcmd     {15}
set rmnsspec   {"Class:BEEObject>"}
set opid       {88}
set agent      {"R100-23"}
set rcpid_list {{"recipe-1" "recipe-2" "recipe-3" "recipe-4" \
                 "recipe-5" "recipe-6" "recipe-7"}}
secs::test {
    message {WAIT} S15F21 {
        $dataid $rcpcmd $rmnsspec $opid $agent $rcpid_list
    }
}

set agent       {"AGENT"}
set linkid      {3333}
set rcpcmd      {9}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F22 {
        $agent $linkid $rcpcmd
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set dataid     {7777}
set objspec    {"Class:BEEObject>"}
set rcpid_list {{"recipe-1" "recipe-2" "recipe-3" "recipe-4" \
                 "recipe-5" "recipe-6" "recipe-7"}}
secs::test {message {WAIT} S15F23 {$dataid $objspec $rcpid_list}}

set recipe_desc(1) {{"ASDesc" "1998112312345600" 1024}}
set recipe_desc(2) {{"BodyDesc" "1998102308091000" 65535}}
set recipe_desc(3) {{"GenDesc" "1998102910000000" 4096}}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F24 {
        { {$recipe_desc(1) $recipe_desc(2)}
          {$recipe_desc(1) $recipe_desc(2) $recipe_desc(3)} }
        { $rmack {$err_info(1) $err_info(2) $err_info(3)} }
    }
}

set dataid     {7777}
set rmnsspec   {"Class:BEEObject>"}
set agent      {"AGENT-@@@"}
set recipe_parm(1) {{"parameter-1" "value" "append"}}
set recipe_parm(2) {{"parameter-2" 65535 "AND"}}
set recipe_parm(3) {{"parameter-3" 4096 "/* comment */"}}
secs::test {
    message {WAIT} S15F25 {
        $dataid $rmnsspec $agent
        {$recipe_parm(1) $recipe_parm(2) $recipe_parm(3)}
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F26 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid     {10001}
set rcpowcode  {true}
set rcpspec    {"Class:BEEObject>"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rcpbody    {"****** recipe data ******"}
secs::test {
    message {WAIT} S15F27 {
        $dataid $rcpowcode $rcpspec
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)} $rcpbody
    }
}

set rcpid {"RECIPE-001"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F28 {
        $rcpid
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)}
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set dataid {7777}
set opid   {24}
set respec {"Class:BEEObject>"}
set rcpid_list {{"recipe-1" "recipe-2" "recipe-3" "recipe-4" "recipe-5" "recipe-6" "recipe-7"}}
secs::test {
    message {WAIT} S15F29 {$dataid $opid $respec $rcpid_list}
}

set opid   {24}
set linkid {101}
set rcpid  {"RECIPE-001"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F30 {
        $opid $linkid $rcpid
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)}
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set rcpspec {"Class:BEEObject>"}
secs::test {message {WAIT} S15F31 $rcpspec }

set rcpspec    {"Class:BEEObject>"}
set rcpattr_info(1) {{"baking_temperature" 1200}}
set rcpattr_info(2) {{"baking_time" "0:10:30"}}
set rcpattr_info(3) {{"cooling_time" "0:05:00"}}
set rcpbody    {"****** recipe data ******"}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F32 {
        $rcpspec
        {$rcpattr_info(1) $rcpattr_info(2) $rcpattr_info(3)}
        $rcpbody
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set dataid {7777}
set respec {"Class:BEEObject>"}
set rcpparm(1) {{"baking_temperature" 1200}}
set rcpparm(2) {{"baking_time" "0:10:30"}}
set rcpparm(3) {{"cooling_time" "0:05:00"}}
set rcpparm(4) {{"recipe attribute 1" 200000}}
set rcpparm(5) {{"recipe attribute 2" 300000}}
set rcpparm(6) {{"recipe attribute 3" 400000}}
set rcpparm(7) {{"recipe attribute 4" 500000}}
secs::test {
    message {WAIT} S15F33 {
        $dataid $respec {
            {"RECIPE-1" {$rcpparm(1)}}
            {"RECIPE-2" {$rcpparm(2) $rcpparm(3)}}
            {"RECIPE-3" {$rcpparm(4) $rcpparm(5) $rcpparm(6) $rcpparm(7)}}
        }
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F34 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid {7777}
set respec {"Class:BEEObject>"}
set rcpdel {0}
set rcpid_list {{"recipe-1" "recipe-2" "recipe-3" "recipe-4" \
                 "recipe-5" "recipe-6" "recipe-7"}}
secs::test {
    message {WAIT} S15F35 {$dataid $respec $rcpdel $rcpid_list }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F36 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set rmsegspec  {"Class:BEEObject>"}
set objtoken   {7777}
set rmgrnt     {0}
set opid       {24}
set rcpid      {"RECIPE-001"}
set rmchgtype  {10}
secs::test {
    message {WAIT} S15F37 {
        $rmsegspec $objtoken $rmgrnt $opid $rcpid $rmchgtype
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F38 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid     {345}
set rmnscmd    {5}
set rmrecspec  {"Recorder:rec999999>"}
set rmsegspec  {"Class:BEEObject>"}
set objtoken   {7777}
secs::test {
    message {WAIT} S15F39 {$dataid $rmnscmd $rmrecspec $rmsegspec $objtoken}
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F40 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid     {345}
set rmrecspec  {"Recorder:rec999999>"}
set objtoken   {7777}
set rmnscmd    {0}
set rcpid      {"RECIPE-001"}
set rcpnewid   {"NEWRECIPE-001"}
set rmsegspec  {"Class:BEEObject>"}
set rmchgtype  {10}
set opid       {24}
set timestamp  {"1998110210111299"}
set rmrequestor {true}
secs::test {
    message {WAIT} S15F41 {
        $dataid $rmrecspec $objtoken $rmnscmd
        {$rcpid $rcpnewid $rmsegspec $rmchgtype $opid $timestamp $rmrequestor}
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F42 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

set dataid     {7777}
set objspec    {"Class:BEEObject>"}
set targetspec {"Class:TargetObject>"}
secs::test {message {WAIT} S15F43 {$dataid $objspec $targetspec} }

set record_info(1) {{"RECIPE-001" "NEWRECIPE-1" "Class:BEEObject>" \
                     10 24 "1998110210111299" true}}
set record_info(2) {{"RECIPE-002" "NEWRECIPE-2" "Class:BEEObject>" \
                     10 25 "1998110210111299" true}}
set record_info(3) {{"RECIPE-003" "NEWRECIPE-3" "Class:BEEObject>" \
                     10 26 "1998110210111299" false}}
set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F44 {
        {$record_info(1) $record_info(2) $record_info(3)}
        {$rmack {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

set dataid     {345}
set rcpspec    {"Class:BEEObject>"}
set rcpnewid   {"RECIPE-001"}
set rmchgtype  {10}
secs::test {message {WAIT} S15F45 {$dataid $rcpspec $rcpnewid $rmchgtype} }

set rmchgtype  {10}
set rmgrnt     {0x2}
set opid       {51}
secs::test {message {} S15F46 {$rmchgtype $rmgrnt $opid} }

set dataid     {345}
set objspec    {"Class:BEEObject>"}
set rmnsspec   {"Namespace:Recipe>"}
set rmrecspec  {"Recorder:rec999999>"}
set rmsegspec_list {{"Segment:Object1>" "Segment:Object2>" "Segment:Object3>"}}
secs::test {
    message {WAIT} S15F47 {
        $dataid $objspec $rmnsspec $rmrecspec $rmsegspec_list
    }
}

set rmack {0}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S15F48 {$rmack {$err_info(1) $err_info(2) $err_info(3)} }
}

###############################################################################
# Stream 16
###############################################################################
secs::test {message {} S16F0 }

set dataid     {10001}
set datalength {1023U8}
secs::test {message {WAIT} S16F1 {$dataid $datalength} }

set grant {0}
secs::test {message {} S16F2 $grant }

set dataid     {10001}
set mf         {0}
set mid_list   {{"MID0001" "MID0002" "MID0003" "MID0004" "MID0005"}}
set prrecipemethod    {1001}
set rcpspec    {"Recipe:Salad>"}
set rcpparm(1) {{"baking_temperature" 1200}}
set rcpparm(2) {{"baking_time" "0:10:30"}}
set prprocessstart    {true}
secs::test {
    message {WAIT} S16F3 {
        $dataid $mf $mid_list
        {$prrecipemethod $rcpspec {$rcpparm(1) $rcpparm(2)} }
        $prprocessstart
    }
}

set prjobid     {"JOB(999)"}
set acka        {true}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S16F4 {
        $prjobid {$acka {$err_info(1) $err_info(2) $err_info(3)} }
    }
}
secs::test {message {} S16F4 {$prjobid {$acka {}} } }

set dataid     {10001}
set prjobid    {"JOB(999)"}
set prcmdname  {"START"}
set cmdparm(1) {{"baking_temperature" 1200}}
set cmdparm(2) {{"baking_time" "0:10:30"}}
set cmdparm(3) {{"rpm" "1000"}}
set prprocessstart    {true}
secs::test {
    message {WAIT} S16F5 {
        $dataid $prjobid $prcmdname {$cmdparm(1) $cmdparm(2) $cmdparm(3)}
    }
}

set prjobid     {"JOB(999)"}
set acka        {true}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {} S16F6 {
        $prjobid { $acka {$err_info(1) $err_info(2) $err_info(3)} }
    }
}

set timestamp   {"1998103117254688"}
set prjobid     {"JOB(999)"}
set prjobmilestone {1}
set acka        {true}
set err_info(1) {{1 "error_1"}}
set err_info(2) {{2 "error_2"}}
set err_info(3) {{3 "error_3"}}
secs::test {
    message {WAIT} S16F7 {
        $timestamp $prjobid $prjobmilestone
        {$acka {$err_info(1) $err_info(2) $err_info(3)}}
    }
}

secs::test {message {} S16F8 }

set preventid {2}
set timestamp {"1998103117254688"}
set prjobid   {"JOB(999)"}
set v_info(1) {{1 "value_1"}}
set v_info(2) {{"variable-2" "value_2"}}
set v_info(3) {{3 "value_3"}}
secs::test {
    message {WAIT} S16F9 {
        $preventid $timestamp $prjobid {$v_info(1) $v_info(2) $v_info(3)}
    }
}

secs::test {message {} S16F10 }

###############################################################################
# Stream 17
###############################################################################
secs::test {message {} S17F0 }

set dataid   {10001}
set rptid    {123}
set datasrc  {"DataType"}
set vid_list {{"vid_100" "vid_200" "vid_300" "vid_400" "vid_500" \
               "vid_600" "vid_700"}}
secs::test {message {WAIT} S17F1 {$dataid $rptid $datasrc $vid_list} }

set rptid    {123}
set errcode  {9}
secs::test {message {} S17F2 {$rptid $errcode} }

set rptid_(1) {"rptid_1"}
set rptid_(2) {"rptid_02"}
set rptid_(3) {"rptid_003"}
set rptid_(4) {"rptid_0004"}
set rptid_(5) {"rptid_00005"}
secs::test {
    message {WAIT} S17F3 {
        $rptid_(1) $rptid_(2) $rptid_(3) $rptid_(4) $rptid_(5)
    }
}

set acka        {true}
set err_info(1) {{"rptid_1" 1 "error_1"}}
set err_info(2) {{"rptid_02" 2 "error_2"}}
set err_info(3) {{"rptid_003" 3 "error_3"}}
secs::test {message {} S17F4 {$acka {$err_info(1) $err_info(2) $err_info(3)}}}

set dataid   {10001}
set trid     {1}
set ceed     {true}
set rptid_list {{"rptid_1" "rptid_02" "rptid_003" "rptid_0004" "rptid_00005"}}
set trsper   {5.456789021}
set totsmp         {0}
set repgsz         {12}
set start_eventsrc {"ObjectType"}
set start_ceid     {112}
set stop_eventsrc  {"ObjectType"}
set stop_ceid      {113}
set trautod        {true}
set rptoc          {false}
secs::test {
    message {WAIT} S17F5 {
        $dataid $trid $ceed $rptid_list $trsper
        {$totsmp $repgsz $start_eventsrc $start_ceid $stop_eventsrc
         $stop_ceid $trautod $rptoc}
    }
}
secs::test {
    message {WAIT} S17F5 {$dataid $trid $ceed $rptid_list $trsper {}}
}

set trid     {123}
set errcode  {9}
secs::test {message {} S17F6 {$trid $errcode}}

set trid_list {{"trid_1" "trid_02" "trid_003" "trid_0004" "trid_00005" 6 7000}}
secs::test {message {WAIT} S17F7 $trid_list}

set acka        {true}
set err_info(1) {{"trid_1" 1 "error_1"}}
set err_info(2) {{"trid_02" 2 "error_2"}}
set err_info(3) {{"trid_003" 3 "error_3"}}
secs::test {message {} S17F8 {$acka {$err_info(1) $err_info(2) $err_info(3)}}}

set dataid   {10001}
set evntsrc  {"ObjectType"}
set ceid     {119}
set rptid_list {{"rptid_1" "rptid_02" "rptid_003" "rptid_0004" "rptid_00005"}}
secs::test {message {WAIT} S17F9 {$dataid $evntsrc $ceid $rptid_list}}

set evntsrc  {"ObjectType"}
set ceid     {119}
set errcode  {9}
secs::test {message {} S17F10 {$evntsrc $ceid $errcode}}

set evntsrc  {"ObjectType"}
set ceid     {119}
set errcode  {9}
secs::test {message {WAIT} S17F11 {$evntsrc $ceid $errcode}}

set evntsrc  {"ObjectType"}
set ceid     {119}
set rptid    {"rptid_00005"}
set errcode  {9}
secs::test {message {} S17F12 {$evntsrc $ceid $rptid $errcode } }

set trid_list {{"trid_1" "trid_02" "trid_003" "trid_0004" "trid_00005" 6 7000}}
secs::test {message {WAIT} S17F13 $trid_list}

set acka        {true}
set err_info(1) {{"trid_1" 1 "error_1"}}
set err_info(2) {{"trid_02" 2 "error_2"}}
set err_info(3) {{"trid_003" 3 "error_3"}}
secs::test {message {} S17F14 {$acka {$err_info(1) $err_info(2) $err_info(3)}}}
