// $Id: b_assert.h,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_assert.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_ASSERT_H
#define B_ASSERT_H

#ifdef __cplusplus
#include <string>
#include <stdexcept>
using namespace std;
#endif

#define _AsString(identifier) #identifier

#ifdef NDEBUG
#define BEEAssert(x)
#define BEEPanic(x)
#else
#ifdef __cplusplus
#define BEEPanic(x)  Panic<runtime_error>((x), __FILE__, __LINE__)
#define BEEAssert(x) Assert<runtime_error>((x), __FILE__, __LINE__, #x)

typedef runtime_error BException;

#else
BEE_Export extern void _Panic(char * msg, char * fname, int lineNum);
BEE_Export extern void _Assert(char * fname, int lineNum, char * astr);

#define BEEAssert(x) if (! (x)) {_Assert(__FILE__, __LINE__, (char *)_AsString((x)));} else

#define BEEPanic(x)  _Panic((x), __FILE__, __LINE__)
#endif
#endif  /* _NO_DEBUG */


#ifdef __cplusplus
extern bool _ARG_CHECK;

template<class T, class A>
inline void Assert(A assertion, char * fname, int lineNum, char * astr)
{
    if ((! assertion) && _ARG_CHECK)
    {
        char lbuf[16];
        string s;
        sprintf(lbuf, "(%d): ", lineNum);
        s += (strrchr(fname, '\\') + 1);
        s += lbuf;
        s += "ASSERT(";
        s += astr;
        s += ")";
        throw T(s);
    }
}

template<class T>
inline void Panic(char * msg, char * fname, int linenum)
{
    char lbuf[16];
    string s = "Panic! ";
    sprintf(lbuf, "(%d): ", linenum);
    s += (strrchr(fname, '\\') + 1);
    s += lbuf;
    s += msg;
    throw T(s);
}
#endif

#endif /* B_ASSERT_H */
