// $Id: b_attribute.h,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_attribute.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_ATTRIBUTE_H
#define B_ATTRIBUTE_H

#include "b_value.h"

class b_objtype;
class b_object;
class b_attrdata;


//
// Attribute of Class
//
class BEE_Export b_attribute
{
public:
    b_attribute(b_objtype& cls, const char * name, int type, size_t size);
    ~b_attribute() {}

    const  string& name() const { return m_name; }
    int    type() const      { return m_type; }
    int    position() const  { return m_position; }
    void   position(int pos) { m_position = pos; }
    size_t size() const      { return m_size; }

    // Create Instance
    b_attrdata * instance(const b_object * object) const;

    void  setInitVal(const char * defdata, int format) {
            string inidata = defdata;
            m_init.set(inidata, format);
        }
    void  setInitVal(const b_value& val) { m_init = val; }
    const b_value& getInitVal() const { return m_init; }

    void dump() const;

protected:
    b_attribute() : m_name(""), m_type(ATOM_LIST), m_init(0), m_size(0) {}

// Member variables
protected:
    string m_name;
    int    m_type;
    int    m_size;
    int    m_position;
    b_value m_init;
};

typedef map<const string, b_attribute *, str_less, allocator<b_attribute *> > b_attrMap;
typedef b_attrMap::value_type  b_attrPair;
typedef vector<b_attribute *>  b_attributes;


#endif  /* B_ATTRIBUTE_H */
