// $Id: b_specification.h,v 1.1.1.1 2002/08/31 04:47:22 fukasawa Exp $

//=============================================================================
/**
 *  @file    b_specification.h
 *
 *  @author  Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 2001-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef B_SPECIFICATION_H
#define B_SPECIFICATION_H

#include "b_value.h"
#include "beelib.h"

class b_objtype;
class b_object;
typedef map<const string, b_objtype *, cstr_less,
                                       allocator<b_objtype *> > b_objtypeMap;
typedef map<const string, b_object *,  cstr_less,
                                       allocator<void *> >  b_objectMap;
typedef b_objtypeMap::value_type b_objtypePair;
typedef b_objectMap::value_type  b_objectPair;

//
// Specification
//
class BEE_Export b_specification
{
    friend class ACE_Singleton<b_specification, ACE_Null_Mutex>;

public:

    const char * name() const { return m_name.c_str(); }
    int   count() const       { return m_classes.size(); }
    u_int seed()              { return m_seed++; }

    // Add new class
    int add(b_objtype * objtype);

    // Entry new object
    int addObject(b_object * obj);

    // Remove object type
    int remove(b_objtype * clazz);

    // Remove object
    int remove(b_object * obj);

    // Find class and object by name
    b_objtype * find(const string& name) const;
    b_object  * findObject(const string& name) const;

    // Make object specification and identifier
    void makeObjSpec(b_object * obj, string& spec) const;
    int  objSpec2ID(const string& spec, string& objid) const;

    // clear all objects and objtypes
    void clear();

protected:
    b_specification() : m_name(""), m_seed(1) { }
    b_specification(const string& name) : m_name(name), m_seed(1) {}
    b_specification(const char * name) : m_name(name), m_seed(1)  {}
    ~b_specification();

protected:
    string       m_name;
    MUTEX_UInt   m_seed;
    b_objtypeMap m_classes;
    b_objectMap  m_objs;
    
    ACE_Thread_Mutex m_typeLock;
    ACE_Thread_Mutex m_objLock;
};

typedef ACE_Singleton<b_specification, ACE_Null_Mutex> ObjSpec;

#endif  /* B_SPECIFICATION_H */
