// $Id: BS2Array.h,v 1.1.1.1 2002/08/31 04:47:23 fukasawa Exp $

//=============================================================================
/**
 *  @file    BS2Array.h
 *
 *  @author Fukasawa Mitsuo
 *
 *
 *    Copyright (C) 1998-2002 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BS2ARRAY_H
#define BS2ARRAY_H

#include "BS2Atom.h"

class BS2OStream;
class BS2IStream;
class BS2Int1;
class BS2Int2;
class BS2Int4;
class BS2Int8;
class BS2UInt1;
class BS2UInt2;
class BS2UInt4;
class BS2UInt8;
class BS2Float4;
class BS2Float8;

/* ------------------------------------------------------------------------- */
template <class T>
class BS2Array : public BS2Atom
{
public:
    BS2Array();
    BS2Array(T datum);
    BS2Array(BYTE * data, size_t size = sizeof(T));
    virtual ~BS2Array();
    virtual void dump() const;
    virtual void print(BS2InterpBase * interp) const;
    virtual void get(BS2OStream& buf) const;
    virtual void set(BS2IStream& buf);
    virtual void getStreamData(BYTE * buf) const;
    virtual void setStreamData(BYTE * buf);
    virtual BS2Atom * factory(BYTE * data, size_t len) const;
    virtual BS2Atom * replicate() const;

    const BS2Array<T>& operator=(const BS2Array<T>& rhs);
    int count() const { return m_q; }
    T * value() const { return (T *)m._ptr; }
    void add(BS2Array<T> * src);
    void add(T * data, int size = sizeof(T));
    void add(T datum);
    string arrayName() const;

friend BS2IStream& operator>>(BS2IStream& is, BS2Array<T>& atomArray);
friend BS2OStream& operator<<(BS2OStream& os, const BS2Array<T>& atomArray);

protected:

};


/* ------------------------------------------------------------------------- */
typedef BS2Array<bool>      BS2BoolArray;
typedef BS2Array<BCHAR>      BS2Int1Array;
typedef BS2Array<short>     BS2Int2Array;
typedef BS2Array<int>       BS2Int4Array;
typedef BS2Array<LONGLONG>  BS2Int8Array;
typedef BS2Array<BYTE>      BS2UInt1Array;
typedef BS2Array<USHORT>    BS2UInt2Array;
typedef BS2Array<UINT>      BS2UInt4Array;
typedef BS2Array<ULONGLONG> BS2UInt8Array;
typedef BS2Array<float>     BS2Float4Array;
typedef BS2Array<double>    BS2Float8Array;

/* ------------------------------------------------------------------------- */
//
#include "BS2Array.i"
//

inline int toFormat(bool   v) { return ATOM_BOOLEAN; }
inline int toFormat(BCHAR   v) { return ATOM_INT1; }
inline int toFormat(short  v) { return ATOM_INT2; }
inline int toFormat(int    v) { return ATOM_INT4; }
inline int toFormat(BYTE   v) { return ATOM_UINT1; }
inline int toFormat(USHORT v) { return ATOM_UINT2; }
inline int toFormat(UINT   v) { return ATOM_UINT4; }
inline int toFormat(float v)  { return ATOM_FLOAT4; }
inline int toFormat(double v) { return ATOM_FLOAT8; }
inline int toFormat(LONGLONG  v) { return ATOM_INT8; }
inline int toFormat(ULONGLONG v) { return ATOM_UINT8; }

#endif /* BS2ARRAY_H */
