# :Author: SAKIMA Kimihisa
# :Contact: sakima at hooktail.org
# :Date: $Date: 2006/01/25 17:25:16 $
# :Revision: $Revision: 1.7 $

$KCODE = "EUC" 
require 'digest/md5'


# ==========================================================
# 饤$...$ִ᥽å
# ==========================================================
def inline_math(buf)
  
  #  \$  <dollar> ִ$ΤΤ򵭽Ҥ뤿
  buf.gsub!(/\\\$/, " <dollar> ")
  
  re_inlinemath = /\$(.*?)\$/      # 饤Υѥ
  re_reference = /(\\ref\{.*?\})/  # \ref{*} Υѥ
  re_toalign = /\\\\/              # alignĶذܹԤѥ
  re_tag = /\\tag\{(.*?)\}/        # \tag{*} Υѥ
  
  inlineEquations = Array.new  # Ǽ
  
  # ˳Ǽ
  inlineEquations << buf.scan(re_inlinemath)
  inlineEquations << buf.scan(re_reference)
  
  # ͥȤ줿եåȤˤʣǤ
  inlineEquations.flatten!.uniq!
  
  #  |md5| ִ
  buf.gsub!(re_inlinemath){ "|#{Digest::MD5.hexdigest($1)}|" }
  
  # \ref{*}  |md5| ִ
  buf.gsub!(re_reference){ "|#{Digest::MD5.hexdigest($1)}|" }
  
  # бreStructuredTextǸ˽
  # ʥ饤ο֤
  n = inlineEquations.length
  i = 0
  while i < n
    # ļФ
    inEquation = inlineEquations.pop
    if (inEquation =~ re_tag) then
      # \tag{*}  $...$ ĶǻȤʤΤǿˤ
      buf << "\n.. |" + Digest::MD5.hexdigest(inEquation) + "| raw:: latex\n\n"
      buf << "  $" + inEquation.gsub(re_tag) { "(" + $1 + ")" } + "$\n\n\n"     
    elsif (inEquation =~ re_toalign) then
      #  \\ ޤΤ align Ķˤ
      # 顼ˤʤ礬Τ & ϼ 
      buf << "\n.. |" + Digest::MD5.hexdigest(inEquation) + "| raw:: latex\n\n"
      buf << "  \\begin{align*}" + inEquation.gsub(/&/,"") + "\\end{align*}\n\n\n"
    else
      # ¾ϤΤޤ
      buf << "\n.. |" + Digest::MD5.hexdigest("#{inEquation}") + "| raw:: latex\n\n"
      buf << "  $#{inEquation}$\n\n\n"
    end
    i += 1
  end
  
  # <dollar>  $ ִ
  buf.gsub!(/ <dollar> /, "\$")
  
  return buf
  
end


# ==========================================================
# ǥץ쥤<tex>...</tex>ִ᥽å
# ==========================================================

class DisplayMathDiv
  attr_accessor :tag, :matter
  # 
  def initialize(tag, matter)
    @tag = tag
    @matter = matter
  end
  # rawǥ쥯ƥ֤Ѵ
  def trans
    "\n.. raw:: latex\n\n  \\begin\{#{@tag}\}\n" +
    @matter.gsub(/^/m, "    ").gsub(/^\s*\n/m, "") +
    "  \\end\{#{@tag}\}\n\n"
  end
end

def display_math(buf)
  
  # tex   align* Ķ
  re_tex = /<tex>(.*?)<\/tex>/m
  buf.gsub!(re_tex){
    DisplayMathDiv.new("align*", $1).trans
  }
  
  # aling   align* Ķ
  re_tex = /<align>(.*?)<\/align>/m
  buf.gsub!(re_tex){
    DisplayMathDiv.new("align", $1).trans
  }
  
=begin
  #   бĶ
  re_tag = /<(.*?)>(.*?)<\/(.*?)>/m
  # ѥäɾ
  buf.gsub!(re_xxx){
    if $1 == $3
      DisplayMathDiv.new($1, $2).trans
    else
      "\nkagiPDF warning: tag <#{$1}> is not terminated.\n"
    end
  }
=end
  
  return buf
  
end


# ==========================================================
# եŬڤѴ
# ==========================================================
def figure(buf)
  
  # image ⤷ figure ǥ쥯ƥ֤Υѥ
  re_conv_eps = /\.\.\s+(figure|image)\s*::\s+(.*)\.(png|gif|jpg)/
  re_make_bb = /\.\.\s+(figure|image)\s*::\s+(.*)\.(pdf)/

  # Ǽ
  images = Array.new

  # ե̾
  images << buf.scan(re_conv_eps)
  images << buf.scan(re_make_bb)
  
  # png, gifξϥǥ쥯ƥγĥҤepsˤ
  buf.gsub!(re_conv_eps) { ".. " + $1 + ":: " + $2 + ".eps" }
  
  # ե̾ǼƤեåȤˤ
  images.flatten!
  
  # eps⤷bbե
  # ʻȤƤեο֤
  n = images.length
  i = 0
  while i < n
    fBody = images[i+1]  # ĥҤե̾
    fTail = images[i+2]  # ĥ̾
    
    orgFile = fBody + "." + fTail  # βե̾
    pngFile = fBody + ".png" # epsե̾
    epsFile = fBody + ".eps" # epsե̾

    # եμˤŬ
    if (fTail == "png")
      # bmepsͥ
      if open("| which bmeps 2>/dev/null"){|f| f.gets}
        `bmeps -c -p3 -am255,255,255s #{orgFile} #{epsFile}`
      else
        `convert -compress lzw #{orgFile} eps2:#{epsFile}`
      end
    elsif (fTail == "gif")
      `convert -compress lzw #{orgFile} eps3:#{epsFile}`
    elsif (fTail == "jpg")
      `convert -compress lzw #{orgFile} eps3:#{epsFile}`
    elsif (fTail == "pdf")
      `ebb #{orgFile}`  # bbBoundingBox˥եĤ
    end
    
    # 3ĤǲեʬʤΤǡ+3פȼβ
    i += 3
  end
  
  return buf
  
end


# ==========================================================
# @@̿ν
# ==========================================================
def atat(buf)
  
  # @@̿γƼѥ
  re_author = /@@author:\s*(.*?)\s*@@/
  re_date = /@@accept:\s*?(.+?)\s*?@@/
  re_reference = /@@reference:\s*(.*?)\s*@@/
  re_category = /@@category:\s*(.*?)\s*@@/
  re_information = /@@information:\s*(.*?)\s*@@/

  # ѥ˥ޥåʬ
  author = buf.scan(re_author).join
  date = buf.scan(re_date).join
  date = "today" if date == ""

  # @@author:...@@ס@@accept:...@@פ
  #  줾쥿ȥľΡ:Author: ...,:Date: ...פѴ
  if buf =~ re_author
    buf.sub!(/\n(.*)(====|----|````|::::|\"\"\"\"|~~~~|\^\^\^\^|____|\*\*\*\*|\+\+\+\+|####|<<<<|>>>>)\n/){
      "\n" + $1 + $2 +  "\n:Author: " + author + "\n" + ":Date: " + date  + "\n\n"
    }
  end

  # @@̿᤽ΤΤϼ
  buf.gsub!(re_author, "")
  buf.gsub!(re_date, "")
  buf.gsub!(re_reference, "")
  buf.gsub!(re_category, "")
  buf.gsub!(re_information, "")
  
  return buf
  
end


# ==========================================================
# ¾
# ==========================================================
def etc(buf, style)
  
  # footnoteϿˤ[*]  [#]
  buf.gsub!(/ \[\*\]\_ ?/, " \[#\]\_ ")
  buf.gsub!(/^\.\.\s+\[\*\]\s+/, "\.\. \[#\] ")

  # Ƭѥڡ
  buf.gsub!(/^/, "")

  # ֡פ֡פˡ֡פ֡פִ
  buf.gsub!(//, "")
  buf.gsub!(//, "") if style == "hooktail"

  return buf
  
end
