
require 'uri'
require 'pstore'

require 'PageDataSource.rb'

module Wiki

class PageData
	def initialize
		self.properties = PageProperties.new();
	end
	attr "content_source", true
	attr "content_document", true
	attr "properties", true
end

class PStorePageDataSource < PageDataSource
	DB_FILE_NAME = 'pages.db'

	def initialize(data_dir)
		super(data_dir)
		self.page_db = PStore.new("#{data_dir}/#{DB_FILE_NAME}")
	end

=begin 

	def load_content_source(page_name, &block)
		content_source = "\n"
		page_db.transaction{
			if page_db.root?(page_name) then
				page_data = page_db[page_name] 
				content_source = page_data.content_source
			end
			if block_given? then
				content_source.each_line(){ |line|
					yield(line);
				}
			end
		}

		return content_source;
	end

	def load_content(page_name)
		document = nil

		page_db.transaction do
			if page_db.root?(page_name) then
				page_data = page_db[page_name] 
				if page_data.properties.cache_time > page_data.properties.source_time then
					document = page_data.content_document
				else
					parser = Wiki::PageParser.new()
					document =  parser.parse(page_data.content_source);
					if document then
						page_data.content_document = document
						page_data.properties.cache_time = Time.now
					end
				end
				page_db[page_name] = page_data
			else
				raise "NoSuchPage"
			end
		end

		return document;
	end

	def save_content(page_name, content_source)
		page_db.transaction{
			if page_db.root?(page_name) then
				page_data = page_db[page_name] 
			else
				page_data = PageData.new()
				page_data.content_document = nil
				page_data.properties.page_name = page_name
				page_data.properties.cache_time = Time.new()
			end
			page_data.content_source = content_source
			page_data.properties.source_time = Time.now
			page_db[page_name] = page_data
		}
	end

	def all_pages(&block)
		pages = []
		page_db.transaction{
			pages = page_db.roots
		}
		pages.sort!()
		if block_given? then
			pages.each(){ |page|
				yield(page);
			}
		end
		return pages;
	end

	def recent_pages(num_of_page = 20, &block)
		pages = self.all_pages
		page_info_list = pages.collect(){ |page|
			[self.load_properties(page).source_time, page]
		}
		page_info_list = page_info_list.sort().reverse()
		pages = page_info_list.collect(){ |page_data|
			page_data[1]
		}
		if block_given? then
			pages.each(){ |page|
				yield(page);
			}
		end
		return pages;
	end
=end

	def load_page_source(page_name)
	end

	def save_page_source(page_name, source)
	end

	def exist?(page_name)
	end

	def page_property(page_name, &block)
		property = nil
		page_db.transaction{
			if page_db.root?(page_name) then
				property = page_db[page_name].property
				if block_given? then
					yield(property)
				end
			end
		}
		return  property;
	end

	def site_property(&block)
		property = nil
		page_db.transaction{
			if page_db.root?(page_name) then
				property = page_db['site_property'].property
				if block_given? then
					yield(property)
				end
			end
		}
		return  property;
	end

	def page_list()
		[]
	end

protected

	attr 'page_db', true

	def load_cached_document(page_name)
	end

	def save_cached_document(page_name, document)
	end
end

end # module Wiki

