
$: << ".."

# testfoo.rb
require 'runit/testcase'
require 'runit/cui/testrunner'
require 'DocumentModel.rb'

class ContainerImpl
	include Wiki::Container
end

class TestDocumentModel < RUNIT::TestCase
	include Wiki

	def setup
	end

	def test_text_equal
		hello = Text.new("hello") 
		hell = Text.new("hell")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert_equal(hello, Text.new("hello"))
	end

	def test_link_equal
		hello = Link.new("Hello") 
		hell = Link.new("Hell")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert_equal(hello, Link.new("Hello"))
	end

	def test_urilink_equal
		hello = URILink.new("Hello", "http://hello.com/") 
		hello2 = URILink.new("Hello", "http://hello.net/") 
		hell = URILink.new("Hell", "http://hell.com/")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert(hello != hello2)
		assert_equal(hello, URILink.new("Hello", "http://hello.com/"))
	end

	def test_emphasis_equal
		hello = Emphasis.new("Hello") 
		hello2 = Emphasis.new(Text.new("Hello")) 
		hell = Emphasis.new("Hell")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert_equal(hello, hello2)
		assert_equal(hello, Emphasis.new("Hello"))
	end

	def test_strong_equal
		hello = Strong.new("Hello") 
		hello2 = Strong.new(Text.new("Hello")) 
		hell = Strong.new("Hell")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert_equal(hello, hello2)
		assert_equal(hello, Strong.new("Hello"))
	end

	def test_strike_equal
		hello = Strong.new("Hello") 
		hello2 = Strong.new(Text.new("Hello")) 
		hell = Strong.new("Hell")
		assert(hello != hell)
		assert_equal(hello, hello)
		assert_equal(hello, hello2)
		assert_equal(hello, Strong.new("Hello"))
	end

	def test_container_equal
		strong_hello = Strong.new("Hello") 
		emphasis_hello = Emphasis.new("Hello") 
		hell = Text.new("Hell")

		container1 = ContainerImpl.new([strong_hello, emphasis_hello, hell]) 
		container3 = ContainerImpl.new([strong_hello, hell])
		container2 = ContainerImpl.new([strong_hello, hell, emphasis_hello]) 
		assert_equal(container1, container1)
		assert(container1 != container2)
		assert(container1 != container3)
		assert(container2 != container3)
		assert_equal(container1, ContainerImpl.new([strong_hello, emphasis_hello, hell]))
	end

	def test_container_append_child
		strong_hello = Strong.new("Hello") 
		emphasis_hello = Emphasis.new("Hello") 
		hell = Text.new("Hell")

		container1 = ContainerImpl.new([strong_hello])
		container2 = ContainerImpl.new([strong_hello, emphasis_hello]) 
		container3 = ContainerImpl.new([strong_hello, emphasis_hello, hell]) 
		container = ContainerImpl.new();

		assert(container != container1)
		assert(container != container2)
		assert(container != container3)
		container.append_child(strong_hello)
		assert_equal(container, container1)
		container.append_child(emphasis_hello)
		assert_equal(container, container2)
		container.append_child(hell)
		assert_equal(container, container3)
	end

end

RUNIT::CUI::TestRunner.run(TestDocumentModel.suite) if $0 == __FILE__ 
