#!/usr/bin/env ruby

$: << "../src"

require 'WikiPageParser.rb'
require 'ToHtml.rb'

if $0 == __FILE__ then
	if ARGV.size <= 0 then
		puts "Usage : #{$0} file_path"
		exit
	end

	begin
		file_path = ARGV[0]
		file_path =~ /.*(\.\w+)/
		suffix = $1
		doc = nil
		File.open(file_path, "r"){ |input|
			if suffix == '.dat' then
				doc = Marshal.restore(input)
			else
				parser = Wiki::PageParser.new
				doc =  parser.parse(input);
			end
		}

		basename = File.basename(file_path, suffix);
		html_file_path = file_path.sub(/#{suffix}$/, '.html')
		File.open(html_file_path, "w"){ |outfile|
			wiki_html = ''
			doc.accept(Wiki::ToHtml.new(wiki_html))
			outfile << <<EOD
<?xml version="1.0" encoding="euc-jp" ?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja" >
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=euc-jp" />
	<meta name="ROBOTS" content="ALL" />
	<title>
		#{basename}
	</title>
</head>
<body>
<h1> #{basename} </h1>
#{wiki_html}
</body>
</html>
EOD
		}
	rescue Racc::ParseError
		p $!
	end
end

