module Wiki

require 'ToHtml.rb'

class ToWikiHtml < ToHtml

	def initialize(page_data_source, output = STDOUT)
		super(output)
		@page_data_source = page_data_source
		self.link_base_uri = ''
		self.default_lang_list = nil
		@link_html_cache = {}
	end

	attr "link_base_uri", true;
	attr "default_lang_list", true;

	def visit_link(element)
		link_id = element.label.untaint()
		page_name, page_lang, page_version = @page_data_source.parse_page_id(link_id)
		if self.default_lang_list then
			link_html = @link_html_cache[link_id] 
			unless link_html then
				lang_list = self.default_lang_list
				lang_list = [page_lang] + lang_list if page_lang 

				page_id = @page_data_source.suitable_page_id(page_name, lang_list, page_version) 
				if page_id then
					page_name, page_lang, page_version = @page_data_source.parse_page_id(page_id)
					page_title = @page_data_source.page_property(page_name, page_lang)['page_title']
					link_html = %Q!<a href="#{link_base_uri}#{URI.escape(element.label)}">#{CGI.escapeHTML(page_title)}</a>!
				else
					link_html = %Q!#{CGI.escapeHTML(element.label)}<a href="#{link_base_uri}#{URI.escape(element.label)}">?</a>!
				end
				@link_html_cache[link_id] = link_html
			end
		else
			if @page_data_source.exist_page?(page_name) then
				link_html = %Q!<a href="#{link_base_uri}#{URI.escape(element.label)}">#{CGI.escapeHTML(element.label)}</a>!
			else
				link_html = %Q!#{CGI.escapeHTML(element.label)}<a href="#{link_base_uri}#{URI.escape(element.label)}">?</a>!
			end
		end
		output << link_html
	end

	def visit_page(element)
		element.children_accept(self)
		output
	end

end

end

