
$: << ".."

require 'runit/testcase'
require 'runit/cui/testrunner'

require 'InLineParser.rb'
require 'DocumentModel.rb'

class TestInLineParser < RUNIT::TestCase
	include Wiki

	def setup
		@parser = InLineParser.new()
	end

	def test_parse_text
		hello = Text.new("hello")
		world = Text.new("world")

		result  = @parser.parse("hello")
		assert_equal([hello], result)

		result  = @parser.parse("world")
		assert_equal([world], result)

		result  = @parser.parse("hello world")
		assert_equal([Text.new("hello world")], result)
	end

end

RUNIT::CUI::TestRunner.run(TestInLineParser.suite) if $0 == __FILE__
