# Kanbanara REST API Component
# Written by Rebecca Shalfield in 2018
# Copyright (c) 2018 Rebecca Shalfield and Kanbanara Software Foundation
# Released under the GNU AGPL v3

import random
import string

import cherrypy

@cherrypy.expose
class RestAPI(object):

    @cherrypy.tools.accept(media='text/plain')
    def GET(self):
        return cherrypy.session['mystring']
        
    def POST(self, length=8):
        some_string = ''.join(random.sample(string.hexdigits, int(length)))
        cherrypy.session['mystring'] = some_string
        return some_string

    def PUT(self, another_string):
        cherrypy.session['mystring'] = another_string

    def DELETE(self):
        cherrypy.session.pop('mystring', None)


conf = {'/': {'request.dispatch': cherrypy.dispatch.MethodDispatcher(),
              'tools.sessions.on': True,
              'tools.response_headers.on': True,
              'tools.response_headers.headers': [('Content-Type', 'text/plain')],
             }
       }

cherrypy.tree.mount(RestAPI(), '/restapi', config=conf)