$(document).ready(function() {
    
    $("#customise").click(function () {
      $("#customisedialog").dialog("open");
    });

    $("#customisedialog").dialog({
      autoOpen: false,
      maxWidth: 740,
      maxHeight: 510,
      width: 740,
      height: 510,
      modal: true,
      show: {
          effect: "blind",
          duration: 1000
      },
      hide: {
          effect: "explode",
          duration: 1000
      }
    });
    
    $("#tags").select2({
        tags:          true,
        placeholder:   'Please select or enter a tag',
        width:         '100%'
    });
    
    $("#artifacts").select2({
        tags:          true,
        placeholder:   'Please select or enter an artifact',
        width:         '100%'
    });
    
    $(".entrycriteria").select2({
        tags:          true,
        placeholder:   'Please enter a rule',
        width:         '100%'
    });
    
    $(".exitcriteria").select2({
        tags:          true,
        placeholder:   'Please enter a rule',
        width:         '100%'
    });
    
    var amountScrolled = 300;

    // Delays by 120 seconds the kicking in of freezing the width of the kanban board's columns
    // so as to give the sections filled via Ajax the time to grab the screen width each requires
    var $table = $('#kanbanboard');
    setTimeout(function () {
        $table.floatThead({
            responsiveContainer: function($table){
                return $table.closest('#kanbanboardcontainer');
            },
            position: 'fixed',
            zIndex: 50
        });
    }, 120000);

    $(window).scroll(function() {
        if ( $(window).scrollTop() > amountScrolled ) {
            $('a.back-to-top').fadeIn('slow');
        } else {
            $('a.back-to-top').fadeOut('slow');
        }
    });

    $( ".tabs" ).tabs({
        event: 'click',
        fx: {opacity: 'toggle',
             duration: 'fast'
            },
        cache: true
    });

    function toggleFullscreen(elem) {
      elem = elem || document.documentElement;
      if (!document.fullscreenElement && !document.mozFullScreenElement &&
        !document.webkitFullscreenElement && !document.msFullscreenElement) {
        if (elem.requestFullscreen) {
          elem.requestFullscreen();
        } else if (elem.msRequestFullscreen) {
          elem.msRequestFullscreen();
        } else if (elem.mozRequestFullScreen) {
          elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
          elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
        }
      } else {
        if (document.exitFullscreen) {
          document.exitFullscreen();
        } else if (document.msExitFullscreen) {
          document.msExitFullscreen();
        } else if (document.mozCancelFullScreen) {
          document.mozCancelFullScreen();
        } else if (document.webkitExitFullscreen) {
          document.webkitExitFullscreen();
        }
      }
    }

    $('#fullscreen').click(function() {
      toggleFullscreen();
    });   

    $('a.back-to-top').click(function() {
        $('html, body').animate({
            scrollTop: 0
        }, 700);
        return false;
    });
    
    //$('.onlinehelp').hide();

    /* Next part of code handles hovering effect and submenu appearing */
    $('.nav li').hover(
      function () { //appearing on hover
        $('ul', this).fadeIn();
      },
      function () { //disappearing on hover
        $('ul', this).fadeOut();
      }
    );    

    $('table.filter').mouseover(function() {
        $(this).children("thead").show();
    });

    $('table.filter').mouseout(function() {
        $(this).children("thead").hide();
    });
    
    $(document).tooltip();
    
    $(".controlgroup").controlgroup(); 
    
    $("#progressbar").progressbar({
        create: function() {
            var value = parseInt($("#progressbar").attr('data-value'));
            $("#progressbar").progressbar("value",value);
            $("#progressbar-label").html(value+"%");
        }
    });
   
    $('.edit').editable('/cards/inline_edit', {
         id   : 'docidattr',
         indicator : 'Saving...',
         tooltip   : 'Click to edit...'
     });
     $('.edit_area').editable('/cards/inline_edit', {
         id   : 'docidattr',
         type      : 'textarea',
         cancel    : 'Cancel',
         submit    : 'OK',
         indicator : '<img src="img/indicator.gif">',
         tooltip   : 'Click to edit...'
     });

    $("#addrecordform, #updaterecordform").on("submit", function(event) {
        var errors = new Array();
        var title = "";
        var project = "";
        var owner = new String();
        var coowner = new String();
        var reviewer = new String();
        var coreviewer = new String();
        var state = new String();
        var resolution = new String();
        title = $('#title').val()
        if (!title) {
            errors.push("Please add a title!");
        };
        project = $('select[name=project]').find("option:selected").text();    
        if (project.search('Please select...') != -1) {
            errors.push("Please select a project!");
        };
        owner = $('select[name=owner]').find("option:selected").text();
        coowner = $('select[name=coowner]').find("option:selected").text();    
        reviewer = $('select[name=reviewer]').find("option:selected").text();    
        coreviewer = $('select[name=coreviewer]').find("option:selected").text();
        state = $('select[name=state]').find("option:selected").text();
        resolution = $('select[name=resolution]').find("option:selected").text();
        if ((String(owner) !== "Please select...") && (String(coowner) !== "Please select...") && owner === coowner) {
            errors.push("Owner and Co-Owner are identical!");
        };
        if ((String(owner) !== "Please select...") && (String(reviewer) !== "Please select...") && owner === reviewer) {
            errors.push("Owner and Reviewer are identical!");
        };
        if ((String(owner) !== "Please select...") && (String(coreviewer) !== "Please select...") && owner === coreviewer) {
            errors.push("Owner and Co-Reviewer are identical!");
        };
        if ((String(coowner) !== "Please select...") && (String(reviewer) !== "Please select...") && coowner === reviewer) {
            errors.push("Co-Owner and Reviewer are identical!");
        };
        if ((String(coowner) !== "Please select...") && (String(coreviewer) !== "Please select...") && coowner === coreviewer) {
            errors.push("Co-Owner and Co-Reviewer are identical!");
        };
        if ((String(reviewer) !== "Please select...") && (String(coreviewer) !== "Please select...") && (reviewer === coreviewer)) {
            errors.push("Reviewer and Co-Reviewer are identical!");
        };
        if ((String(state) == "Closed") && (resolution.search('Please select...') != -1)) {
            errors.push("A resolution needs to be selected!");
        };
        if ( errors.length > 0 ) {
            event.preventDefault();
            handleErrors(errors);
        };
    });
    
    $("#splitstoryform").on("submit", function(event) {
        var errors = new Array();
        var titleoffirst = new String();
        var titleofsecond = new String();
        titleoffirst = $('#titleoffirst').val()
        titleofsecond = $('#titleofsecond').val()
        if (!titleoffirst) {
            errors.push("Please add a title for the first story!");
        };
        if (!titleofsecond) {
            errors.push("Please add a title for the second story!");
        };
        if ((titleoffirst) && (titleofsecond) && titleoffirst === titleofsecond) {
            errors.push("Titles are identical!");
        };
        if ( errors.length > 0 ) {
            event.preventDefault();
            handleErrors(errors);
        };
    });
    
    function handleErrors( errors ) {
        var container = $(".ui-state-error").hide(),
            list = container.find("ul").empty();
        if ( errors.length === 0 ) {
            return;
        }
        $.each( errors, function(index, error) {
            list.append("<li>"+error+"</li>")
        });
        container.show("shake",{times:2},100);
    };
    
    $('.marquee').marquee({
        //speed in milliseconds of the marquee
        duration: 50000,
        //gap in pixels between the tickers
        gap: 50,
        //time in milliseconds before the marquee will start animating
        delayBeforeStart: 0,
        //'left' or 'right'
        direction: 'left',
        //true or false - should the marquee be duplicated to show an effect of continues flow
        duplicated: false,
        pauseOnHover: true
    });
    
    $("div[id$=mainheader]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane-1step'+step_no+'mainheader').load('/kanban/step_main_header?step_no='+step_no);
    });
    
    $("div[id$=counterpartheader]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane-1step'+step_no+'counterpartheader').load('/kanban/step_counterpart_header?step_no='+step_no);
    });
    
    $("div[id$=bufferheader]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane-1step'+step_no+'bufferheader').load('/kanban/step_buffer_header?step_no='+step_no);
    });
    
    $("div[id$=mainentrycriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#step'+step_no+'mainentrycriteria').load('/kanban/step_main_entry_criteria?step_no='+step_no);
    });

    $("div[id$=mainexitcriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#step'+step_no+'mainexitcriteria').load('/kanban/step_main_exit_criteria?step_no='+step_no);
    });

    $("div[id$=counterpartentrycriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#step'+step_no+'counterpartentrycriteria').load('/kanban/step_counterpart_entry_criteria?step_no='+step_no);
    });

    $("div[id$=counterpartexitcriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#step'+step_no+'counterpartexitcriteria').load('/kanban/step_counterpart_exit_criteria?step_no='+step_no);
    });    

    $("div[id$=bufferentrycriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#step'+step_no+'bufferentrycriteria').load('/kanban/step_buffer_entry_criteria?step_no='+step_no);
    });

    $("div[id$=bufferexitcriteria]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#step'+step_no+'bufferexitcriteria').load('/kanban/step_buffer_exit_criteria?step_no='+step_no);
    });
    
    $("div[id$=counterpartexpedite]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane-1step'+step_no+'counterpartexpedite').load('/kanban/step_counterpart_expedite?swimlane_no=-1&step_no='+step_no);
    });
    
    $("div[id$=counterpartexpedite]").dblclick(function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane-1step'+step_no+'counterpartexpedite').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_expedite?swimlane_no=-1&step_no='+step_no);
    });
    
    $("div[id$=mainexpedite]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane-1step'+step_no+'mainexpedite').load('/kanban/step_main_expedite?swimlane_no=-1&step_no='+step_no);
    });
    
    $("div[id$=mainexpedite]").dblclick(function() {
        var element_id = $(this).attr('id');
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane-1step'+step_no+'mainexpedite').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_expedite?swimlane_no=-1&step_no='+step_no);
    });
    
    $("div[id$=bufferall]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([\-0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferall').load('/kanban/step_buffer_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferall");
    });
    
    $("div[id$=bufferall]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([\-0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferall').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferall");
    });

    $("div[id$=counterpartall]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartall').load('/kanban/step_counterpart_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartall");
    });

    $("div[id$=counterpartall]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartall').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartall");
    });    

    $("div[id$=mainall]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainall').load('/kanban/step_main_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainall");
    });

    $("div[id$=mainall]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainall').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_all?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainall");
    });    

    $("div[id$=counterpartcritical]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartcritical').load('/kanban/step_counterpart_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartcritical");
    });
    
    $("div[id$=counterpartcritical]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartcritical').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartcritical");
    });
    
    $("div[id$=maincritical]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'maincritical').load('/kanban/step_main_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmaincritical");
    });
    
    $("div[id$=maincritical]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'maincritical').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmaincritical");
    });
    
    $("div[id$=counterparthigh]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterparthigh').load('/kanban/step_counterpart_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterparthigh");
    });
    
    $("div[id$=counterparthigh]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterparthigh').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterparthigh");
    });
    
    $("div[id$=mainhigh]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainhigh').load('/kanban/step_main_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainhigh");
    });
    
    $("div[id$=mainhigh]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainhigh').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainhigh");
    });
    
    $("div[id$=counterpartlow]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartlow').load('/kanban/step_counterpart_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartlow");
    });
    
    $("div[id$=counterpartlow]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartlow').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartlow");
    });
    
    $("div[id$=mainlow]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainlow').load('/kanban/step_main_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainlow");
    });
    
    $("div[id$=mainlow]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainlow').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainlow");
    });

    $("div[id$=counterpartmedium]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartmedium').load('/kanban/step_counterpart_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartmedium");
    });
    
    $("div[id$=counterpartmedium]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartmedium').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartmedium");
    });
    
    $("div[id$=mainmedium]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainmedium').load('/kanban/step_main_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainmedium");
    });
    
    $("div[id$=mainmedium]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainmedium').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainmedium");
    });
    
    $("div[id$=mainwaiting]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainwaiting').load('/kanban/step_main_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainwaiting");
    });
    
    $("div[id$=mainwaiting]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainwaiting').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainwaiting");
    });
    
    $("div[id$=counterpartwaiting]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartwaiting').load('/kanban/step_counterpart_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartwaiting");
    });
    
    $("div[id$=counterpartwaiting]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartwaiting').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartwaiting");
    });
    
    $("div[id$=bufferwaiting]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferwaiting').load('/kanban/step_buffer_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferwaiting");
    });
    
    $("div[id$=bufferwaiting]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferwaiting').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_waiting?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferwaiting");
    });
    
    $("div[id$=counterpartblocked]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartblocked').load('/kanban/step_counterpart_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartblocked");
    });
    
    $("div[id$=counterpartblocked]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartblocked').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartblocked");
    });
    
    $("div[id$=mainblocked]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainblocked').load('/kanban/step_main_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainblocked");
    });
    
    $("div[id$=mainblocked]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainblocked').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainblocked");
    });
    
    $("div[id$=maindeferred]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'maindeferred').load('/kanban/step_main_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmaindeferred");
    });
    
    $("div[id$=maindeferred]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'maindeferred').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmaindeferred");
    });

    $("div[id$=counterpartdeferred]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartdeferred').load('/kanban/step_counterpart_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartdeferred");
    });
    
    $("div[id$=counterpartdeferred]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartdeferred').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartdeferred");
    });
    
    $("div[id$=counterpartghosted]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartghosted').load('/kanban/step_counterpart_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartghosted");
    });
    
    $("div[id$=counterpartghosted]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)counterpart')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'counterpartghosted').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_counterpart_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxcounterpartghosted");
    });

    $("div[id$=mainghosted]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainghosted').load('/kanban/step_main_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainghosted");
    });
    
    $("div[id$=mainghosted]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainghosted').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_main_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxmainghosted");
    });    

    $("div[id$=buffercritical]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'buffercritical').load('/kanban/step_buffer_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbuffercritical");
    });
    
    $("div[id$=buffercritical]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'buffercritical').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_critical?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbuffercritical");
    });
    
    $("div[id$=bufferhigh]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferhigh').load('/kanban/step_buffer_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferhigh");
    });
    
    $("div[id$=bufferhigh]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferhigh').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_high?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferhigh");
    });
    
    $("div[id$=bufferlow]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferlow').load('/kanban/step_buffer_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferlow");
    });
    
    $("div[id$=bufferlow]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferlow').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_low?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferlow");
    });
    
    $("div[id$=buffermedium]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'buffermedium').load('/kanban/step_buffer_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbuffermedium");
    });
    
    $("div[id$=buffermedium]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'buffermedium').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_medium?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbuffermedium");
    });
    
    $("div[id$=bufferblocked]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferblocked').load('/kanban/step_buffer_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferblocked");
    });
    
    $("div[id$=bufferblocked]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferblocked').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_blocked?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferblocked");
    });
    
    $("div[id$=bufferdeferred]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferdeferred').load('/kanban/step_buffer_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferdeferred");
    });
    
    $("div[id$=bufferdeferred]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferdeferred').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_deferred?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferdeferred");
    });
    
    $("div[id$=mainpull]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)main')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'mainpull').load('/kanban/pull_card_from_buffer_state_button?swimlane_no='+swimlane_no+'&step_no='+step_no)
    });
    
    $("div[id$=bufferghosted]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferghosted').load('/kanban/step_buffer_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferghosted");
    });
    
    $("div[id$=bufferghosted]").dblclick(function() {
        var element_id = $(this).attr('id');
        var swimlane_no = element_id.match('swimlane([0-9]+)step')[1];
        var step_no = element_id.match('step([0-9]+)buffer')[1];
        $('#swimlane'+swimlane_no+'step'+step_no+'bufferghosted').html('<img src="/images/ajax-loader.gif">').load('/kanban/step_buffer_ghosted?swimlane_no='+swimlane_no+'&step_no='+step_no).addClass("swimlanexstepxbufferghosted");
    });

    $('#backloglowlow').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=low&severity=low');
    $('#backloglowmedium').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=low&severity=medium');
    $('#backloglowhigh').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=low&severity=high');
    $('#backloglowcritical').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=low&severity=critical');
    
    $('#backlogmediumlow').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=medium&severity=low');
    $('#backlogmediummedium').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=medium&severity=medium');
    $('#backlogmediumhigh').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=medium&severity=high');
    $('#backlogmediumcritical').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=medium&severity=critical');

    $('#backloghighlow').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=high&severity=low');
    $('#backloghighmedium').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=high&severity=medium');
    $('#backloghighhigh').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=high&severity=high');
    $('#backloghighcritical').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=high&severity=critical');
 
    $('#backlogcriticallow').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=critical&severity=low');
    $('#backlogcriticalmedium').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=critical&severity=medium');
    $('#backlogcriticalhigh').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=critical&severity=high');
    $('#backlogcriticalcritical').html('<img src="/images/ajax-loader.gif">').load('/backlog/populate_backlog_kanban_column?priority=critical&severity=critical');
    
    $("div[id^=roadmap]").droppable({
        accept      : "div",
        tolerance   : "pointer",
        hoverClass  : "dragdrop"
    });
    
    $("div[id^=roadmap]").load('/kanban/ajax_loader', function() {
        var element_id = $(this).attr('id');
        var release_no = element_id.match('roadmap([0-9]+)')[1];
        $('#roadmap'+release_no).load('/visuals/roadmap_release?release_no='+release_no);
    });
 
    $('#javascriptdisabled').hide();
    
    $('#toggleCmdline').click(function() {
        if ($('#cmdline').is(':visible')) {
            $('#cmdline').hide();
            $('#toggleCmdline').val('Show Output');
        } else {
            $('#cmdline').show();
            $('#toggleCmdline').val('Hide Output');
        }
    });    
    
	$( "#search" ).autocomplete({
		source: "/search/search_autocomplete"
	});
    
    $('.absenceenddate, .absencestartdate, .blockeduntil, .deadline, .deferreduntil, .enddate, .nextaction, .startby, .startdate').datepicker({
      showOn: "button",
      dateFormat: "yy-mm-dd",
      numberOfMonths: 2
    });

    if ($(document).height() > $(window).height()) {
        $('#footer_container').css("position","relative");
    } else {
        $('#footer_container').css("position","fixed");
        $('#footer_container').css("bottom","0px");
    };    
    
});