/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp.util;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;

public class Tests {
    private Tests() {
    }

    private static void check(REMatch m, String expect, int x) {
        if (m == null || !m.toString().equals(expect)) {
            System.out.print("Failed");
        } else {
            System.out.print("Passed");
        }
        System.out.println(" test #" + x);
    }

    public static void main(String[] argv) throws REException {
        RE e = new RE("(.*)z");
        Tests.check(e.getMatch("xxz"), "xxz", 1);
        e = new RE(".*z");
        Tests.check(e.getMatch("xxz"), "xxz", 2);
        e = new RE("(x|xy)z");
        Tests.check(e.getMatch("xz"), "xz", 3);
        Tests.check(e.getMatch("xyz"), "xyz", 4);
        e = new RE("(x)+z");
        Tests.check(e.getMatch("xxz"), "xxz", 5);
        e = new RE("abc");
        Tests.check(e.getMatch("xyzabcdef"), "abc", 6);
        e = new RE("^start.*end$");
        Tests.check(e.getMatch("start here and go to the end"), "start here and go to the end", 7);
        e = new RE("(x|xy)+z");
        Tests.check(e.getMatch("xxyz"), "xxyz", 8);
        e = new RE("type=([^ \t]+)[ \t]+exts=([^ \t\n\r]+)");
        Tests.check(e.getMatch("type=text/html  exts=htm,html"), "type=text/html  exts=htm,html", 9);
        e = new RE("(x)\\1");
        Tests.check(e.getMatch("zxxz"), "xx", 10);
        e = new RE("(x*)(y)\\2\\1");
        Tests.check(e.getMatch("xxxyyxx"), "xxyyxx", 11);
        e = new RE("[-go]+");
        Tests.check(e.getMatch("go-go"), "go-go", 12);
        e = new RE("[\\w-]+");
        Tests.check(e.getMatch("go-go"), "go-go", 13);
        e = new RE("^start.*?end");
        Tests.check(e.getMatch("start here and end in the middle, not the very end"), "start here and end", 14);
        e = new RE("\\d\\s\\w\\n\\r");
        Tests.check(e.getMatch("  9\tX\n\r  "), "9\tX\n\r", 15);
        e = new RE("zow", 2);
        Tests.check(e.getMatch("ZoW"), "ZoW", 16);
        e = new RE("(\\d+)\\D*(\\d+)\\D*(\\d)+");
        Tests.check(e.getMatch("size--10 by 20 by 30 feet"), "10 by 20 by 30", 17);
        e = new RE("(ab)(.*?)(d)");
        REMatch m = e.getMatch("abcd");
        Tests.check(m, "abcd", 18);
        System.out.println((m.toString(2).equals("c") ? "Pass" : "Fail") + "ed test #19");
    }
}

