/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.cmd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.cmd.MdShellCmdDefault;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCancelException;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;
import jp.ne.nifty.iga.midori.shell.eng.MdShellListSelection;
import jp.ne.nifty.iga.midori.shell.io.MdShellDefaultStringFormatter;
import jp.ne.nifty.iga.midori.shell.util.MdShellSelectFileUtil;

public class MdShellCommandSplit
extends MdShellCmdDefault {
    private static final int FILE_LOOP_COUNT = 10;

    public MdShellCommandSplit() {
        this.setCommand("split");
        this.setDisplayString("split file into several files. (and reverse) [experimental]");
    }

    public void processCommand(MdShellEnv shellenv) throws MdShellCancelException {
        MdShellDirFileAbstract dirNodeInterface;
        Vector<String> vecList = new Vector<String>();
        vecList.addElement("divide");
        vecList.addElement("merge");
        MdShellListSelection.showVectorListWithNumberAndString(shellenv, vecList, new MdShellDefaultStringFormatter());
        shellenv.getOut().print("select what to select: ");
        MdShellDefaultStringFormatter formatter = new MdShellDefaultStringFormatter();
        String strSubCommand = formatter.format(MdShellListSelection.selectFromList(shellenv, vecList, formatter, shellenv.getNextLine()));
        if (strSubCommand == null) {
            throw new MdShellCancelException();
        }
        if (strSubCommand.equals("divide")) {
            MdShellDirFileAbstract dirNodeInterface2 = MdShellSelectFileUtil.selectFile(shellenv);
            if (dirNodeInterface2 != null) {
                this.splitFile(shellenv, dirNodeInterface2);
            }
        } else if (strSubCommand.equals("merge") && (dirNodeInterface = MdShellSelectFileUtil.selectFile(shellenv)) != null) {
            this.mergeFile(shellenv, dirNodeInterface);
        }
    }

    private void splitFile(MdShellEnv shellenv, MdShellDirFileAbstract dirfileInput) {
        MdShellCommandSplit.split(shellenv, dirfileInput);
    }

    private void mergeFile(MdShellEnv shellenv, MdShellDirFileAbstract dirfileInput) {
        MdShellCommandSplit.merge(shellenv, dirfileInput);
    }

    private static final void split(MdShellEnv shellenv, MdShellDirFileAbstract dirfileInput) {
        try {
            BufferedOutputStream outStream;
            InputStream inStream = dirfileInput.getInputStream();
            byte[] byteBuf = new byte[10000];
            int iLoop = 0;
            block2: while (true) {
                MdShellDirFileAbstract dirfileOut = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, dirfileInput.getName() + "-" + iLoop, false);
                System.out.println("processing file [" + dirfileOut.getName() + "]");
                outStream = new BufferedOutputStream(dirfileOut.getOutputStream());
                for (int readLoop = 0; readLoop < 10; ++readLoop) {
                    int iLen = inStream.read(byteBuf);
                    if (iLen <= 0) break block2;
                    ((OutputStream)outStream).write(byteBuf, 0, iLen);
                }
                ((OutputStream)outStream).flush();
                ((OutputStream)outStream).close();
                dirfileOut.setLastModified(dirfileInput.getLastModified());
                ++iLoop;
            }
            ((OutputStream)outStream).flush();
            ((OutputStream)outStream).close();
            inStream.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
    }

    private static final void merge(MdShellEnv shellenv, MdShellDirFileAbstract dirfileInput) {
        if (!dirfileInput.getName().endsWith("-0")) {
            System.out.println("aborted. " + dirfileInput.getName() + " is not generated by this program.");
            return;
        }
        String strDstFileName = dirfileInput.getName().substring(0, dirfileInput.getName().length() - 2);
        try {
            MdShellDirFileAbstract dirfileOut = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, strDstFileName, false);
            BufferedOutputStream outStream = new BufferedOutputStream(dirfileOut.getOutputStream());
            byte[] byteBuf = new byte[10000];
            int iLoop = 0;
            while (true) {
                int iLen;
                MdShellDirFileAbstract dirfileInCurrent;
                if (!(dirfileInCurrent = (MdShellDirFileAbstract)MdShellDirFactory.getInstance(shellenv, strDstFileName + "-" + iLoop, false)).canRead()) {
                    ((OutputStream)outStream).flush();
                    ((OutputStream)outStream).close();
                    break;
                }
                BufferedInputStream inStream = new BufferedInputStream(dirfileInCurrent.getInputStream());
                if (inStream == null) break;
                System.out.println("processing file [" + dirfileInCurrent.getName() + "]");
                int readLoop = 0;
                while ((iLen = ((InputStream)inStream).read(byteBuf)) > 0) {
                    ((OutputStream)outStream).write(byteBuf, 0, iLen);
                    ++readLoop;
                }
                ((InputStream)inStream).close();
                ++iLoop;
            }
            ((OutputStream)outStream).flush();
            ((OutputStream)outStream).close();
            dirfileOut.setLastModified(dirfileInput.getLastModified());
            System.out.println(dirfileOut.getName() + " is created.");
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
    }
}

