/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.dir;

import java.io.File;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryFileSystem;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryFtpClient;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryRoot;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileFileSystem;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileFtpClient;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInfo;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirNodeInterface;
import jp.ne.nifty.iga.midori.shell.eng.MdShellEnv;

public class MdShellDirFactory {
    public static final char URI_SEPARATOR_CHAR = '/';
    public static final String URI_SEPARATOR_STRING = "/";

    public static final MdShellDirNodeInterface getInstance(MdShellEnv shellenv, String strUri, boolean isDirectory) {
        switch (MdShellDirFactory.getDeviceType(strUri)) {
            case 0: {
                return new MdShellDirDirectoryRoot();
            }
            case 1: {
                String strWithoutId = MdShellDirFactory.uri2native(strUri);
                if (isDirectory) {
                    return new MdShellDirDirectoryFileSystem(shellenv, strUri, new File(strWithoutId));
                }
                return new MdShellDirFileFileSystem(shellenv, new File(strWithoutId));
            }
            case 2: {
                if (isDirectory) {
                    return new MdShellDirDirectoryFtpClient(shellenv, strUri);
                }
                return new MdShellDirFileFtpClient(shellenv, strUri);
            }
        }
        System.out.println("not implemented. at MdShellDirFactory.getInstance(" + strUri + ")");
        return null;
    }

    public static final String trimDeviceName(String strUri) {
        int iType = MdShellDirFactory.getDeviceType(strUri);
        if (iType >= 0) {
            return strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
        }
        return strUri;
    }

    public static final String uri2native(String strUri) {
        int iType = MdShellDirFactory.getDeviceType(strUri);
        if (iType >= 0) {
            strUri = strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
        }
        if (strUri.indexOf(58) >= 0 && strUri.startsWith(URI_SEPARATOR_STRING)) {
            strUri = strUri.substring(1);
        }
        return strUri.replace('/', MdShellDirFactory.getNativeFsSeparatorChar());
    }

    public static final String native2uri(String strLocalPathName) {
        int iType = MdShellDirFactory.getDeviceType(strLocalPathName);
        if (iType >= 0) {
            strLocalPathName = strLocalPathName.substring(MdShellDirNodeInfo.SZ_PROTOCOL[iType].length());
        }
        if (!(strLocalPathName = strLocalPathName.replace(MdShellDirFactory.getNativeFsSeparatorChar(), '/')).startsWith(URI_SEPARATOR_STRING)) {
            strLocalPathName = URI_SEPARATOR_STRING + strLocalPathName;
        }
        return MdShellDirNodeInfo.SZ_PROTOCOL[1] + strLocalPathName;
    }

    public static final char getNativeFsSeparatorChar() {
        String strSeparator = MdShellDirFactory.getNativeFsSeparator();
        return strSeparator.charAt(0);
    }

    public static final String getNativeFsSeparator() {
        return System.getProperty("file.separator");
    }

    public static final int getDeviceType(String strUri) {
        for (int index = 0; index < MdShellDirNodeInfo.SZ_PROTOCOL.length; ++index) {
            if (!strUri.startsWith(MdShellDirNodeInfo.SZ_PROTOCOL[index])) continue;
            return index;
        }
        return -1;
    }

    public static final String getDirectory(String strUri, boolean isUriDirectoryName) {
        int iFind;
        String strDirectory = strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[2].length());
        if (strDirectory.length() == 0) {
            return URI_SEPARATOR_STRING;
        }
        if (strDirectory.charAt(0) != '/') {
            iFind = strDirectory.indexOf(47);
            strDirectory = iFind < 0 ? URI_SEPARATOR_STRING : strDirectory.substring(iFind);
        }
        if (!isUriDirectoryName && (iFind = strDirectory.lastIndexOf(47)) >= 0) {
            strDirectory = strDirectory.substring(0, iFind);
        }
        if (strDirectory.length() == 0) {
            strDirectory = URI_SEPARATOR_STRING;
        }
        return strDirectory;
    }

    public static final String getHostName(String strUri) {
        String strWithoutId = strUri.substring(MdShellDirNodeInfo.SZ_PROTOCOL[2].length());
        String strHostName = "";
        int iFind = strWithoutId.indexOf(47);
        strHostName = iFind < 0 ? strWithoutId : strWithoutId.substring(0, iFind);
        return strHostName;
    }

    public static final String quoteFileNameWhenSpaceIsExist(String strArg) {
        if (strArg.indexOf(32) < 0) {
            return strArg;
        }
        return "\"" + strArg + "\"";
    }

    public static final String getWindowsRootStyle() {
        return ":/";
    }

    public static final String getShortName(String strFullName) {
        if ((strFullName = MdShellDirFactory.trimDeviceName(strFullName)).length() == 1) {
            return strFullName;
        }
        int iFindCut = strFullName.lastIndexOf(47);
        if (iFindCut < 0) {
            return null;
        }
        boolean isEndWithWindowsRootStyle = strFullName.endsWith(MdShellDirFactory.getWindowsRootStyle());
        if (isEndWithWindowsRootStyle) {
            return strFullName;
        }
        return strFullName.substring(iFindCut + 1);
    }

    public static final String getPathWithoutShortName(String strFullName) {
        int iFindCut = strFullName.lastIndexOf(47);
        if (iFindCut < 0) {
            return null;
        }
        int iFindFirst = strFullName.indexOf(47);
        boolean isEndWith = strFullName.endsWith(URI_SEPARATOR_STRING);
        if (iFindCut == iFindFirst && isEndWith) {
            return strFullName;
        }
        if ((strFullName = strFullName.substring(0, iFindCut)).length() == 0) {
            strFullName = URI_SEPARATOR_STRING;
        }
        return strFullName;
    }
}

