/*
 * Decompiled with CFR 0.152.
 */
package jp.ne.nifty.iga.midori.shell.eng;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.Collator;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirDirectoryAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFactory;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileAbstract;
import jp.ne.nifty.iga.midori.shell.dir.MdShellDirFileFileSystem;
import jp.ne.nifty.iga.midori.shell.dir.MdShellFtpServerNode;
import jp.ne.nifty.iga.midori.shell.eng.MdShellCmdList;
import jp.ne.nifty.iga.midori.shell.eng.MdShellDirectoryHistory;
import jp.ne.nifty.iga.midori.shell.eng.MdShellFileHistory;
import jp.ne.nifty.iga.midori.shell.eng.MdShellHistory;
import jp.ne.nifty.iga.midori.shell.util.MdShellUtilString;

public class MdShellEnv {
    private MdShellCmdList commandlist = new MdShellCmdList();
    private MdShellFileHistory historyFile = new MdShellFileHistory();
    private MdShellDirectoryHistory historyDirectory = new MdShellDirectoryHistory();
    private MdShellDirDirectoryAbstract dirDirectoryCurrent = null;
    private MdShellDirFileAbstract dirDirectoryStart = null;
    private Collator collator = null;
    private String strOriginalLine = null;
    private StringTokenizer toknizerTab = null;
    private InputStream currentIn = null;
    private PrintStream currentOut = null;
    private PrintStream currentErr = null;
    private Hashtable hashFtpServerList = null;

    public void init() {
        try {
            this.dirDirectoryStart = (MdShellDirFileFileSystem)MdShellDirFactory.getInstance(this, MdShellDirFactory.native2uri(new File(".").getCanonicalPath()), false);
        }
        catch (IOException ex) {
            this.getOut().println(ex.toString());
            ex.printStackTrace(this.getOut());
        }
        this.dirDirectoryCurrent = this.dirDirectoryStart.getPath();
        this.historyFile.init();
        this.historyDirectory.init();
        this.getDirectoryHistory().addHistory(this.dirDirectoryCurrent.getName());
        try {
            String strRead;
            Hashtable<String, MdShellFtpServerNode> hashFtpServerList = new Hashtable<String, MdShellFtpServerNode>(256);
            File fileLoad = new File("MdShellFtp.def");
            if (!fileLoad.exists()) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(fileLoad));
            while ((strRead = reader.readLine()) != null) {
                StringTokenizer toknizerTab = new StringTokenizer(strRead, "\t\n", false);
                try {
                    MdShellFtpServerNode ftpservernode = new MdShellFtpServerNode();
                    ftpservernode.strHostName = toknizerTab.nextToken();
                    ftpservernode.strUser = toknizerTab.nextToken();
                    ftpservernode.strPassword = toknizerTab.nextToken();
                    hashFtpServerList.put(ftpservernode.strHostName, ftpservernode);
                }
                catch (NoSuchElementException ex) {}
            }
            reader.close();
            this.setFtpServerList(hashFtpServerList);
        }
        catch (IOException ex) {
            this.getOut().println(ex.toString());
            ex.printStackTrace(this.getOut());
        }
    }

    public void save() {
        this.historyFile.save();
        this.historyDirectory.save();
    }

    public void close() {
    }

    public MdShellDirDirectoryAbstract getCurrentDirectory() {
        return this.dirDirectoryCurrent;
    }

    public void setCurrentDirectory(MdShellDirDirectoryAbstract dirDirectoryCurrent) {
        this.dirDirectoryCurrent = dirDirectoryCurrent;
    }

    public void cdParentDirectory() {
        this.dirDirectoryCurrent = this.dirDirectoryCurrent.getParentDirectory();
    }

    public Vector getFileHistory() {
        return this.historyFile.getHistory();
    }

    public MdShellHistory getDirectoryHistory() {
        return this.historyDirectory;
    }

    public MdShellCmdList getCommandList() {
        return this.commandlist;
    }

    public InputStream getChildProcessInputStream() {
        return this.getIn();
    }

    public final Collator getCollatorInstance() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
            this.collator.setStrength(0);
            this.collator.setDecomposition(2);
        }
        return this.collator;
    }

    public final void clearLine() {
        this.strOriginalLine = null;
        this.toknizerTab = null;
    }

    public final boolean hasMoreTokensWithoutInput() {
        return this.toknizerTab.hasMoreTokens();
    }

    public final String getOriginalReadLine() {
        return this.strOriginalLine;
    }

    public final String[] getArgsArray() {
        Vector<String> vecArgs = new Vector<String>();
        while (this.hasMoreTokensWithoutInput()) {
            String strNextLine = this.getNextLine();
            vecArgs.addElement(strNextLine);
        }
        String[] args = new String[vecArgs.size()];
        for (int index = 0; index < vecArgs.size(); ++index) {
            args[index] = (String)vecArgs.elementAt(index);
        }
        return args;
    }

    public final String getNextLine() {
        this.promptInputIfNoDataExist();
        String strRead = this.tryReadTokenFromToken();
        if (strRead != null) {
            return strRead;
        }
        return null;
    }

    public final void promptInputIfNoDataExist() {
        if (this.toknizerTab != null && !this.toknizerTab.hasMoreTokens()) {
            this.toknizerTab = null;
        }
        if (this.toknizerTab == null) {
            String strLine;
            this.strOriginalLine = strLine = MdShellUtilString.readLine(this.getIn());
            this.toknizerTab = new StringTokenizer(strLine, " \t\n", false);
        }
    }

    private final String tryReadTokenFromToken() {
        if (this.toknizerTab != null) {
            String strSubLine = null;
            try {
                strSubLine = this.toknizerTab.nextToken();
                return strSubLine;
            }
            catch (NoSuchElementException ex) {
                this.toknizerTab = null;
            }
        }
        return null;
    }

    public void setIn(InputStream inputArg) {
        this.currentIn = inputArg;
    }

    public InputStream getIn() {
        return this.currentIn;
    }

    public void setOut(PrintStream printArg) {
        this.currentOut = printArg;
    }

    public PrintStream getOut() {
        return this.currentOut;
    }

    public void setErr(PrintStream printArg) {
        this.currentErr = printArg;
    }

    public PrintStream getErr() {
        return this.currentErr;
    }

    public void setFtpServerList(Hashtable hashFtpServerList) {
        this.hashFtpServerList = hashFtpServerList;
    }

    public Hashtable getFtpServerList() {
        return this.hashFtpServerList;
    }
}

